# coding: utf-8

"""
    UltraCart Rest API V2

    UltraCart REST API Version 2  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@ultracart.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ultracart.api_client import ApiClient
from ultracart.configuration import Configuration

class CustomerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    @classmethod
    def fromApiKey(cls, apiKey, verify_ssl = True, debug = False):
        config = Configuration()
        config.api_key['x-ultracart-simple-key'] = apiKey
        config.debug = debug
        config.verify_ssl = verify_ssl

        api_client = ApiClient(configuration=config, header_name='X-UltraCart-Api-Version', header_value='2017-03-01')
        return CustomerApi(api_client)




    def add_customer_store_credit(self, customer_profile_oid, store_credit_request, **kwargs):  # noqa: E501
        """Adds store credit to a customer  # noqa: E501

        Adds store credit to a customer   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_customer_store_credit(customer_profile_oid, store_credit_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_profile_oid: The customer oid to credit. (required)
        :param CustomerStoreCreditAddRequest store_credit_request: Store credit to add (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_customer_store_credit_with_http_info(customer_profile_oid, store_credit_request, **kwargs)  # noqa: E501
        else:
            (data) = self.add_customer_store_credit_with_http_info(customer_profile_oid, store_credit_request, **kwargs)  # noqa: E501
            return data

    def add_customer_store_credit_with_http_info(self, customer_profile_oid, store_credit_request, **kwargs):  # noqa: E501
        """Adds store credit to a customer  # noqa: E501

        Adds store credit to a customer   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_customer_store_credit_with_http_info(customer_profile_oid, store_credit_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_profile_oid: The customer oid to credit. (required)
        :param CustomerStoreCreditAddRequest store_credit_request: Store credit to add (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_profile_oid', 'store_credit_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_customer_store_credit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_profile_oid' is set
        if ('customer_profile_oid' not in params or
                params['customer_profile_oid'] is None):
            raise ValueError("Missing the required parameter `customer_profile_oid` when calling `add_customer_store_credit`")  # noqa: E501
        # verify the required parameter 'store_credit_request' is set
        if ('store_credit_request' not in params or
                params['store_credit_request'] is None):
            raise ValueError("Missing the required parameter `store_credit_request` when calling `add_customer_store_credit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_profile_oid' in params:
            path_params['customer_profile_oid'] = params['customer_profile_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'store_credit_request' in params:
            body_params = params['store_credit_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/customer/customers/{customer_profile_oid}/store_credit', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def adjust_internal_certificate(self, customer_profile_oid, adjust_internal_certificate_request, **kwargs):  # noqa: E501
        """Updates the cashback balance for a customer by updating the internal gift certificate used, creating the gift certificate if needed.  # noqa: E501

        Updates the cashback balance for a customer by updating the internal gift certificate used, creating the gift certificate if needed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.adjust_internal_certificate(customer_profile_oid, adjust_internal_certificate_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_profile_oid: The customer profile oid (required)
        :param AdjustInternalCertificateRequest adjust_internal_certificate_request: adjustInternalCertificateRequest (required)
        :return: AdjustInternalCertificateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.adjust_internal_certificate_with_http_info(customer_profile_oid, adjust_internal_certificate_request, **kwargs)  # noqa: E501
        else:
            (data) = self.adjust_internal_certificate_with_http_info(customer_profile_oid, adjust_internal_certificate_request, **kwargs)  # noqa: E501
            return data

    def adjust_internal_certificate_with_http_info(self, customer_profile_oid, adjust_internal_certificate_request, **kwargs):  # noqa: E501
        """Updates the cashback balance for a customer by updating the internal gift certificate used, creating the gift certificate if needed.  # noqa: E501

        Updates the cashback balance for a customer by updating the internal gift certificate used, creating the gift certificate if needed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.adjust_internal_certificate_with_http_info(customer_profile_oid, adjust_internal_certificate_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_profile_oid: The customer profile oid (required)
        :param AdjustInternalCertificateRequest adjust_internal_certificate_request: adjustInternalCertificateRequest (required)
        :return: AdjustInternalCertificateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_profile_oid', 'adjust_internal_certificate_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method adjust_internal_certificate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_profile_oid' is set
        if ('customer_profile_oid' not in params or
                params['customer_profile_oid'] is None):
            raise ValueError("Missing the required parameter `customer_profile_oid` when calling `adjust_internal_certificate`")  # noqa: E501
        # verify the required parameter 'adjust_internal_certificate_request' is set
        if ('adjust_internal_certificate_request' not in params or
                params['adjust_internal_certificate_request'] is None):
            raise ValueError("Missing the required parameter `adjust_internal_certificate_request` when calling `adjust_internal_certificate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_profile_oid' in params:
            path_params['customer_profile_oid'] = params['customer_profile_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'adjust_internal_certificate_request' in params:
            body_params = params['adjust_internal_certificate_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/customer/customers/{customer_profile_oid}/adjust_cashback_balance', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdjustInternalCertificateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_customer(self, customer_profile_oid, **kwargs):  # noqa: E501
        """Delete a customer  # noqa: E501

        Delete a customer on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_customer(customer_profile_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_profile_oid: The customer_profile_oid to delete. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_customer_with_http_info(customer_profile_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_customer_with_http_info(customer_profile_oid, **kwargs)  # noqa: E501
            return data

    def delete_customer_with_http_info(self, customer_profile_oid, **kwargs):  # noqa: E501
        """Delete a customer  # noqa: E501

        Delete a customer on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_customer_with_http_info(customer_profile_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_profile_oid: The customer_profile_oid to delete. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_profile_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_customer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_profile_oid' is set
        if ('customer_profile_oid' not in params or
                params['customer_profile_oid'] is None):
            raise ValueError("Missing the required parameter `customer_profile_oid` when calling `delete_customer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_profile_oid' in params:
            path_params['customer_profile_oid'] = params['customer_profile_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/customer/customers/{customer_profile_oid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer(self, customer_profile_oid, **kwargs):  # noqa: E501
        """Retrieve a customer  # noqa: E501

        Retrieves a single customer using the specified customer profile oid.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer(customer_profile_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_profile_oid: The customer oid to retrieve. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CustomerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_with_http_info(customer_profile_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_with_http_info(customer_profile_oid, **kwargs)  # noqa: E501
            return data

    def get_customer_with_http_info(self, customer_profile_oid, **kwargs):  # noqa: E501
        """Retrieve a customer  # noqa: E501

        Retrieves a single customer using the specified customer profile oid.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_with_http_info(customer_profile_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_profile_oid: The customer oid to retrieve. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CustomerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_profile_oid', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_profile_oid' is set
        if ('customer_profile_oid' not in params or
                params['customer_profile_oid'] is None):
            raise ValueError("Missing the required parameter `customer_profile_oid` when calling `get_customer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_profile_oid' in params:
            path_params['customer_profile_oid'] = params['customer_profile_oid']  # noqa: E501

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/customer/customers/{customer_profile_oid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_by_email(self, email, **kwargs):  # noqa: E501
        """Retrieve a customer by Email  # noqa: E501

        Retrieves a single customer using the specified customer email address.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_by_email(email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str email: The email address of the customer to retrieve. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CustomerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_by_email_with_http_info(email, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_by_email_with_http_info(email, **kwargs)  # noqa: E501
            return data

    def get_customer_by_email_with_http_info(self, email, **kwargs):  # noqa: E501
        """Retrieve a customer by Email  # noqa: E501

        Retrieves a single customer using the specified customer email address.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_by_email_with_http_info(email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str email: The email address of the customer to retrieve. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CustomerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_by_email" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'email' is set
        if ('email' not in params or
                params['email'] is None):
            raise ValueError("Missing the required parameter `email` when calling `get_customer_by_email`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'email' in params:
            path_params['email'] = params['email']  # noqa: E501

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/customer/customers/by_email/{email}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_editor_values(self, **kwargs):  # noqa: E501
        """Retrieve values needed for a customer profile editor  # noqa: E501

        Retrieve values needed for a customer profile editor.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_editor_values(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CustomerEditorValues
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_editor_values_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_editor_values_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_customer_editor_values_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve values needed for a customer profile editor  # noqa: E501

        Retrieve values needed for a customer profile editor.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_editor_values_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CustomerEditorValues
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_editor_values" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/customer/editor_values', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerEditorValues',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_email_lists(self, **kwargs):  # noqa: E501
        """Retrieve all email lists across all storefronts  # noqa: E501

        Retrieve all email lists across all storefronts   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_email_lists(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: EmailListsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_email_lists_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_email_lists_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_customer_email_lists_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve all email lists across all storefronts  # noqa: E501

        Retrieve all email lists across all storefronts   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_email_lists_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: EmailListsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_email_lists" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/customer/email_lists', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailListsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_store_credit(self, customer_profile_oid, **kwargs):  # noqa: E501
        """Retrieve the customer store credit accumulated through loyalty programs  # noqa: E501

        Retrieve the customer store credit accumulated through loyalty programs   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_store_credit(customer_profile_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_profile_oid: The customer oid to retrieve. (required)
        :return: CustomerStoreCreditResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_store_credit_with_http_info(customer_profile_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_store_credit_with_http_info(customer_profile_oid, **kwargs)  # noqa: E501
            return data

    def get_customer_store_credit_with_http_info(self, customer_profile_oid, **kwargs):  # noqa: E501
        """Retrieve the customer store credit accumulated through loyalty programs  # noqa: E501

        Retrieve the customer store credit accumulated through loyalty programs   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_store_credit_with_http_info(customer_profile_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_profile_oid: The customer oid to retrieve. (required)
        :return: CustomerStoreCreditResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_profile_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_store_credit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_profile_oid' is set
        if ('customer_profile_oid' not in params or
                params['customer_profile_oid'] is None):
            raise ValueError("Missing the required parameter `customer_profile_oid` when calling `get_customer_store_credit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_profile_oid' in params:
            path_params['customer_profile_oid'] = params['customer_profile_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/customer/customers/{customer_profile_oid}/store_credit', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerStoreCreditResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customers(self, **kwargs):  # noqa: E501
        """Retrieve customers  # noqa: E501

        Retrieves customers from the account.  If no parameters are specified, all customers will be returned.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str email: Email
        :param str qb_class: Quickbooks class
        :param str quickbooks_code: Quickbooks code
        :param str last_modified_dts_start: Last modified date start
        :param str last_modified_dts_end: Last modified date end
        :param str signup_dts_start: Signup date start
        :param str signup_dts_end: Signup date end
        :param str billing_first_name: Billing first name
        :param str billing_last_name: Billing last name
        :param str billing_company: Billing company
        :param str billing_city: Billing city
        :param str billing_state: Billing state
        :param str billing_postal_code: Billing postal code
        :param str billing_country_code: Billing country code
        :param str billing_day_phone: Billing day phone
        :param str billing_evening_phone: Billing evening phone
        :param str shipping_first_name: Shipping first name
        :param str shipping_last_name: Shipping last name
        :param str shipping_company: Shipping company
        :param str shipping_city: Shipping city
        :param str shipping_state: Shipping state
        :param str shipping_postal_code: Shipping postal code
        :param str shipping_country_code: Shipping country code
        :param str shipping_day_phone: Shipping day phone
        :param str shipping_evening_phone: Shipping evening phone
        :param int pricing_tier_oid: Pricing tier oid
        :param str pricing_tier_name: Pricing tier name
        :param int limit: The maximum number of records to return on this one API call. (Max 200)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str since: Fetch customers that have been created/modified since this date/time.
        :param str sort: The sort order of the customers.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CustomersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_customers_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_customers_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve customers  # noqa: E501

        Retrieves customers from the account.  If no parameters are specified, all customers will be returned.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str email: Email
        :param str qb_class: Quickbooks class
        :param str quickbooks_code: Quickbooks code
        :param str last_modified_dts_start: Last modified date start
        :param str last_modified_dts_end: Last modified date end
        :param str signup_dts_start: Signup date start
        :param str signup_dts_end: Signup date end
        :param str billing_first_name: Billing first name
        :param str billing_last_name: Billing last name
        :param str billing_company: Billing company
        :param str billing_city: Billing city
        :param str billing_state: Billing state
        :param str billing_postal_code: Billing postal code
        :param str billing_country_code: Billing country code
        :param str billing_day_phone: Billing day phone
        :param str billing_evening_phone: Billing evening phone
        :param str shipping_first_name: Shipping first name
        :param str shipping_last_name: Shipping last name
        :param str shipping_company: Shipping company
        :param str shipping_city: Shipping city
        :param str shipping_state: Shipping state
        :param str shipping_postal_code: Shipping postal code
        :param str shipping_country_code: Shipping country code
        :param str shipping_day_phone: Shipping day phone
        :param str shipping_evening_phone: Shipping evening phone
        :param int pricing_tier_oid: Pricing tier oid
        :param str pricing_tier_name: Pricing tier name
        :param int limit: The maximum number of records to return on this one API call. (Max 200)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str since: Fetch customers that have been created/modified since this date/time.
        :param str sort: The sort order of the customers.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CustomersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email', 'qb_class', 'quickbooks_code', 'last_modified_dts_start', 'last_modified_dts_end', 'signup_dts_start', 'signup_dts_end', 'billing_first_name', 'billing_last_name', 'billing_company', 'billing_city', 'billing_state', 'billing_postal_code', 'billing_country_code', 'billing_day_phone', 'billing_evening_phone', 'shipping_first_name', 'shipping_last_name', 'shipping_company', 'shipping_city', 'shipping_state', 'shipping_postal_code', 'shipping_country_code', 'shipping_day_phone', 'shipping_evening_phone', 'pricing_tier_oid', 'pricing_tier_name', 'limit', 'offset', 'since', 'sort', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'email' in params:
            query_params.append(('email', params['email']))  # noqa: E501
        if 'qb_class' in params:
            query_params.append(('qb_class', params['qb_class']))  # noqa: E501
        if 'quickbooks_code' in params:
            query_params.append(('quickbooks_code', params['quickbooks_code']))  # noqa: E501
        if 'last_modified_dts_start' in params:
            query_params.append(('last_modified_dts_start', params['last_modified_dts_start']))  # noqa: E501
        if 'last_modified_dts_end' in params:
            query_params.append(('last_modified_dts_end', params['last_modified_dts_end']))  # noqa: E501
        if 'signup_dts_start' in params:
            query_params.append(('signup_dts_start', params['signup_dts_start']))  # noqa: E501
        if 'signup_dts_end' in params:
            query_params.append(('signup_dts_end', params['signup_dts_end']))  # noqa: E501
        if 'billing_first_name' in params:
            query_params.append(('billing_first_name', params['billing_first_name']))  # noqa: E501
        if 'billing_last_name' in params:
            query_params.append(('billing_last_name', params['billing_last_name']))  # noqa: E501
        if 'billing_company' in params:
            query_params.append(('billing_company', params['billing_company']))  # noqa: E501
        if 'billing_city' in params:
            query_params.append(('billing_city', params['billing_city']))  # noqa: E501
        if 'billing_state' in params:
            query_params.append(('billing_state', params['billing_state']))  # noqa: E501
        if 'billing_postal_code' in params:
            query_params.append(('billing_postal_code', params['billing_postal_code']))  # noqa: E501
        if 'billing_country_code' in params:
            query_params.append(('billing_country_code', params['billing_country_code']))  # noqa: E501
        if 'billing_day_phone' in params:
            query_params.append(('billing_day_phone', params['billing_day_phone']))  # noqa: E501
        if 'billing_evening_phone' in params:
            query_params.append(('billing_evening_phone', params['billing_evening_phone']))  # noqa: E501
        if 'shipping_first_name' in params:
            query_params.append(('shipping_first_name', params['shipping_first_name']))  # noqa: E501
        if 'shipping_last_name' in params:
            query_params.append(('shipping_last_name', params['shipping_last_name']))  # noqa: E501
        if 'shipping_company' in params:
            query_params.append(('shipping_company', params['shipping_company']))  # noqa: E501
        if 'shipping_city' in params:
            query_params.append(('shipping_city', params['shipping_city']))  # noqa: E501
        if 'shipping_state' in params:
            query_params.append(('shipping_state', params['shipping_state']))  # noqa: E501
        if 'shipping_postal_code' in params:
            query_params.append(('shipping_postal_code', params['shipping_postal_code']))  # noqa: E501
        if 'shipping_country_code' in params:
            query_params.append(('shipping_country_code', params['shipping_country_code']))  # noqa: E501
        if 'shipping_day_phone' in params:
            query_params.append(('shipping_day_phone', params['shipping_day_phone']))  # noqa: E501
        if 'shipping_evening_phone' in params:
            query_params.append(('shipping_evening_phone', params['shipping_evening_phone']))  # noqa: E501
        if 'pricing_tier_oid' in params:
            query_params.append(('pricing_tier_oid', params['pricing_tier_oid']))  # noqa: E501
        if 'pricing_tier_name' in params:
            query_params.append(('pricing_tier_name', params['pricing_tier_name']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('_limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('_offset', params['offset']))  # noqa: E501
        if 'since' in params:
            query_params.append(('_since', params['since']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('_sort', params['sort']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/customer/customers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customers_by_query(self, customer_query, **kwargs):  # noqa: E501
        """Retrieve customers by query  # noqa: E501

        Retrieves customers from the account.  If no parameters are specified, all customers will be returned.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_by_query(customer_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomerQuery customer_query: Customer query (required)
        :param int limit: The maximum number of records to return on this one API call. (Max 200)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str since: Fetch customers that have been created/modified since this date/time.
        :param str sort: The sort order of the customers.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CustomersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customers_by_query_with_http_info(customer_query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customers_by_query_with_http_info(customer_query, **kwargs)  # noqa: E501
            return data

    def get_customers_by_query_with_http_info(self, customer_query, **kwargs):  # noqa: E501
        """Retrieve customers by query  # noqa: E501

        Retrieves customers from the account.  If no parameters are specified, all customers will be returned.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_by_query_with_http_info(customer_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomerQuery customer_query: Customer query (required)
        :param int limit: The maximum number of records to return on this one API call. (Max 200)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str since: Fetch customers that have been created/modified since this date/time.
        :param str sort: The sort order of the customers.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CustomersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_query', 'limit', 'offset', 'since', 'sort', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customers_by_query" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_query' is set
        if ('customer_query' not in params or
                params['customer_query'] is None):
            raise ValueError("Missing the required parameter `customer_query` when calling `get_customers_by_query`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('_limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('_offset', params['offset']))  # noqa: E501
        if 'since' in params:
            query_params.append(('_since', params['since']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('_sort', params['sort']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'customer_query' in params:
            body_params = params['customer_query']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/customer/customers/query', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customers_for_data_tables(self, **kwargs):  # noqa: E501
        """Retrieve customers for DataTables plugin  # noqa: E501

        Retrieves customers from the account.  If no searches are specified, all customers will be returned.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_for_data_tables(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: DataTablesServerSideResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customers_for_data_tables_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_customers_for_data_tables_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_customers_for_data_tables_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve customers for DataTables plugin  # noqa: E501

        Retrieves customers from the account.  If no searches are specified, all customers will be returned.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_for_data_tables_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: DataTablesServerSideResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customers_for_data_tables" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/customer/customers/dataTables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataTablesServerSideResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_verification_token(self, token_request, **kwargs):  # noqa: E501
        """Create a token that can be used to verify a customer email address  # noqa: E501

        Create a token that can be used to verify a customer email address.  The implementation of how a customer interacts with this token is left to the merchant.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_verification_token(token_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmailVerifyTokenRequest token_request: Token request (required)
        :return: EmailVerifyTokenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_verification_token_with_http_info(token_request, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_verification_token_with_http_info(token_request, **kwargs)  # noqa: E501
            return data

    def get_email_verification_token_with_http_info(self, token_request, **kwargs):  # noqa: E501
        """Create a token that can be used to verify a customer email address  # noqa: E501

        Create a token that can be used to verify a customer email address.  The implementation of how a customer interacts with this token is left to the merchant.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_verification_token_with_http_info(token_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmailVerifyTokenRequest token_request: Token request (required)
        :return: EmailVerifyTokenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['token_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_verification_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'token_request' is set
        if ('token_request' not in params or
                params['token_request'] is None):
            raise ValueError("Missing the required parameter `token_request` when calling `get_email_verification_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'token_request' in params:
            body_params = params['token_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/customer/customers/email_verify/get_token', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailVerifyTokenResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert_customer(self, customer, **kwargs):  # noqa: E501
        """Insert a customer  # noqa: E501

        Insert a customer on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_customer(customer, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Customer customer: Customer to insert (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CustomerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_customer_with_http_info(customer, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_customer_with_http_info(customer, **kwargs)  # noqa: E501
            return data

    def insert_customer_with_http_info(self, customer, **kwargs):  # noqa: E501
        """Insert a customer  # noqa: E501

        Insert a customer on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_customer_with_http_info(customer, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Customer customer: Customer to insert (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CustomerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert_customer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer' is set
        if ('customer' not in params or
                params['customer'] is None):
            raise ValueError("Missing the required parameter `customer` when calling `insert_customer`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'customer' in params:
            body_params = params['customer']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/customer/customers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def merge_customer(self, customer, customer_profile_oid, **kwargs):  # noqa: E501
        """Merge customer into this customer  # noqa: E501

        Merge customer into this customer.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.merge_customer(customer, customer_profile_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomerMergeRequest customer: Customer to merge into this profile. (required)
        :param int customer_profile_oid: The customer_profile_oid to update. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.merge_customer_with_http_info(customer, customer_profile_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.merge_customer_with_http_info(customer, customer_profile_oid, **kwargs)  # noqa: E501
            return data

    def merge_customer_with_http_info(self, customer, customer_profile_oid, **kwargs):  # noqa: E501
        """Merge customer into this customer  # noqa: E501

        Merge customer into this customer.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.merge_customer_with_http_info(customer, customer_profile_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomerMergeRequest customer: Customer to merge into this profile. (required)
        :param int customer_profile_oid: The customer_profile_oid to update. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer', 'customer_profile_oid', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method merge_customer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer' is set
        if ('customer' not in params or
                params['customer'] is None):
            raise ValueError("Missing the required parameter `customer` when calling `merge_customer`")  # noqa: E501
        # verify the required parameter 'customer_profile_oid' is set
        if ('customer_profile_oid' not in params or
                params['customer_profile_oid'] is None):
            raise ValueError("Missing the required parameter `customer_profile_oid` when calling `merge_customer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_profile_oid' in params:
            path_params['customer_profile_oid'] = params['customer_profile_oid']  # noqa: E501

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'customer' in params:
            body_params = params['customer']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/customer/customers/{customer_profile_oid}/merge', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_customer_profile_values(self, lookup_request, **kwargs):  # noqa: E501
        """Searches for all matching values (using POST)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_customer_profile_values(lookup_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LookupRequest lookup_request: LookupRequest (required)
        :return: LookupResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_customer_profile_values_with_http_info(lookup_request, **kwargs)  # noqa: E501
        else:
            (data) = self.search_customer_profile_values_with_http_info(lookup_request, **kwargs)  # noqa: E501
            return data

    def search_customer_profile_values_with_http_info(self, lookup_request, **kwargs):  # noqa: E501
        """Searches for all matching values (using POST)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_customer_profile_values_with_http_info(lookup_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LookupRequest lookup_request: LookupRequest (required)
        :return: LookupResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lookup_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_customer_profile_values" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lookup_request' is set
        if ('lookup_request' not in params or
                params['lookup_request'] is None):
            raise ValueError("Missing the required parameter `lookup_request` when calling `search_customer_profile_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'lookup_request' in params:
            body_params = params['lookup_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/customer/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LookupResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_customer(self, customer, customer_profile_oid, **kwargs):  # noqa: E501
        """Update a customer  # noqa: E501

        Update a customer on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer(customer, customer_profile_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Customer customer: Customer to update (required)
        :param int customer_profile_oid: The customer_profile_oid to update. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CustomerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_customer_with_http_info(customer, customer_profile_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.update_customer_with_http_info(customer, customer_profile_oid, **kwargs)  # noqa: E501
            return data

    def update_customer_with_http_info(self, customer, customer_profile_oid, **kwargs):  # noqa: E501
        """Update a customer  # noqa: E501

        Update a customer on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_with_http_info(customer, customer_profile_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Customer customer: Customer to update (required)
        :param int customer_profile_oid: The customer_profile_oid to update. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CustomerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer', 'customer_profile_oid', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_customer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer' is set
        if ('customer' not in params or
                params['customer'] is None):
            raise ValueError("Missing the required parameter `customer` when calling `update_customer`")  # noqa: E501
        # verify the required parameter 'customer_profile_oid' is set
        if ('customer_profile_oid' not in params or
                params['customer_profile_oid'] is None):
            raise ValueError("Missing the required parameter `customer_profile_oid` when calling `update_customer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_profile_oid' in params:
            path_params['customer_profile_oid'] = params['customer_profile_oid']  # noqa: E501

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'customer' in params:
            body_params = params['customer']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/customer/customers/{customer_profile_oid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_customer_email_lists(self, customer_profile_oid, list_changes, **kwargs):  # noqa: E501
        """Update email list subscriptions for a customer  # noqa: E501

        Update email list subscriptions for a customer   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_email_lists(customer_profile_oid, list_changes, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_profile_oid: The customer profile oid (required)
        :param CustomerEmailListChanges list_changes: List changes (required)
        :return: CustomerEmailListChanges
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_customer_email_lists_with_http_info(customer_profile_oid, list_changes, **kwargs)  # noqa: E501
        else:
            (data) = self.update_customer_email_lists_with_http_info(customer_profile_oid, list_changes, **kwargs)  # noqa: E501
            return data

    def update_customer_email_lists_with_http_info(self, customer_profile_oid, list_changes, **kwargs):  # noqa: E501
        """Update email list subscriptions for a customer  # noqa: E501

        Update email list subscriptions for a customer   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_email_lists_with_http_info(customer_profile_oid, list_changes, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_profile_oid: The customer profile oid (required)
        :param CustomerEmailListChanges list_changes: List changes (required)
        :return: CustomerEmailListChanges
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_profile_oid', 'list_changes']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_customer_email_lists" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_profile_oid' is set
        if ('customer_profile_oid' not in params or
                params['customer_profile_oid'] is None):
            raise ValueError("Missing the required parameter `customer_profile_oid` when calling `update_customer_email_lists`")  # noqa: E501
        # verify the required parameter 'list_changes' is set
        if ('list_changes' not in params or
                params['list_changes'] is None):
            raise ValueError("Missing the required parameter `list_changes` when calling `update_customer_email_lists`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_profile_oid' in params:
            path_params['customer_profile_oid'] = params['customer_profile_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'list_changes' in params:
            body_params = params['list_changes']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/customer/customers/{customer_profile_oid}/email_lists', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerEmailListChanges',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def validate_email_verification_token(self, validation_request, **kwargs):  # noqa: E501
        """Validate a token that can be used to verify a customer email address  # noqa: E501

        Validate a token that can be used to verify a customer email address.  The implementation of how a customer interacts with this token is left to the merchant.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_email_verification_token(validation_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmailVerifyTokenValidateRequest validation_request: Token validation request (required)
        :return: EmailVerifyTokenValidateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.validate_email_verification_token_with_http_info(validation_request, **kwargs)  # noqa: E501
        else:
            (data) = self.validate_email_verification_token_with_http_info(validation_request, **kwargs)  # noqa: E501
            return data

    def validate_email_verification_token_with_http_info(self, validation_request, **kwargs):  # noqa: E501
        """Validate a token that can be used to verify a customer email address  # noqa: E501

        Validate a token that can be used to verify a customer email address.  The implementation of how a customer interacts with this token is left to the merchant.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_email_verification_token_with_http_info(validation_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmailVerifyTokenValidateRequest validation_request: Token validation request (required)
        :return: EmailVerifyTokenValidateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['validation_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validate_email_verification_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'validation_request' is set
        if ('validation_request' not in params or
                params['validation_request'] is None):
            raise ValueError("Missing the required parameter `validation_request` when calling `validate_email_verification_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'validation_request' in params:
            body_params = params['validation_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/customer/customers/email_verify/validate_token', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailVerifyTokenValidateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
