# coding: utf-8

"""
    UltraCart Rest API V2

    UltraCart REST API Version 2  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@ultracart.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ultracart.api_client import ApiClient
from ultracart.configuration import Configuration

class ConversationApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    @classmethod
    def fromApiKey(cls, apiKey, verify_ssl = True, debug = False):
        config = Configuration()
        config.api_key['x-ultracart-simple-key'] = apiKey
        config.debug = debug
        config.verify_ssl = verify_ssl

        api_client = ApiClient(configuration=config, header_name='X-UltraCart-Api-Version', header_value='2017-03-01')
        return ConversationApi(api_client)




    def get_agent_websocket_authorization(self, **kwargs):  # noqa: E501
        """Get agent websocket authorization  # noqa: E501

        Retrieve a JWT to authorize an agent to make a websocket connection.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_agent_websocket_authorization(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConversationAgentAuthResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_agent_websocket_authorization_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_agent_websocket_authorization_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_agent_websocket_authorization_with_http_info(self, **kwargs):  # noqa: E501
        """Get agent websocket authorization  # noqa: E501

        Retrieve a JWT to authorize an agent to make a websocket connection.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_agent_websocket_authorization_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConversationAgentAuthResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agent_websocket_authorization" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/conversation/agent/auth', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConversationAgentAuthResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_conversation(self, conversation_uuid, **kwargs):  # noqa: E501
        """Retrieve a conversation  # noqa: E501

        Retrieve a conversation including the participants and messages   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_conversation(conversation_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_uuid: (required)
        :return: ConversationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_conversation_with_http_info(conversation_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_conversation_with_http_info(conversation_uuid, **kwargs)  # noqa: E501
            return data

    def get_conversation_with_http_info(self, conversation_uuid, **kwargs):  # noqa: E501
        """Retrieve a conversation  # noqa: E501

        Retrieve a conversation including the participants and messages   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_conversation_with_http_info(conversation_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_uuid: (required)
        :return: ConversationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_uuid' is set
        if ('conversation_uuid' not in params or
                params['conversation_uuid'] is None):
            raise ValueError("Missing the required parameter `conversation_uuid` when calling `get_conversation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_uuid' in params:
            path_params['conversation_uuid'] = params['conversation_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/conversation/conversations/{conversation_uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConversationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_conversation_multimedia_upload_url(self, extension, **kwargs):  # noqa: E501
        """Get a presigned conersation multimedia upload URL  # noqa: E501

        Get a presigned conersation multimedia upload URL   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_conversation_multimedia_upload_url(extension, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str extension: (required)
        :return: ConversationMultimediaUploadUrlResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_conversation_multimedia_upload_url_with_http_info(extension, **kwargs)  # noqa: E501
        else:
            (data) = self.get_conversation_multimedia_upload_url_with_http_info(extension, **kwargs)  # noqa: E501
            return data

    def get_conversation_multimedia_upload_url_with_http_info(self, extension, **kwargs):  # noqa: E501
        """Get a presigned conersation multimedia upload URL  # noqa: E501

        Get a presigned conersation multimedia upload URL   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_conversation_multimedia_upload_url_with_http_info(extension, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str extension: (required)
        :return: ConversationMultimediaUploadUrlResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extension']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversation_multimedia_upload_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extension' is set
        if ('extension' not in params or
                params['extension'] is None):
            raise ValueError("Missing the required parameter `extension` when calling `get_conversation_multimedia_upload_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extension' in params:
            path_params['extension'] = params['extension']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/conversation/upload_url/{extension}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConversationMultimediaUploadUrlResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_conversations(self, **kwargs):  # noqa: E501
        """Retrieve a list of conversation summaries newest to oldest  # noqa: E501

        Retrieve a list of conversation summaries that are ordered newest to oldest, include the most recent message and whether its been read.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_conversations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: The maximum number of records to return on this one API call. (Max 200)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :return: ConversationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_conversations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_conversations_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_conversations_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve a list of conversation summaries newest to oldest  # noqa: E501

        Retrieve a list of conversation summaries that are ordered newest to oldest, include the most recent message and whether its been read.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_conversations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: The maximum number of records to return on this one API call. (Max 200)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :return: ConversationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('_limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('_offset', params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/conversation/conversations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConversationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def join_conversation(self, conversation_uuid, **kwargs):  # noqa: E501
        """Join a conversation  # noqa: E501

        Join a conversation   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.join_conversation(conversation_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_uuid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.join_conversation_with_http_info(conversation_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.join_conversation_with_http_info(conversation_uuid, **kwargs)  # noqa: E501
            return data

    def join_conversation_with_http_info(self, conversation_uuid, **kwargs):  # noqa: E501
        """Join a conversation  # noqa: E501

        Join a conversation   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.join_conversation_with_http_info(conversation_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_uuid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method join_conversation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_uuid' is set
        if ('conversation_uuid' not in params or
                params['conversation_uuid'] is None):
            raise ValueError("Missing the required parameter `conversation_uuid` when calling `join_conversation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_uuid' in params:
            path_params['conversation_uuid'] = params['conversation_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/conversation/conversations/{conversation_uuid}/join', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def leave_conversation(self, conversation_uuid, **kwargs):  # noqa: E501
        """Leave a conversation  # noqa: E501

        Leave a conversation   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.leave_conversation(conversation_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_uuid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.leave_conversation_with_http_info(conversation_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.leave_conversation_with_http_info(conversation_uuid, **kwargs)  # noqa: E501
            return data

    def leave_conversation_with_http_info(self, conversation_uuid, **kwargs):  # noqa: E501
        """Leave a conversation  # noqa: E501

        Leave a conversation   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.leave_conversation_with_http_info(conversation_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_uuid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method leave_conversation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_uuid' is set
        if ('conversation_uuid' not in params or
                params['conversation_uuid'] is None):
            raise ValueError("Missing the required parameter `conversation_uuid` when calling `leave_conversation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_uuid' in params:
            path_params['conversation_uuid'] = params['conversation_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/conversation/conversations/{conversation_uuid}/leave', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def start_conversation(self, start_request, **kwargs):  # noqa: E501
        """Start a conversation  # noqa: E501

        Start a new conversation   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_conversation(start_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConversationStartRequest start_request: Start request (required)
        :return: ConversationStartResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.start_conversation_with_http_info(start_request, **kwargs)  # noqa: E501
        else:
            (data) = self.start_conversation_with_http_info(start_request, **kwargs)  # noqa: E501
            return data

    def start_conversation_with_http_info(self, start_request, **kwargs):  # noqa: E501
        """Start a conversation  # noqa: E501

        Start a new conversation   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_conversation_with_http_info(start_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConversationStartRequest start_request: Start request (required)
        :return: ConversationStartResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['start_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_conversation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'start_request' is set
        if ('start_request' not in params or
                params['start_request'] is None):
            raise ValueError("Missing the required parameter `start_request` when calling `start_conversation`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'start_request' in params:
            body_params = params['start_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/conversation/conversations', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConversationStartResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
