# coding: utf-8

"""
    UltraCart Rest API V2

    UltraCart REST API Version 2  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@ultracart.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ultracart.api_client import ApiClient
from ultracart.configuration import Configuration

class CheckoutApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    @classmethod
    def fromApiKey(cls, apiKey, verify_ssl = True, debug = False):
        config = Configuration()
        config.api_key['x-ultracart-simple-key'] = apiKey
        config.debug = debug
        config.verify_ssl = verify_ssl

        api_client = ApiClient(configuration=config, header_name='X-UltraCart-Api-Version', header_value='2017-03-01')
        return CheckoutApi(api_client)




    def city_state(self, cart, **kwargs):  # noqa: E501
        """City/State for Zip  # noqa: E501

        Look up the city and state for the shipping zip code.  Useful for building an auto complete for parts of the shipping address   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.city_state(cart, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Cart cart: Cart (required)
        :return: CityStateZip
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.city_state_with_http_info(cart, **kwargs)  # noqa: E501
        else:
            (data) = self.city_state_with_http_info(cart, **kwargs)  # noqa: E501
            return data

    def city_state_with_http_info(self, cart, **kwargs):  # noqa: E501
        """City/State for Zip  # noqa: E501

        Look up the city and state for the shipping zip code.  Useful for building an auto complete for parts of the shipping address   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.city_state_with_http_info(cart, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Cart cart: Cart (required)
        :return: CityStateZip
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cart']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method city_state" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cart' is set
        if ('cart' not in params or
                params['cart'] is None):
            raise ValueError("Missing the required parameter `cart` when calling `city_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cart' in params:
            body_params = params['cart']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/checkout/city_state', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CityStateZip',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def finalize_order(self, finalize_request, **kwargs):  # noqa: E501
        """Finalize Order  # noqa: E501

        Finalize the cart into an order.  This method can not be called with browser key authentication.  It is ONLY meant for server side code to call.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.finalize_order(finalize_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CartFinalizeOrderRequest finalize_request: Finalize request (required)
        :return: CartFinalizeOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.finalize_order_with_http_info(finalize_request, **kwargs)  # noqa: E501
        else:
            (data) = self.finalize_order_with_http_info(finalize_request, **kwargs)  # noqa: E501
            return data

    def finalize_order_with_http_info(self, finalize_request, **kwargs):  # noqa: E501
        """Finalize Order  # noqa: E501

        Finalize the cart into an order.  This method can not be called with browser key authentication.  It is ONLY meant for server side code to call.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.finalize_order_with_http_info(finalize_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CartFinalizeOrderRequest finalize_request: Finalize request (required)
        :return: CartFinalizeOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['finalize_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method finalize_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'finalize_request' is set
        if ('finalize_request' not in params or
                params['finalize_request'] is None):
            raise ValueError("Missing the required parameter `finalize_request` when calling `finalize_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'finalize_request' in params:
            body_params = params['finalize_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/checkout/cart/finalizeOrder', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CartFinalizeOrderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_affirm_checkout(self, cart_id, **kwargs):  # noqa: E501
        """Get affirm checkout (by cart id)  # noqa: E501

        Get a Affirm checkout object for the specified cart_id parameter.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_affirm_checkout(cart_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cart_id: Cart ID to retrieve (required)
        :return: CartAffirmCheckoutResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_affirm_checkout_with_http_info(cart_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_affirm_checkout_with_http_info(cart_id, **kwargs)  # noqa: E501
            return data

    def get_affirm_checkout_with_http_info(self, cart_id, **kwargs):  # noqa: E501
        """Get affirm checkout (by cart id)  # noqa: E501

        Get a Affirm checkout object for the specified cart_id parameter.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_affirm_checkout_with_http_info(cart_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cart_id: Cart ID to retrieve (required)
        :return: CartAffirmCheckoutResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cart_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_affirm_checkout" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cart_id' is set
        if ('cart_id' not in params or
                params['cart_id'] is None):
            raise ValueError("Missing the required parameter `cart_id` when calling `get_affirm_checkout`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cart_id' in params:
            path_params['cart_id'] = params['cart_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/checkout/cart/{cart_id}/affirmCheckout', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CartAffirmCheckoutResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_allowed_countries(self, **kwargs):  # noqa: E501
        """Allowed countries  # noqa: E501

        Lookup the allowed countries for this merchant id   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_allowed_countries(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CheckoutAllowedCountriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_allowed_countries_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_allowed_countries_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_allowed_countries_with_http_info(self, **kwargs):  # noqa: E501
        """Allowed countries  # noqa: E501

        Lookup the allowed countries for this merchant id   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_allowed_countries_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CheckoutAllowedCountriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_allowed_countries" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/checkout/allowedCountries', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckoutAllowedCountriesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cart(self, **kwargs):  # noqa: E501
        """Get cart  # noqa: E501

        If the cookie is set on the browser making the request then it will return their active cart.  Otherwise it will create a new cart.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cart(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CartResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cart_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_cart_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_cart_with_http_info(self, **kwargs):  # noqa: E501
        """Get cart  # noqa: E501

        If the cookie is set on the browser making the request then it will return their active cart.  Otherwise it will create a new cart.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cart_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CartResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cart" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/checkout/cart', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CartResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cart_by_cart_id(self, cart_id, **kwargs):  # noqa: E501
        """Get cart (by cart id)  # noqa: E501

        Get a cart specified by the cart_id parameter.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cart_by_cart_id(cart_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cart_id: Cart ID to retrieve (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CartResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cart_by_cart_id_with_http_info(cart_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cart_by_cart_id_with_http_info(cart_id, **kwargs)  # noqa: E501
            return data

    def get_cart_by_cart_id_with_http_info(self, cart_id, **kwargs):  # noqa: E501
        """Get cart (by cart id)  # noqa: E501

        Get a cart specified by the cart_id parameter.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cart_by_cart_id_with_http_info(cart_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cart_id: Cart ID to retrieve (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CartResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cart_id', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cart_by_cart_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cart_id' is set
        if ('cart_id' not in params or
                params['cart_id'] is None):
            raise ValueError("Missing the required parameter `cart_id` when calling `get_cart_by_cart_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cart_id' in params:
            path_params['cart_id'] = params['cart_id']  # noqa: E501

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/checkout/cart/{cart_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CartResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cart_by_return_code(self, return_code, **kwargs):  # noqa: E501
        """Get cart (by return code)  # noqa: E501

        Get a cart specified by the return code parameter.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cart_by_return_code(return_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str return_code: Return code to lookup cart ID by (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CartResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cart_by_return_code_with_http_info(return_code, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cart_by_return_code_with_http_info(return_code, **kwargs)  # noqa: E501
            return data

    def get_cart_by_return_code_with_http_info(self, return_code, **kwargs):  # noqa: E501
        """Get cart (by return code)  # noqa: E501

        Get a cart specified by the return code parameter.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cart_by_return_code_with_http_info(return_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str return_code: Return code to lookup cart ID by (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CartResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['return_code', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cart_by_return_code" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'return_code' is set
        if ('return_code' not in params or
                params['return_code'] is None):
            raise ValueError("Missing the required parameter `return_code` when calling `get_cart_by_return_code`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'return_code' in params:
            path_params['return_code'] = params['return_code']  # noqa: E501

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/checkout/return/{return_code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CartResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cart_by_return_token(self, **kwargs):  # noqa: E501
        """Get cart (by return token)  # noqa: E501

        Get a cart specified by the encrypted return token parameter.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cart_by_return_token(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str return_token: Return token provided by StoreFront Communications
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CartResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cart_by_return_token_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_cart_by_return_token_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_cart_by_return_token_with_http_info(self, **kwargs):  # noqa: E501
        """Get cart (by return token)  # noqa: E501

        Get a cart specified by the encrypted return token parameter.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cart_by_return_token_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str return_token: Return token provided by StoreFront Communications
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CartResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['return_token', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cart_by_return_token" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'return_token' in params:
            query_params.append(('return_token', params['return_token']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/checkout/return_token', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CartResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_state_provinces_for_country(self, country_code, **kwargs):  # noqa: E501
        """Get state/province list for a country code  # noqa: E501

        Lookup a state/province list for a given country code   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_state_provinces_for_country(country_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str country_code: Two letter ISO country code (required)
        :return: CheckoutStateProvinceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_state_provinces_for_country_with_http_info(country_code, **kwargs)  # noqa: E501
        else:
            (data) = self.get_state_provinces_for_country_with_http_info(country_code, **kwargs)  # noqa: E501
            return data

    def get_state_provinces_for_country_with_http_info(self, country_code, **kwargs):  # noqa: E501
        """Get state/province list for a country code  # noqa: E501

        Lookup a state/province list for a given country code   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_state_provinces_for_country_with_http_info(country_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str country_code: Two letter ISO country code (required)
        :return: CheckoutStateProvinceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['country_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_state_provinces_for_country" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'country_code' is set
        if ('country_code' not in params or
                params['country_code'] is None):
            raise ValueError("Missing the required parameter `country_code` when calling `get_state_provinces_for_country`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'country_code' in params:
            path_params['country_code'] = params['country_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/checkout/stateProvincesForCountry/{country_code}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckoutStateProvinceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def handoff_cart(self, handoff_request, **kwargs):  # noqa: E501
        """Handoff cart  # noqa: E501

        Handoff the browser to UltraCart for view cart on StoreFront, transfer to PayPal, transfer to Affirm, transfer to Sezzle or finalization of the order (including upsell processing).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handoff_cart(handoff_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CheckoutHandoffRequest handoff_request: Handoff request (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CheckoutHandoffResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.handoff_cart_with_http_info(handoff_request, **kwargs)  # noqa: E501
        else:
            (data) = self.handoff_cart_with_http_info(handoff_request, **kwargs)  # noqa: E501
            return data

    def handoff_cart_with_http_info(self, handoff_request, **kwargs):  # noqa: E501
        """Handoff cart  # noqa: E501

        Handoff the browser to UltraCart for view cart on StoreFront, transfer to PayPal, transfer to Affirm, transfer to Sezzle or finalization of the order (including upsell processing).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handoff_cart_with_http_info(handoff_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CheckoutHandoffRequest handoff_request: Handoff request (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CheckoutHandoffResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['handoff_request', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method handoff_cart" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'handoff_request' is set
        if ('handoff_request' not in params or
                params['handoff_request'] is None):
            raise ValueError("Missing the required parameter `handoff_request` when calling `handoff_cart`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'handoff_request' in params:
            body_params = params['handoff_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/checkout/cart/handoff', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckoutHandoffResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def login(self, login_request, **kwargs):  # noqa: E501
        """Profile login  # noqa: E501

        Login in to the customer profile specified by cart.billing.email and password   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.login(login_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CartProfileLoginRequest login_request: Login request (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CartProfileLoginResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.login_with_http_info(login_request, **kwargs)  # noqa: E501
        else:
            (data) = self.login_with_http_info(login_request, **kwargs)  # noqa: E501
            return data

    def login_with_http_info(self, login_request, **kwargs):  # noqa: E501
        """Profile login  # noqa: E501

        Login in to the customer profile specified by cart.billing.email and password   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.login_with_http_info(login_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CartProfileLoginRequest login_request: Login request (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CartProfileLoginResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['login_request', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method login" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'login_request' is set
        if ('login_request' not in params or
                params['login_request'] is None):
            raise ValueError("Missing the required parameter `login_request` when calling `login`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'login_request' in params:
            body_params = params['login_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/checkout/cart/profile/login', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CartProfileLoginResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def logout(self, cart, **kwargs):  # noqa: E501
        """Profile logout  # noqa: E501

        Log the cart out of the current profile.  No error will occur if they are not logged in.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.logout(cart, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Cart cart: Cart (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CartResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.logout_with_http_info(cart, **kwargs)  # noqa: E501
        else:
            (data) = self.logout_with_http_info(cart, **kwargs)  # noqa: E501
            return data

    def logout_with_http_info(self, cart, **kwargs):  # noqa: E501
        """Profile logout  # noqa: E501

        Log the cart out of the current profile.  No error will occur if they are not logged in.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.logout_with_http_info(cart, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Cart cart: Cart (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CartResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cart', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method logout" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cart' is set
        if ('cart' not in params or
                params['cart'] is None):
            raise ValueError("Missing the required parameter `cart` when calling `logout`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cart' in params:
            body_params = params['cart']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/checkout/cart/profile/logout', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CartResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def register(self, register_request, **kwargs):  # noqa: E501
        """Profile registration  # noqa: E501

        Register a new customer profile.  Requires the cart.billing object to be populated along with the password.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register(register_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CartProfileRegisterRequest register_request: Register request (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CartProfileRegisterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.register_with_http_info(register_request, **kwargs)  # noqa: E501
        else:
            (data) = self.register_with_http_info(register_request, **kwargs)  # noqa: E501
            return data

    def register_with_http_info(self, register_request, **kwargs):  # noqa: E501
        """Profile registration  # noqa: E501

        Register a new customer profile.  Requires the cart.billing object to be populated along with the password.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_with_http_info(register_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CartProfileRegisterRequest register_request: Register request (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CartProfileRegisterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['register_request', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'register_request' is set
        if ('register_request' not in params or
                params['register_request'] is None):
            raise ValueError("Missing the required parameter `register_request` when calling `register`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'register_request' in params:
            body_params = params['register_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/checkout/cart/profile/register', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CartProfileRegisterResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def register_affiliate_click(self, register_affiliate_click_request, **kwargs):  # noqa: E501
        """Register affiliate click  # noqa: E501

        Register an affiliate click.  Used by custom checkouts that are completely API based and do not perform checkout handoff.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_affiliate_click(register_affiliate_click_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RegisterAffiliateClickRequest register_affiliate_click_request: Register affiliate click request (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: RegisterAffiliateClickResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.register_affiliate_click_with_http_info(register_affiliate_click_request, **kwargs)  # noqa: E501
        else:
            (data) = self.register_affiliate_click_with_http_info(register_affiliate_click_request, **kwargs)  # noqa: E501
            return data

    def register_affiliate_click_with_http_info(self, register_affiliate_click_request, **kwargs):  # noqa: E501
        """Register affiliate click  # noqa: E501

        Register an affiliate click.  Used by custom checkouts that are completely API based and do not perform checkout handoff.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_affiliate_click_with_http_info(register_affiliate_click_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RegisterAffiliateClickRequest register_affiliate_click_request: Register affiliate click request (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: RegisterAffiliateClickResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['register_affiliate_click_request', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_affiliate_click" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'register_affiliate_click_request' is set
        if ('register_affiliate_click_request' not in params or
                params['register_affiliate_click_request'] is None):
            raise ValueError("Missing the required parameter `register_affiliate_click_request` when calling `register_affiliate_click`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'register_affiliate_click_request' in params:
            body_params = params['register_affiliate_click_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/checkout/affiliateClick/register', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RegisterAffiliateClickResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def related_items_for_cart(self, cart, **kwargs):  # noqa: E501
        """Related items  # noqa: E501

        Retrieve all the related items for the cart contents.  Expansion is limited to content, content.assignments, content.attributes, content.multimedia, content.multimedia.thumbnails, options, pricing, and pricing.tiers.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.related_items_for_cart(cart, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Cart cart: Cart (required)
        :param str expand: The object expansion to perform on the result.  See item resource documentation for examples
        :return: ItemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.related_items_for_cart_with_http_info(cart, **kwargs)  # noqa: E501
        else:
            (data) = self.related_items_for_cart_with_http_info(cart, **kwargs)  # noqa: E501
            return data

    def related_items_for_cart_with_http_info(self, cart, **kwargs):  # noqa: E501
        """Related items  # noqa: E501

        Retrieve all the related items for the cart contents.  Expansion is limited to content, content.assignments, content.attributes, content.multimedia, content.multimedia.thumbnails, options, pricing, and pricing.tiers.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.related_items_for_cart_with_http_info(cart, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Cart cart: Cart (required)
        :param str expand: The object expansion to perform on the result.  See item resource documentation for examples
        :return: ItemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cart', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method related_items_for_cart" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cart' is set
        if ('cart' not in params or
                params['cart'] is None):
            raise ValueError("Missing the required parameter `cart` when calling `related_items_for_cart`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cart' in params:
            body_params = params['cart']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/checkout/related_items', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def related_items_for_item(self, item_id, cart, **kwargs):  # noqa: E501
        """Related items (specific item)  # noqa: E501

        Retrieve all the related items for the cart contents.  Expansion is limited to content, content.assignments, content.attributes, content.multimedia, content.multimedia.thumbnails, options, pricing, and pricing.tiers.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.related_items_for_item(item_id, cart, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: Item ID to retrieve related items for (required)
        :param Cart cart: Cart (required)
        :param str expand: The object expansion to perform on the result.  See item resource documentation for examples
        :return: ItemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.related_items_for_item_with_http_info(item_id, cart, **kwargs)  # noqa: E501
        else:
            (data) = self.related_items_for_item_with_http_info(item_id, cart, **kwargs)  # noqa: E501
            return data

    def related_items_for_item_with_http_info(self, item_id, cart, **kwargs):  # noqa: E501
        """Related items (specific item)  # noqa: E501

        Retrieve all the related items for the cart contents.  Expansion is limited to content, content.assignments, content.attributes, content.multimedia, content.multimedia.thumbnails, options, pricing, and pricing.tiers.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.related_items_for_item_with_http_info(item_id, cart, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: Item ID to retrieve related items for (required)
        :param Cart cart: Cart (required)
        :param str expand: The object expansion to perform on the result.  See item resource documentation for examples
        :return: ItemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_id', 'cart', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method related_items_for_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in params or
                params['item_id'] is None):
            raise ValueError("Missing the required parameter `item_id` when calling `related_items_for_item`")  # noqa: E501
        # verify the required parameter 'cart' is set
        if ('cart' not in params or
                params['cart'] is None):
            raise ValueError("Missing the required parameter `cart` when calling `related_items_for_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in params:
            path_params['item_id'] = params['item_id']  # noqa: E501

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cart' in params:
            body_params = params['cart']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/checkout/relatedItems/{item_id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def setup_browser_key(self, browser_key_request, **kwargs):  # noqa: E501
        """Setup Browser Application  # noqa: E501

        Setup a browser key authenticated application with checkout permissions.  This REST call must be made with an authentication scheme that is not browser key.  The new application will be linked to the application that makes this call.  If this application is disabled / deleted, then so will the application setup by this call.  The purpose of this call is to allow an OAuth application, such as the Wordpress plugin, to setup the proper browser based authentication for the REST checkout API to use.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.setup_browser_key(browser_key_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CheckoutSetupBrowserKeyRequest browser_key_request: Setup browser key request (required)
        :return: CheckoutSetupBrowserKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.setup_browser_key_with_http_info(browser_key_request, **kwargs)  # noqa: E501
        else:
            (data) = self.setup_browser_key_with_http_info(browser_key_request, **kwargs)  # noqa: E501
            return data

    def setup_browser_key_with_http_info(self, browser_key_request, **kwargs):  # noqa: E501
        """Setup Browser Application  # noqa: E501

        Setup a browser key authenticated application with checkout permissions.  This REST call must be made with an authentication scheme that is not browser key.  The new application will be linked to the application that makes this call.  If this application is disabled / deleted, then so will the application setup by this call.  The purpose of this call is to allow an OAuth application, such as the Wordpress plugin, to setup the proper browser based authentication for the REST checkout API to use.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.setup_browser_key_with_http_info(browser_key_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CheckoutSetupBrowserKeyRequest browser_key_request: Setup browser key request (required)
        :return: CheckoutSetupBrowserKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['browser_key_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method setup_browser_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'browser_key_request' is set
        if ('browser_key_request' not in params or
                params['browser_key_request'] is None):
            raise ValueError("Missing the required parameter `browser_key_request` when calling `setup_browser_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'browser_key_request' in params:
            body_params = params['browser_key_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/checkout/browser_key', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckoutSetupBrowserKeyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cart(self, cart, **kwargs):  # noqa: E501
        """Update cart  # noqa: E501

        Update the cart.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cart(cart, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Cart cart: Cart (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CartResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_cart_with_http_info(cart, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cart_with_http_info(cart, **kwargs)  # noqa: E501
            return data

    def update_cart_with_http_info(self, cart, **kwargs):  # noqa: E501
        """Update cart  # noqa: E501

        Update the cart.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cart_with_http_info(cart, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Cart cart: Cart (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CartResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cart', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cart" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cart' is set
        if ('cart' not in params or
                params['cart'] is None):
            raise ValueError("Missing the required parameter `cart` when calling `update_cart`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cart' in params:
            body_params = params['cart']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/checkout/cart', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CartResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def validate_cart(self, validation_request, **kwargs):  # noqa: E501
        """Validate  # noqa: E501

        Validate the cart for errors.  Specific checks can be passed and multiple validations can occur throughout your checkout flow.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_cart(validation_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CartValidationRequest validation_request: Validation request (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CartValidationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.validate_cart_with_http_info(validation_request, **kwargs)  # noqa: E501
        else:
            (data) = self.validate_cart_with_http_info(validation_request, **kwargs)  # noqa: E501
            return data

    def validate_cart_with_http_info(self, validation_request, **kwargs):  # noqa: E501
        """Validate  # noqa: E501

        Validate the cart for errors.  Specific checks can be passed and multiple validations can occur throughout your checkout flow.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_cart_with_http_info(validation_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CartValidationRequest validation_request: Validation request (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: CartValidationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['validation_request', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validate_cart" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'validation_request' is set
        if ('validation_request' not in params or
                params['validation_request'] is None):
            raise ValueError("Missing the required parameter `validation_request` when calling `validate_cart`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'validation_request' in params:
            body_params = params['validation_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/checkout/cart/validate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CartValidationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
