# coding: utf-8

"""
    UltraCart Rest API V2

    UltraCart REST API Version 2  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@ultracart.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ultracart.api_client import ApiClient
from ultracart.configuration import Configuration

class ChannelPartnerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    @classmethod
    def fromApiKey(cls, apiKey, verify_ssl = True, debug = False):
        config = Configuration()
        config.api_key['x-ultracart-simple-key'] = apiKey
        config.debug = debug
        config.verify_ssl = verify_ssl

        api_client = ApiClient(configuration=config, header_name='X-UltraCart-Api-Version', header_value='2017-03-01')
        return ChannelPartnerApi(api_client)




    def cancel_order_by_channel_partner_order_id(self, order_id, **kwargs):  # noqa: E501
        """Cancel channel partner order by channel partner order id  # noqa: E501

        Cancel channel partner order by channel partner order id   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_order_by_channel_partner_order_id(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The channel partner order id to delete. (required)
        :return: ChannelPartnerCancelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_order_by_channel_partner_order_id_with_http_info(order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_order_by_channel_partner_order_id_with_http_info(order_id, **kwargs)  # noqa: E501
            return data

    def cancel_order_by_channel_partner_order_id_with_http_info(self, order_id, **kwargs):  # noqa: E501
        """Cancel channel partner order by channel partner order id  # noqa: E501

        Cancel channel partner order by channel partner order id   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_order_by_channel_partner_order_id_with_http_info(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The channel partner order id to delete. (required)
        :return: ChannelPartnerCancelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_order_by_channel_partner_order_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `cancel_order_by_channel_partner_order_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/channel_partner/cancel/by_channel_partner_order_id/{order_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChannelPartnerCancelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancel_order_by_ultra_cart_order_id(self, order_id, **kwargs):  # noqa: E501
        """Cancel channel partner order by UltraCart order id  # noqa: E501

        Cancel channel partner order by UltraCart order id   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_order_by_ultra_cart_order_id(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The UltraCart order id to delete. (required)
        :return: ChannelPartnerCancelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_order_by_ultra_cart_order_id_with_http_info(order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_order_by_ultra_cart_order_id_with_http_info(order_id, **kwargs)  # noqa: E501
            return data

    def cancel_order_by_ultra_cart_order_id_with_http_info(self, order_id, **kwargs):  # noqa: E501
        """Cancel channel partner order by UltraCart order id  # noqa: E501

        Cancel channel partner order by UltraCart order id   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_order_by_ultra_cart_order_id_with_http_info(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The UltraCart order id to delete. (required)
        :return: ChannelPartnerCancelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_order_by_ultra_cart_order_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `cancel_order_by_ultra_cart_order_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/channel_partner/cancel/by_ultracart_order_id/{order_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChannelPartnerCancelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def estimate_shipping_for_channel_partner_order(self, channel_partner_order, **kwargs):  # noqa: E501
        """Estimate shipping for channel partner order  # noqa: E501

        Estimate shipping for order from a channel partner.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.estimate_shipping_for_channel_partner_order(channel_partner_order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ChannelPartnerOrder channel_partner_order: Order needing shipping estimate (required)
        :return: ChannelPartnerEstimateShippingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.estimate_shipping_for_channel_partner_order_with_http_info(channel_partner_order, **kwargs)  # noqa: E501
        else:
            (data) = self.estimate_shipping_for_channel_partner_order_with_http_info(channel_partner_order, **kwargs)  # noqa: E501
            return data

    def estimate_shipping_for_channel_partner_order_with_http_info(self, channel_partner_order, **kwargs):  # noqa: E501
        """Estimate shipping for channel partner order  # noqa: E501

        Estimate shipping for order from a channel partner.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.estimate_shipping_for_channel_partner_order_with_http_info(channel_partner_order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ChannelPartnerOrder channel_partner_order: Order needing shipping estimate (required)
        :return: ChannelPartnerEstimateShippingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['channel_partner_order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method estimate_shipping_for_channel_partner_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'channel_partner_order' is set
        if ('channel_partner_order' not in params or
                params['channel_partner_order'] is None):
            raise ValueError("Missing the required parameter `channel_partner_order` when calling `estimate_shipping_for_channel_partner_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'channel_partner_order' in params:
            body_params = params['channel_partner_order']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/channel_partner/estimate_shipping', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChannelPartnerEstimateShippingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def estimate_tax_for_channel_partner_order(self, channel_partner_order, **kwargs):  # noqa: E501
        """Estimate tax for channel partner order  # noqa: E501

        Estimate tax for order from a channel partner.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.estimate_tax_for_channel_partner_order(channel_partner_order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ChannelPartnerOrder channel_partner_order: Order needing tax estimate (required)
        :return: ChannelPartnerEstimateTaxResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.estimate_tax_for_channel_partner_order_with_http_info(channel_partner_order, **kwargs)  # noqa: E501
        else:
            (data) = self.estimate_tax_for_channel_partner_order_with_http_info(channel_partner_order, **kwargs)  # noqa: E501
            return data

    def estimate_tax_for_channel_partner_order_with_http_info(self, channel_partner_order, **kwargs):  # noqa: E501
        """Estimate tax for channel partner order  # noqa: E501

        Estimate tax for order from a channel partner.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.estimate_tax_for_channel_partner_order_with_http_info(channel_partner_order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ChannelPartnerOrder channel_partner_order: Order needing tax estimate (required)
        :return: ChannelPartnerEstimateTaxResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['channel_partner_order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method estimate_tax_for_channel_partner_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'channel_partner_order' is set
        if ('channel_partner_order' not in params or
                params['channel_partner_order'] is None):
            raise ValueError("Missing the required parameter `channel_partner_order` when calling `estimate_tax_for_channel_partner_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'channel_partner_order' in params:
            body_params = params['channel_partner_order']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/channel_partner/estimate_tax', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChannelPartnerEstimateTaxResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_channel_partner_order(self, channel_partner_order, **kwargs):  # noqa: E501
        """Insert channel partner order  # noqa: E501

        Insert order from a channel partner.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_channel_partner_order(channel_partner_order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ChannelPartnerOrder channel_partner_order: Order to insert (required)
        :return: ChannelPartnerImportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_channel_partner_order_with_http_info(channel_partner_order, **kwargs)  # noqa: E501
        else:
            (data) = self.import_channel_partner_order_with_http_info(channel_partner_order, **kwargs)  # noqa: E501
            return data

    def import_channel_partner_order_with_http_info(self, channel_partner_order, **kwargs):  # noqa: E501
        """Insert channel partner order  # noqa: E501

        Insert order from a channel partner.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_channel_partner_order_with_http_info(channel_partner_order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ChannelPartnerOrder channel_partner_order: Order to insert (required)
        :return: ChannelPartnerImportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['channel_partner_order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_channel_partner_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'channel_partner_order' is set
        if ('channel_partner_order' not in params or
                params['channel_partner_order'] is None):
            raise ValueError("Missing the required parameter `channel_partner_order` when calling `import_channel_partner_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'channel_partner_order' in params:
            body_params = params['channel_partner_order']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/channel_partner/import', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChannelPartnerImportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
