# coding: utf-8

"""
    UltraCart Rest API V2

    UltraCart REST API Version 2  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@ultracart.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ultracart.api_client import ApiClient
from ultracart.configuration import Configuration

class AutoOrderApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    @classmethod
    def fromApiKey(cls, apiKey, verify_ssl = True, debug = False):
        config = Configuration()
        config.api_key['x-ultracart-simple-key'] = apiKey
        config.debug = debug
        config.verify_ssl = verify_ssl

        api_client = ApiClient(configuration=config, header_name='X-UltraCart-Api-Version', header_value='2017-03-01')
        return AutoOrderApi(api_client)




    def get_auto_order(self, auto_order_oid, **kwargs):  # noqa: E501
        """Retrieve an auto order by oid  # noqa: E501

        Retrieves a single auto order using the specified auto order oid.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auto_order(auto_order_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int auto_order_oid: The auto order oid to retrieve. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: AutoOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auto_order_with_http_info(auto_order_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_auto_order_with_http_info(auto_order_oid, **kwargs)  # noqa: E501
            return data

    def get_auto_order_with_http_info(self, auto_order_oid, **kwargs):  # noqa: E501
        """Retrieve an auto order by oid  # noqa: E501

        Retrieves a single auto order using the specified auto order oid.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auto_order_with_http_info(auto_order_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int auto_order_oid: The auto order oid to retrieve. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: AutoOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auto_order_oid', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auto_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auto_order_oid' is set
        if ('auto_order_oid' not in params or
                params['auto_order_oid'] is None):
            raise ValueError("Missing the required parameter `auto_order_oid` when calling `get_auto_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auto_order_oid' in params:
            path_params['auto_order_oid'] = params['auto_order_oid']  # noqa: E501

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/auto_order/auto_orders/{auto_order_oid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AutoOrderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auto_order_by_code(self, auto_order_code, **kwargs):  # noqa: E501
        """Retrieve an auto order by code  # noqa: E501

        Retrieves a single auto order using the specified reference (original) order id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auto_order_by_code(auto_order_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auto_order_code: The auto order oid to retrieve. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: AutoOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auto_order_by_code_with_http_info(auto_order_code, **kwargs)  # noqa: E501
        else:
            (data) = self.get_auto_order_by_code_with_http_info(auto_order_code, **kwargs)  # noqa: E501
            return data

    def get_auto_order_by_code_with_http_info(self, auto_order_code, **kwargs):  # noqa: E501
        """Retrieve an auto order by code  # noqa: E501

        Retrieves a single auto order using the specified reference (original) order id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auto_order_by_code_with_http_info(auto_order_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auto_order_code: The auto order oid to retrieve. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: AutoOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auto_order_code', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auto_order_by_code" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auto_order_code' is set
        if ('auto_order_code' not in params or
                params['auto_order_code'] is None):
            raise ValueError("Missing the required parameter `auto_order_code` when calling `get_auto_order_by_code`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auto_order_code' in params:
            path_params['auto_order_code'] = params['auto_order_code']  # noqa: E501

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/auto_order/auto_orders/code/{auto_order_code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AutoOrderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auto_order_by_reference_order_id(self, reference_order_id, **kwargs):  # noqa: E501
        """Retrieve an auto order by order id  # noqa: E501

        Retrieves a single auto order using the specified reference (original) order id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auto_order_by_reference_order_id(reference_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str reference_order_id: The auto order oid to retrieve. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: AutoOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auto_order_by_reference_order_id_with_http_info(reference_order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_auto_order_by_reference_order_id_with_http_info(reference_order_id, **kwargs)  # noqa: E501
            return data

    def get_auto_order_by_reference_order_id_with_http_info(self, reference_order_id, **kwargs):  # noqa: E501
        """Retrieve an auto order by order id  # noqa: E501

        Retrieves a single auto order using the specified reference (original) order id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auto_order_by_reference_order_id_with_http_info(reference_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str reference_order_id: The auto order oid to retrieve. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: AutoOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['reference_order_id', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auto_order_by_reference_order_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'reference_order_id' is set
        if ('reference_order_id' not in params or
                params['reference_order_id'] is None):
            raise ValueError("Missing the required parameter `reference_order_id` when calling `get_auto_order_by_reference_order_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'reference_order_id' in params:
            path_params['reference_order_id'] = params['reference_order_id']  # noqa: E501

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/auto_order/auto_orders/reference_order_id/{reference_order_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AutoOrderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auto_orders(self, **kwargs):  # noqa: E501
        """Retrieve auto orders  # noqa: E501

        Retrieves auto orders from the account.  If no parameters are specified, all auto orders will be returned.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auto_orders(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auto_order_code: Auto order code
        :param str original_order_id: Original order id
        :param str first_name: First name
        :param str last_name: Last name
        :param str company: Company
        :param str city: City
        :param str state: State
        :param str postal_code: Postal code
        :param str country_code: Country code (ISO-3166 two letter)
        :param str phone: Phone
        :param str email: Email
        :param str original_order_date_begin: Original order date begin
        :param str original_order_date_end: Original order date end
        :param str next_shipment_date_begin: Next shipment date begin
        :param str next_shipment_date_end: Next shipment date end
        :param str card_type: Card type
        :param str item_id: Item ID
        :param str status: Status
        :param int limit: The maximum number of records to return on this one API call. (Max 200)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str since: Fetch auto orders that have been created/modified since this date/time.
        :param str sort: The sort order of the auto orders.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: AutoOrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auto_orders_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_auto_orders_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_auto_orders_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve auto orders  # noqa: E501

        Retrieves auto orders from the account.  If no parameters are specified, all auto orders will be returned.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auto_orders_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auto_order_code: Auto order code
        :param str original_order_id: Original order id
        :param str first_name: First name
        :param str last_name: Last name
        :param str company: Company
        :param str city: City
        :param str state: State
        :param str postal_code: Postal code
        :param str country_code: Country code (ISO-3166 two letter)
        :param str phone: Phone
        :param str email: Email
        :param str original_order_date_begin: Original order date begin
        :param str original_order_date_end: Original order date end
        :param str next_shipment_date_begin: Next shipment date begin
        :param str next_shipment_date_end: Next shipment date end
        :param str card_type: Card type
        :param str item_id: Item ID
        :param str status: Status
        :param int limit: The maximum number of records to return on this one API call. (Max 200)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str since: Fetch auto orders that have been created/modified since this date/time.
        :param str sort: The sort order of the auto orders.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: AutoOrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auto_order_code', 'original_order_id', 'first_name', 'last_name', 'company', 'city', 'state', 'postal_code', 'country_code', 'phone', 'email', 'original_order_date_begin', 'original_order_date_end', 'next_shipment_date_begin', 'next_shipment_date_end', 'card_type', 'item_id', 'status', 'limit', 'offset', 'since', 'sort', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auto_orders" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'auto_order_code' in params:
            query_params.append(('auto_order_code', params['auto_order_code']))  # noqa: E501
        if 'original_order_id' in params:
            query_params.append(('original_order_id', params['original_order_id']))  # noqa: E501
        if 'first_name' in params:
            query_params.append(('first_name', params['first_name']))  # noqa: E501
        if 'last_name' in params:
            query_params.append(('last_name', params['last_name']))  # noqa: E501
        if 'company' in params:
            query_params.append(('company', params['company']))  # noqa: E501
        if 'city' in params:
            query_params.append(('city', params['city']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'postal_code' in params:
            query_params.append(('postal_code', params['postal_code']))  # noqa: E501
        if 'country_code' in params:
            query_params.append(('country_code', params['country_code']))  # noqa: E501
        if 'phone' in params:
            query_params.append(('phone', params['phone']))  # noqa: E501
        if 'email' in params:
            query_params.append(('email', params['email']))  # noqa: E501
        if 'original_order_date_begin' in params:
            query_params.append(('original_order_date_begin', params['original_order_date_begin']))  # noqa: E501
        if 'original_order_date_end' in params:
            query_params.append(('original_order_date_end', params['original_order_date_end']))  # noqa: E501
        if 'next_shipment_date_begin' in params:
            query_params.append(('next_shipment_date_begin', params['next_shipment_date_begin']))  # noqa: E501
        if 'next_shipment_date_end' in params:
            query_params.append(('next_shipment_date_end', params['next_shipment_date_end']))  # noqa: E501
        if 'card_type' in params:
            query_params.append(('card_type', params['card_type']))  # noqa: E501
        if 'item_id' in params:
            query_params.append(('item_id', params['item_id']))  # noqa: E501
        if 'status' in params:
            query_params.append(('status', params['status']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('_limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('_offset', params['offset']))  # noqa: E501
        if 'since' in params:
            query_params.append(('_since', params['since']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('_sort', params['sort']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/auto_order/auto_orders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AutoOrdersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auto_orders_batch(self, auto_order_batch, **kwargs):  # noqa: E501
        """Retrieve auto order batch  # noqa: E501

        Retrieves a group of auto orders from the account based on an array of auto order oids.  If more than 200 auto order ids are specified, the API call will fail with a bad request error.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auto_orders_batch(auto_order_batch, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AutoOrderQueryBatch auto_order_batch: Auto order batch (required)
        :param str expand: The object expansion to perform on the result.
        :return: AutoOrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auto_orders_batch_with_http_info(auto_order_batch, **kwargs)  # noqa: E501
        else:
            (data) = self.get_auto_orders_batch_with_http_info(auto_order_batch, **kwargs)  # noqa: E501
            return data

    def get_auto_orders_batch_with_http_info(self, auto_order_batch, **kwargs):  # noqa: E501
        """Retrieve auto order batch  # noqa: E501

        Retrieves a group of auto orders from the account based on an array of auto order oids.  If more than 200 auto order ids are specified, the API call will fail with a bad request error.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auto_orders_batch_with_http_info(auto_order_batch, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AutoOrderQueryBatch auto_order_batch: Auto order batch (required)
        :param str expand: The object expansion to perform on the result.
        :return: AutoOrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auto_order_batch', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auto_orders_batch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auto_order_batch' is set
        if ('auto_order_batch' not in params or
                params['auto_order_batch'] is None):
            raise ValueError("Missing the required parameter `auto_order_batch` when calling `get_auto_orders_batch`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auto_order_batch' in params:
            body_params = params['auto_order_batch']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/auto_order/auto_orders/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AutoOrdersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auto_orders_by_query(self, auto_order_query, **kwargs):  # noqa: E501
        """Retrieve auto orders by query  # noqa: E501

        Retrieves a group of auto orders from the account based on a query object.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auto_orders_by_query(auto_order_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AutoOrderQuery auto_order_query: Auto order query (required)
        :param int limit: The maximum number of records to return on this one API call. (Maximum 200)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the auto orders.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :param str expand: The object expansion to perform on the result.
        :return: AutoOrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auto_orders_by_query_with_http_info(auto_order_query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_auto_orders_by_query_with_http_info(auto_order_query, **kwargs)  # noqa: E501
            return data

    def get_auto_orders_by_query_with_http_info(self, auto_order_query, **kwargs):  # noqa: E501
        """Retrieve auto orders by query  # noqa: E501

        Retrieves a group of auto orders from the account based on a query object.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auto_orders_by_query_with_http_info(auto_order_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AutoOrderQuery auto_order_query: Auto order query (required)
        :param int limit: The maximum number of records to return on this one API call. (Maximum 200)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the auto orders.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :param str expand: The object expansion to perform on the result.
        :return: AutoOrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auto_order_query', 'limit', 'offset', 'sort', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auto_orders_by_query" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auto_order_query' is set
        if ('auto_order_query' not in params or
                params['auto_order_query'] is None):
            raise ValueError("Missing the required parameter `auto_order_query` when calling `get_auto_orders_by_query`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('_limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('_offset', params['offset']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('_sort', params['sort']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auto_order_query' in params:
            body_params = params['auto_order_query']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/auto_order/auto_orders/query', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AutoOrdersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_auto_order(self, auto_order, auto_order_oid, **kwargs):  # noqa: E501
        """Update an auto order  # noqa: E501

        Update an auto order on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_auto_order(auto_order, auto_order_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AutoOrder auto_order: Auto order to update (required)
        :param int auto_order_oid: The auto order oid to update. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: AutoOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_auto_order_with_http_info(auto_order, auto_order_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.update_auto_order_with_http_info(auto_order, auto_order_oid, **kwargs)  # noqa: E501
            return data

    def update_auto_order_with_http_info(self, auto_order, auto_order_oid, **kwargs):  # noqa: E501
        """Update an auto order  # noqa: E501

        Update an auto order on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_auto_order_with_http_info(auto_order, auto_order_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AutoOrder auto_order: Auto order to update (required)
        :param int auto_order_oid: The auto order oid to update. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: AutoOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auto_order', 'auto_order_oid', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_auto_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auto_order' is set
        if ('auto_order' not in params or
                params['auto_order'] is None):
            raise ValueError("Missing the required parameter `auto_order` when calling `update_auto_order`")  # noqa: E501
        # verify the required parameter 'auto_order_oid' is set
        if ('auto_order_oid' not in params or
                params['auto_order_oid'] is None):
            raise ValueError("Missing the required parameter `auto_order_oid` when calling `update_auto_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auto_order_oid' in params:
            path_params['auto_order_oid'] = params['auto_order_oid']  # noqa: E501

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auto_order' in params:
            body_params = params['auto_order']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/auto_order/auto_orders/{auto_order_oid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AutoOrderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_auto_orders_batch(self, auto_orders_request, **kwargs):  # noqa: E501
        """Update multiple auto orders  # noqa: E501

        Update multiple auto orders on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_auto_orders_batch(auto_orders_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AutoOrdersRequest auto_orders_request: Auto orders to update (synchronous maximum 20 / asynchronous maximum 100) (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :param bool placeholders: Whether or not placeholder values should be returned in the result.  Useful for UIs that consume this REST API.
        :param bool _async: True if the operation should be run async.  No result returned
        :return: AutoOrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_auto_orders_batch_with_http_info(auto_orders_request, **kwargs)  # noqa: E501
        else:
            (data) = self.update_auto_orders_batch_with_http_info(auto_orders_request, **kwargs)  # noqa: E501
            return data

    def update_auto_orders_batch_with_http_info(self, auto_orders_request, **kwargs):  # noqa: E501
        """Update multiple auto orders  # noqa: E501

        Update multiple auto orders on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_auto_orders_batch_with_http_info(auto_orders_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AutoOrdersRequest auto_orders_request: Auto orders to update (synchronous maximum 20 / asynchronous maximum 100) (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :param bool placeholders: Whether or not placeholder values should be returned in the result.  Useful for UIs that consume this REST API.
        :param bool _async: True if the operation should be run async.  No result returned
        :return: AutoOrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auto_orders_request', 'expand', 'placeholders', '_async']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_auto_orders_batch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auto_orders_request' is set
        if ('auto_orders_request' not in params or
                params['auto_orders_request'] is None):
            raise ValueError("Missing the required parameter `auto_orders_request` when calling `update_auto_orders_batch`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501
        if 'placeholders' in params:
            query_params.append(('_placeholders', params['placeholders']))  # noqa: E501
        if '_async' in params:
            query_params.append(('_async', params['_async']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auto_orders_request' in params:
            body_params = params['auto_orders_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/auto_order/auto_orders/batch', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AutoOrdersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
