# coding: utf-8

"""
    UltraCart Rest API V2

    UltraCart REST API Version 2  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@ultracart.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ultracart.api_client import ApiClient
from ultracart.configuration import Configuration

class AffiliateApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    @classmethod
    def fromApiKey(cls, apiKey, verify_ssl = True, debug = False):
        config = Configuration()
        config.api_key['x-ultracart-simple-key'] = apiKey
        config.debug = debug
        config.verify_ssl = verify_ssl

        api_client = ApiClient(configuration=config, header_name='X-UltraCart-Api-Version', header_value='2017-03-01')
        return AffiliateApi(api_client)




    def get_clicks_by_query(self, click_query, **kwargs):  # noqa: E501
        """Retrieve clicks  # noqa: E501

        Retrieves a group of clicks from the account based on a query object.  If no parameters are specified, the API call will fail with a bad request error.  Always specify some parameters to limit the scope of the clicks returned to ones you are truly interested in.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_clicks_by_query(click_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AffiliateClickQuery click_query: Click query (required)
        :param int limit: The maximum number of records to return on this one API call. (Maximum 10000)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str expand: The object expansion to perform on the result.  Only option is link.
        :return: AffiliateClicksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_clicks_by_query_with_http_info(click_query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_clicks_by_query_with_http_info(click_query, **kwargs)  # noqa: E501
            return data

    def get_clicks_by_query_with_http_info(self, click_query, **kwargs):  # noqa: E501
        """Retrieve clicks  # noqa: E501

        Retrieves a group of clicks from the account based on a query object.  If no parameters are specified, the API call will fail with a bad request error.  Always specify some parameters to limit the scope of the clicks returned to ones you are truly interested in.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_clicks_by_query_with_http_info(click_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AffiliateClickQuery click_query: Click query (required)
        :param int limit: The maximum number of records to return on this one API call. (Maximum 10000)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str expand: The object expansion to perform on the result.  Only option is link.
        :return: AffiliateClicksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['click_query', 'limit', 'offset', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clicks_by_query" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'click_query' is set
        if ('click_query' not in params or
                params['click_query'] is None):
            raise ValueError("Missing the required parameter `click_query` when calling `get_clicks_by_query`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('_limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('_offset', params['offset']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'click_query' in params:
            body_params = params['click_query']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/affiliate/clicks/query', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AffiliateClicksResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ledgers_by_query(self, ledger_query, **kwargs):  # noqa: E501
        """Retrieve ledger entries  # noqa: E501

        Retrieves a group of ledger entries from the account based on a query object.  If no parameters are specified, the API call will fail with a bad request error.  Always specify some parameters to limit the scope of the ledgers returned to ones you are truly interested in.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ledgers_by_query(ledger_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AffiliateLedgerQuery ledger_query: Ledger query (required)
        :param int limit: The maximum number of records to return on this one API call. (Maximum 200)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str expand: The object expansion to perform on the result.  Only option is link.
        :return: AffiliateLedgersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ledgers_by_query_with_http_info(ledger_query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ledgers_by_query_with_http_info(ledger_query, **kwargs)  # noqa: E501
            return data

    def get_ledgers_by_query_with_http_info(self, ledger_query, **kwargs):  # noqa: E501
        """Retrieve ledger entries  # noqa: E501

        Retrieves a group of ledger entries from the account based on a query object.  If no parameters are specified, the API call will fail with a bad request error.  Always specify some parameters to limit the scope of the ledgers returned to ones you are truly interested in.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ledgers_by_query_with_http_info(ledger_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AffiliateLedgerQuery ledger_query: Ledger query (required)
        :param int limit: The maximum number of records to return on this one API call. (Maximum 200)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str expand: The object expansion to perform on the result.  Only option is link.
        :return: AffiliateLedgersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ledger_query', 'limit', 'offset', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ledgers_by_query" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ledger_query' is set
        if ('ledger_query' not in params or
                params['ledger_query'] is None):
            raise ValueError("Missing the required parameter `ledger_query` when calling `get_ledgers_by_query`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('_limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('_offset', params['offset']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ledger_query' in params:
            body_params = params['ledger_query']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/affiliate/ledgers/query', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AffiliateLedgersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
