# ultracart_rest_sdk
UltraCart REST API Version 2

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 2.0.0
- Package version: 3.10.25
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [http://www.ultracart.com](http://www.ultracart.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/UltraCart/rest_api_v2_sdk_python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/UltraCart/rest_api_v2_sdk_python.git`)

Then import the package:
```python
import ultracart 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import ultracart
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
# retrieve an auto order
import ultracart
from ultracart.rest import ApiException
from ultracart import ApiClient
from pprint import pprint

# Create a Simple Key: https://ultracart.atlassian.net/wiki/spaces/ucdoc/pages/38688545/API+Simple+Key
simple_key = '109ee846ee69f50177018ab12f008a00748a25aa28dbdc0177018ab12f008a00'
api_instance = ultracart.AutoorderApi.fromApiKey(simple_key, False, True)

auto_order_oid = 3268342  # int | The auto order oid to retrieve.
expand = 'items'  # str | Expansion determines how much of the object to return.  See documentation for examples (optional)

try:

    auto_order_response = api_instance.get_auto_order(auto_order_oid, expand=expand)
    auto_order = auto_order_response.auto_order

    pprint(auto_order)
except ApiException as e:
    print ("Exception when calling AutoorderApi->get_auto_order: %s\n" % e)
```

Retrieve all distribution centers
```python
import time
import ultracart
from ultracart.rest import ApiException
from pprint import pprint

# Create a Simple Key: https://ultracart.atlassian.net/wiki/spaces/ucdoc/pages/38688545/API+Simple+Key
simple_key = '109ee846ee69f50177018ab12f008a00748a25aa28dbdc0177018ab12f008a00'
api_instance = ultracart.FulfillmentApi.fromApiKey(simple_key, False, True)

try:
    # Retrieve distribution centers
    api_response = api_instance.get_distribution_centers()
    pprint(api_response)
except ApiException as e:
    print ("Exception when calling FulfillmentApi->get_distribution_centers: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://secure.ultracart.com/rest/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AffiliateApi* | [**get_clicks_by_query**](docs/AffiliateApi.md#get_clicks_by_query) | **POST** /affiliate/clicks/query | Retrieve clicks
*AffiliateApi* | [**get_ledgers_by_query**](docs/AffiliateApi.md#get_ledgers_by_query) | **POST** /affiliate/ledgers/query | Retrieve ledger entries
*AutoOrderApi* | [**get_auto_order**](docs/AutoOrderApi.md#get_auto_order) | **GET** /auto_order/auto_orders/{auto_order_oid} | Retrieve an auto order by oid
*AutoOrderApi* | [**get_auto_order_by_code**](docs/AutoOrderApi.md#get_auto_order_by_code) | **GET** /auto_order/auto_orders/code/{auto_order_code} | Retrieve an auto order by code
*AutoOrderApi* | [**get_auto_order_by_reference_order_id**](docs/AutoOrderApi.md#get_auto_order_by_reference_order_id) | **GET** /auto_order/auto_orders/reference_order_id/{reference_order_id} | Retrieve an auto order by order id
*AutoOrderApi* | [**get_auto_orders**](docs/AutoOrderApi.md#get_auto_orders) | **GET** /auto_order/auto_orders | Retrieve auto orders
*AutoOrderApi* | [**get_auto_orders_batch**](docs/AutoOrderApi.md#get_auto_orders_batch) | **POST** /auto_order/auto_orders/batch | Retrieve auto order batch
*AutoOrderApi* | [**get_auto_orders_by_query**](docs/AutoOrderApi.md#get_auto_orders_by_query) | **POST** /auto_order/auto_orders/query | Retrieve auto orders by query
*AutoOrderApi* | [**update_auto_order**](docs/AutoOrderApi.md#update_auto_order) | **PUT** /auto_order/auto_orders/{auto_order_oid} | Update an auto order
*AutoOrderApi* | [**update_auto_orders_batch**](docs/AutoOrderApi.md#update_auto_orders_batch) | **PUT** /auto_order/auto_orders/batch | Update multiple auto orders
*ChannelPartnerApi* | [**cancel_order_by_channel_partner_order_id**](docs/ChannelPartnerApi.md#cancel_order_by_channel_partner_order_id) | **DELETE** /channel_partner/cancel/by_channel_partner_order_id/{order_id} | Cancel channel partner order by channel partner order id
*ChannelPartnerApi* | [**cancel_order_by_ultra_cart_order_id**](docs/ChannelPartnerApi.md#cancel_order_by_ultra_cart_order_id) | **DELETE** /channel_partner/cancel/by_ultracart_order_id/{order_id} | Cancel channel partner order by UltraCart order id
*ChannelPartnerApi* | [**estimate_shipping_for_channel_partner_order**](docs/ChannelPartnerApi.md#estimate_shipping_for_channel_partner_order) | **POST** /channel_partner/estimate_shipping | Estimate shipping for channel partner order
*ChannelPartnerApi* | [**estimate_tax_for_channel_partner_order**](docs/ChannelPartnerApi.md#estimate_tax_for_channel_partner_order) | **POST** /channel_partner/estimate_tax | Estimate tax for channel partner order
*ChannelPartnerApi* | [**import_channel_partner_order**](docs/ChannelPartnerApi.md#import_channel_partner_order) | **POST** /channel_partner/import | Insert channel partner order
*ChargebackApi* | [**delete_chargeback**](docs/ChargebackApi.md#delete_chargeback) | **DELETE** /chargeback/chargebacks/{chargeback_dispute_oid} | Delete a chargeback
*ChargebackApi* | [**get_chargeback_dispute**](docs/ChargebackApi.md#get_chargeback_dispute) | **GET** /chargeback/chargebacks/{chargeback_dispute_oid} | Retrieve a chargeback
*ChargebackApi* | [**get_chargeback_disputes**](docs/ChargebackApi.md#get_chargeback_disputes) | **GET** /chargeback/chargebacks | Retrieve chargebacks
*ChargebackApi* | [**insert_chargeback**](docs/ChargebackApi.md#insert_chargeback) | **POST** /chargeback/chargebacks | Insert a chargeback
*ChargebackApi* | [**update_chargeback**](docs/ChargebackApi.md#update_chargeback) | **PUT** /chargeback/chargebacks/{chargeback_dispute_oid} | Update a chargeback
*CheckoutApi* | [**city_state**](docs/CheckoutApi.md#city_state) | **POST** /checkout/city_state | City/State for Zip
*CheckoutApi* | [**finalize_order**](docs/CheckoutApi.md#finalize_order) | **POST** /checkout/cart/finalizeOrder | Finalize Order
*CheckoutApi* | [**get_affirm_checkout**](docs/CheckoutApi.md#get_affirm_checkout) | **GET** /checkout/cart/{cart_id}/affirmCheckout | Get affirm checkout (by cart id)
*CheckoutApi* | [**get_allowed_countries**](docs/CheckoutApi.md#get_allowed_countries) | **POST** /checkout/allowedCountries | Allowed countries
*CheckoutApi* | [**get_cart**](docs/CheckoutApi.md#get_cart) | **GET** /checkout/cart | Get cart
*CheckoutApi* | [**get_cart_by_cart_id**](docs/CheckoutApi.md#get_cart_by_cart_id) | **GET** /checkout/cart/{cart_id} | Get cart (by cart id)
*CheckoutApi* | [**get_cart_by_return_code**](docs/CheckoutApi.md#get_cart_by_return_code) | **GET** /checkout/return/{return_code} | Get cart (by return code)
*CheckoutApi* | [**get_cart_by_return_token**](docs/CheckoutApi.md#get_cart_by_return_token) | **GET** /checkout/return_token | Get cart (by return token)
*CheckoutApi* | [**get_state_provinces_for_country**](docs/CheckoutApi.md#get_state_provinces_for_country) | **POST** /checkout/stateProvincesForCountry/{country_code} | Get state/province list for a country code
*CheckoutApi* | [**handoff_cart**](docs/CheckoutApi.md#handoff_cart) | **POST** /checkout/cart/handoff | Handoff cart
*CheckoutApi* | [**login**](docs/CheckoutApi.md#login) | **POST** /checkout/cart/profile/login | Profile login
*CheckoutApi* | [**logout**](docs/CheckoutApi.md#logout) | **POST** /checkout/cart/profile/logout | Profile logout
*CheckoutApi* | [**register**](docs/CheckoutApi.md#register) | **POST** /checkout/cart/profile/register | Profile registration
*CheckoutApi* | [**register_affiliate_click**](docs/CheckoutApi.md#register_affiliate_click) | **POST** /checkout/affiliateClick/register | Register affiliate click
*CheckoutApi* | [**related_items_for_cart**](docs/CheckoutApi.md#related_items_for_cart) | **POST** /checkout/related_items | Related items
*CheckoutApi* | [**related_items_for_item**](docs/CheckoutApi.md#related_items_for_item) | **POST** /checkout/relatedItems/{item_id} | Related items (specific item)
*CheckoutApi* | [**setup_browser_key**](docs/CheckoutApi.md#setup_browser_key) | **PUT** /checkout/browser_key | Setup Browser Application
*CheckoutApi* | [**update_cart**](docs/CheckoutApi.md#update_cart) | **PUT** /checkout/cart | Update cart
*CheckoutApi* | [**validate_cart**](docs/CheckoutApi.md#validate_cart) | **POST** /checkout/cart/validate | Validate
*ConversationApi* | [**get_agent_websocket_authorization**](docs/ConversationApi.md#get_agent_websocket_authorization) | **PUT** /conversation/agent/auth | Get agent websocket authorization
*ConversationApi* | [**get_conversation**](docs/ConversationApi.md#get_conversation) | **GET** /conversation/conversations/{conversation_uuid} | Retrieve a conversation
*ConversationApi* | [**get_conversation_multimedia_upload_url**](docs/ConversationApi.md#get_conversation_multimedia_upload_url) | **GET** /conversation/upload_url/{extension} | Get a presigned conersation multimedia upload URL
*ConversationApi* | [**get_conversations**](docs/ConversationApi.md#get_conversations) | **GET** /conversation/conversations | Retrieve a list of conversation summaries newest to oldest
*ConversationApi* | [**join_conversation**](docs/ConversationApi.md#join_conversation) | **PUT** /conversation/conversations/{conversation_uuid}/join | Join a conversation
*ConversationApi* | [**leave_conversation**](docs/ConversationApi.md#leave_conversation) | **DELETE** /conversation/conversations/{conversation_uuid}/leave | Leave a conversation
*ConversationApi* | [**start_conversation**](docs/ConversationApi.md#start_conversation) | **PUT** /conversation/conversations | Start a conversation
*CouponApi* | [**delete_coupon**](docs/CouponApi.md#delete_coupon) | **DELETE** /coupon/coupons/{coupon_oid} | Delete a coupon
*CouponApi* | [**delete_coupons_by_code**](docs/CouponApi.md#delete_coupons_by_code) | **DELETE** /coupon/coupons/by_code | Deletes multiple coupons
*CouponApi* | [**delete_coupons_by_oid**](docs/CouponApi.md#delete_coupons_by_oid) | **DELETE** /coupon/coupons/by_oid | Deletes multiple coupons
*CouponApi* | [**does_coupon_code_exist**](docs/CouponApi.md#does_coupon_code_exist) | **GET** /coupon/coupons/merchant_code/{merchant_code}/exists | Determines if a coupon merchant code already exists
*CouponApi* | [**generate_coupon_codes**](docs/CouponApi.md#generate_coupon_codes) | **POST** /coupon/coupons/{coupon_oid}/generate_codes | Generates one time codes for a coupon
*CouponApi* | [**generate_one_time_codes_by_merchant_code**](docs/CouponApi.md#generate_one_time_codes_by_merchant_code) | **POST** /coupon/coupons/merchant_code/{merchant_code}/generate_codes | Generates one time codes by merchant code
*CouponApi* | [**get_auto_apply**](docs/CouponApi.md#get_auto_apply) | **GET** /coupon/auto_apply | Retrieve auto apply rules and conditions
*CouponApi* | [**get_coupon**](docs/CouponApi.md#get_coupon) | **GET** /coupon/coupons/{coupon_oid} | Retrieve a coupon
*CouponApi* | [**get_coupon_by_merchant_code**](docs/CouponApi.md#get_coupon_by_merchant_code) | **GET** /coupon/coupons/merchant_code/{merchant_code} | Retrieve a coupon by merchant code
*CouponApi* | [**get_coupons**](docs/CouponApi.md#get_coupons) | **GET** /coupon/coupons | Retrieve coupons
*CouponApi* | [**get_coupons_by_query**](docs/CouponApi.md#get_coupons_by_query) | **POST** /coupon/coupons/query | Retrieve coupons by query
*CouponApi* | [**get_editor_values**](docs/CouponApi.md#get_editor_values) | **GET** /coupon/editor_values | Retrieve values needed for a coupon editor
*CouponApi* | [**insert_coupon**](docs/CouponApi.md#insert_coupon) | **POST** /coupon/coupons | Insert a coupon
*CouponApi* | [**insert_coupons**](docs/CouponApi.md#insert_coupons) | **POST** /coupon/coupons/batch | Insert multiple coupons
*CouponApi* | [**search_items**](docs/CouponApi.md#search_items) | **GET** /coupon/searchItems | Searches for items to display within a coupon editor and assign to coupons
*CouponApi* | [**update_auto_apply**](docs/CouponApi.md#update_auto_apply) | **POST** /coupon/auto_apply | Update auto apply rules and conditions
*CouponApi* | [**update_coupon**](docs/CouponApi.md#update_coupon) | **PUT** /coupon/coupons/{coupon_oid} | Update a coupon
*CouponApi* | [**update_coupons**](docs/CouponApi.md#update_coupons) | **PUT** /coupon/coupons/batch | Update multiple coupons
*CouponApi* | [**upload_coupon_codes**](docs/CouponApi.md#upload_coupon_codes) | **POST** /coupon/coupons/{coupon_oid}/upload_codes | Upload one-time codes for a coupon
*CustomerApi* | [**add_customer_store_credit**](docs/CustomerApi.md#add_customer_store_credit) | **POST** /customer/customers/{customer_profile_oid}/store_credit | Adds store credit to a customer
*CustomerApi* | [**adjust_internal_certificate**](docs/CustomerApi.md#adjust_internal_certificate) | **POST** /customer/customers/{customer_profile_oid}/adjust_cashback_balance | Updates the cashback balance for a customer by updating the internal gift certificate used, creating the gift certificate if needed.
*CustomerApi* | [**delete_customer**](docs/CustomerApi.md#delete_customer) | **DELETE** /customer/customers/{customer_profile_oid} | Delete a customer
*CustomerApi* | [**get_customer**](docs/CustomerApi.md#get_customer) | **GET** /customer/customers/{customer_profile_oid} | Retrieve a customer
*CustomerApi* | [**get_customer_by_email**](docs/CustomerApi.md#get_customer_by_email) | **GET** /customer/customers/by_email/{email} | Retrieve a customer by Email
*CustomerApi* | [**get_customer_editor_values**](docs/CustomerApi.md#get_customer_editor_values) | **GET** /customer/editor_values | Retrieve values needed for a customer profile editor
*CustomerApi* | [**get_customer_email_lists**](docs/CustomerApi.md#get_customer_email_lists) | **GET** /customer/email_lists | Retrieve all email lists across all storefronts
*CustomerApi* | [**get_customer_store_credit**](docs/CustomerApi.md#get_customer_store_credit) | **GET** /customer/customers/{customer_profile_oid}/store_credit | Retrieve the customer store credit accumulated through loyalty programs
*CustomerApi* | [**get_customers**](docs/CustomerApi.md#get_customers) | **GET** /customer/customers | Retrieve customers
*CustomerApi* | [**get_customers_by_query**](docs/CustomerApi.md#get_customers_by_query) | **POST** /customer/customers/query | Retrieve customers by query
*CustomerApi* | [**get_customers_for_data_tables**](docs/CustomerApi.md#get_customers_for_data_tables) | **POST** /customer/customers/dataTables | Retrieve customers for DataTables plugin
*CustomerApi* | [**get_email_verification_token**](docs/CustomerApi.md#get_email_verification_token) | **POST** /customer/customers/email_verify/get_token | Create a token that can be used to verify a customer email address
*CustomerApi* | [**insert_customer**](docs/CustomerApi.md#insert_customer) | **POST** /customer/customers | Insert a customer
*CustomerApi* | [**merge_customer**](docs/CustomerApi.md#merge_customer) | **PUT** /customer/customers/{customer_profile_oid}/merge | Merge customer into this customer
*CustomerApi* | [**search_customer_profile_values**](docs/CustomerApi.md#search_customer_profile_values) | **POST** /customer/search | Searches for all matching values (using POST)
*CustomerApi* | [**update_customer**](docs/CustomerApi.md#update_customer) | **PUT** /customer/customers/{customer_profile_oid} | Update a customer
*CustomerApi* | [**update_customer_email_lists**](docs/CustomerApi.md#update_customer_email_lists) | **POST** /customer/customers/{customer_profile_oid}/email_lists | Update email list subscriptions for a customer
*CustomerApi* | [**validate_email_verification_token**](docs/CustomerApi.md#validate_email_verification_token) | **POST** /customer/customers/email_verify/validate_token | Validate a token that can be used to verify a customer email address
*FulfillmentApi* | [**acknowledge_orders**](docs/FulfillmentApi.md#acknowledge_orders) | **PUT** /fulfillment/distribution_centers/{distribution_center_code}/acknowledgements | Acknowledge receipt of orders.
*FulfillmentApi* | [**generate_packing_slip**](docs/FulfillmentApi.md#generate_packing_slip) | **GET** /fulfillment/distribution_centers/{distribution_center_code}/orders/{order_id} | Generate a packing slip for this order for the given distribution center.
*FulfillmentApi* | [**get_distribution_center_orders**](docs/FulfillmentApi.md#get_distribution_center_orders) | **GET** /fulfillment/distribution_centers/{distribution_center_code}/orders | Retrieve orders queued up for this distribution center.
*FulfillmentApi* | [**get_distribution_centers**](docs/FulfillmentApi.md#get_distribution_centers) | **GET** /fulfillment/distribution_centers | Retrieve distribution centers
*FulfillmentApi* | [**ship_orders**](docs/FulfillmentApi.md#ship_orders) | **POST** /fulfillment/distribution_centers/{distribution_center_code}/shipments | Mark orders as shipped
*FulfillmentApi* | [**update_inventory**](docs/FulfillmentApi.md#update_inventory) | **POST** /fulfillment/distribution_centers/{distribution_center_code}/inventory | Update inventory
*GiftCertificateApi* | [**add_gift_certificate_ledger_entry**](docs/GiftCertificateApi.md#add_gift_certificate_ledger_entry) | **POST** /gift_certificate/gift_certificates/{gift_certificate_oid}/ledger_entry | Add a gift certificate ledger entry
*GiftCertificateApi* | [**create_gift_certificate**](docs/GiftCertificateApi.md#create_gift_certificate) | **POST** /gift_certificate/gift_certificates | Create a gift certificate
*GiftCertificateApi* | [**delete_gift_certificate**](docs/GiftCertificateApi.md#delete_gift_certificate) | **DELETE** /gift_certificate/gift_certificates/{gift_certificate_oid} | Delete a gift certificate
*GiftCertificateApi* | [**get_gift_certificate_by_code**](docs/GiftCertificateApi.md#get_gift_certificate_by_code) | **POST** /gift_certificate/gift_certificates/by_code/{code} | Retrieve gift certificate by code
*GiftCertificateApi* | [**get_gift_certificate_by_oid**](docs/GiftCertificateApi.md#get_gift_certificate_by_oid) | **POST** /gift_certificate/gift_certificates/{gift_certificate_oid} | Retrieve gift certificate by oid
*GiftCertificateApi* | [**get_gift_certificates_by_email**](docs/GiftCertificateApi.md#get_gift_certificates_by_email) | **POST** /gift_certificate/gift_certificates/by_email/{email} | Retrieve gift certificate by email
*GiftCertificateApi* | [**get_gift_certificates_by_query**](docs/GiftCertificateApi.md#get_gift_certificates_by_query) | **POST** /gift_certificate/gift_certificates/query | Retrieve gift certificates by query
*GiftCertificateApi* | [**update_gift_certificate**](docs/GiftCertificateApi.md#update_gift_certificate) | **PUT** /gift_certificate/gift_certificates/{gift_certificate_oid} | Update a gift certificate
*IntegrationLogApi* | [**get_integration_log**](docs/IntegrationLogApi.md#get_integration_log) | **GET** /integration_log/query/{pk}/{sk} | Retrieve an integration log
*IntegrationLogApi* | [**get_integration_log_file**](docs/IntegrationLogApi.md#get_integration_log_file) | **GET** /integration_log/query/{pk}/{sk}/{uuid} | Retrieve an integration log file
*IntegrationLogApi* | [**get_integration_log_file_pdf**](docs/IntegrationLogApi.md#get_integration_log_file_pdf) | **GET** /integration_log/query/{pk}/{sk}/{uuid}/pdf | Retrieve an integration log file converted to PDF
*IntegrationLogApi* | [**get_integration_log_summaries_query**](docs/IntegrationLogApi.md#get_integration_log_summaries_query) | **POST** /integration_log/summary/query | Retrieve integration log summaries
*IntegrationLogApi* | [**get_integration_logs_query**](docs/IntegrationLogApi.md#get_integration_logs_query) | **POST** /integration_log/query | Retrieve integration logs
*ItemApi* | [**delete_item**](docs/ItemApi.md#delete_item) | **DELETE** /item/items/{merchant_item_oid} | Delete an item
*ItemApi* | [**get_item**](docs/ItemApi.md#get_item) | **GET** /item/items/{merchant_item_oid} | Retrieve an item
*ItemApi* | [**get_item_by_merchant_item_id**](docs/ItemApi.md#get_item_by_merchant_item_id) | **GET** /item/items/merchant_item_id/{merchant_item_id} | Retrieve an item by item id
*ItemApi* | [**get_items**](docs/ItemApi.md#get_items) | **GET** /item/items | Retrieve items
*ItemApi* | [**get_pricing_tiers**](docs/ItemApi.md#get_pricing_tiers) | **GET** /item/pricing_tiers | Retrieve pricing tiers
*ItemApi* | [**insert_item**](docs/ItemApi.md#insert_item) | **POST** /item/items | Create an item
*ItemApi* | [**update_item**](docs/ItemApi.md#update_item) | **PUT** /item/items/{merchant_item_oid} | Update an item
*ItemApi* | [**update_items**](docs/ItemApi.md#update_items) | **PUT** /item/items/batch | Update multiple items
*ItemApi* | [**upload_temporary_multimedia**](docs/ItemApi.md#upload_temporary_multimedia) | **POST** /item/temp_multimedia | Upload an image to the temporary multimedia.
*OauthApi* | [**oauth_access_token**](docs/OauthApi.md#oauth_access_token) | **POST** /oauth/token | Exchange authorization code for access token.
*OauthApi* | [**oauth_revoke**](docs/OauthApi.md#oauth_revoke) | **POST** /oauth/revoke | Revoke this OAuth application.
*OrderApi* | [**adjust_order_total**](docs/OrderApi.md#adjust_order_total) | **POST** /order/orders/{order_id}/adjust_order_total/{desired_total} | Adjusts an order total
*OrderApi* | [**cancel_order**](docs/OrderApi.md#cancel_order) | **POST** /order/orders/{order_id}/cancel | Cancel an order
*OrderApi* | [**delete_order**](docs/OrderApi.md#delete_order) | **DELETE** /order/orders/{order_id} | Delete an order
*OrderApi* | [**duplicate_order**](docs/OrderApi.md#duplicate_order) | **POST** /order/orders/{order_id}/duplicate | Duplicate an order
*OrderApi* | [**format**](docs/OrderApi.md#format) | **POST** /order/orders/{order_id}/format | Format order
*OrderApi* | [**generate_order_token**](docs/OrderApi.md#generate_order_token) | **GET** /order/orders/token/{order_id} | Generate an order token for a given order id
*OrderApi* | [**generate_packing_slip_all_dc**](docs/OrderApi.md#generate_packing_slip_all_dc) | **GET** /order/orders/{order_id}/packing_slip | Generate a packing slip for this order across all distribution centers.
*OrderApi* | [**generate_packing_slip_specific_dc**](docs/OrderApi.md#generate_packing_slip_specific_dc) | **GET** /order/orders/{order_id}/packing_slip/{distribution_center_code} | Generate a packing slip for this order for the given distribution center.
*OrderApi* | [**get_accounts_receivable_retry_config**](docs/OrderApi.md#get_accounts_receivable_retry_config) | **GET** /order/accountsReceivableRetryConfig | Retrieve A/R Retry Configuration
*OrderApi* | [**get_accounts_receivable_retry_stats**](docs/OrderApi.md#get_accounts_receivable_retry_stats) | **GET** /order/accountsReceivableRetryConfig/stats | Retrieve A/R Retry Statistics
*OrderApi* | [**get_order**](docs/OrderApi.md#get_order) | **GET** /order/orders/{order_id} | Retrieve an order
*OrderApi* | [**get_order_by_token**](docs/OrderApi.md#get_order_by_token) | **POST** /order/orders/token | Retrieve an order using a token
*OrderApi* | [**get_orders**](docs/OrderApi.md#get_orders) | **GET** /order/orders | Retrieve orders
*OrderApi* | [**get_orders_batch**](docs/OrderApi.md#get_orders_batch) | **POST** /order/orders/batch | Retrieve order batch
*OrderApi* | [**get_orders_by_query**](docs/OrderApi.md#get_orders_by_query) | **POST** /order/orders/query | Retrieve orders by query
*OrderApi* | [**insert_order**](docs/OrderApi.md#insert_order) | **POST** /order/orders | Insert an order
*OrderApi* | [**process_payment**](docs/OrderApi.md#process_payment) | **POST** /order/orders/{order_id}/process_payment | Process payment
*OrderApi* | [**refund_order**](docs/OrderApi.md#refund_order) | **PUT** /order/orders/{order_id}/refund | Refund an order
*OrderApi* | [**replacement**](docs/OrderApi.md#replacement) | **POST** /order/orders/{order_id}/replacement | Replacement order
*OrderApi* | [**resend_receipt**](docs/OrderApi.md#resend_receipt) | **POST** /order/orders/{order_id}/resend_receipt | Resend receipt
*OrderApi* | [**resend_shipment_confirmation**](docs/OrderApi.md#resend_shipment_confirmation) | **POST** /order/orders/{order_id}/resend_shipment_confirmation | Resend shipment confirmation
*OrderApi* | [**update_accounts_receivable_retry_config**](docs/OrderApi.md#update_accounts_receivable_retry_config) | **POST** /order/accountsReceivableRetryConfig | Update A/R Retry Configuration
*OrderApi* | [**update_order**](docs/OrderApi.md#update_order) | **PUT** /order/orders/{order_id} | Update an order
*SsoApi* | [**get_sso_session_user**](docs/SsoApi.md#get_sso_session_user) | **GET** /sso/session/user | Get single sign on session user
*SsoApi* | [**sso_authorize**](docs/SsoApi.md#sso_authorize) | **PUT** /sso/authorize | Authorize a single sign on session
*SsoApi* | [**sso_session_revoke**](docs/SsoApi.md#sso_session_revoke) | **DELETE** /sso/session/revoke | Revoke single sign on session
*SsoApi* | [**sso_token**](docs/SsoApi.md#sso_token) | **PUT** /sso/token | Exchange a single sign on code for a simple key token
*StorefrontApi* | [**add_to_library**](docs/StorefrontApi.md#add_to_library) | **POST** /storefront/code_library | Add to library
*StorefrontApi* | [**apply_to_store_front**](docs/StorefrontApi.md#apply_to_store_front) | **POST** /storefront/code_library/apply | Apply library item to storefront.
*StorefrontApi* | [**archive_email_list**](docs/StorefrontApi.md#archive_email_list) | **POST** /storefront/{storefront_oid}/email/lists/{email_list_uuid}/archive | Archive email list
*StorefrontApi* | [**archive_email_segment**](docs/StorefrontApi.md#archive_email_segment) | **POST** /storefront/{storefront_oid}/email/segments/{email_segment_uuid}/archive | Archive email segment
*StorefrontApi* | [**back_populate_email_flow**](docs/StorefrontApi.md#back_populate_email_flow) | **POST** /storefront/{storefront_oid}/email/flows/{email_flow_uuid}/backfill | Back populate email flow
*StorefrontApi* | [**check_download_email_segment**](docs/StorefrontApi.md#check_download_email_segment) | **POST** /storefront/{storefront_oid}/email/segments/{email_segment_uuid}/downloadPrepare/{email_segment_rebuild_uuid} | Check download of email segment
*StorefrontApi* | [**clone_email_campaign**](docs/StorefrontApi.md#clone_email_campaign) | **POST** /storefront/{storefront_oid}/email/campaigns/{email_campaign_uuid}/clone | Clone email campaign
*StorefrontApi* | [**clone_email_flow**](docs/StorefrontApi.md#clone_email_flow) | **POST** /storefront/{storefront_oid}/email/flows/{email_flow_uuid}/clone | Clone email flow
*StorefrontApi* | [**create_email_sending_domain**](docs/StorefrontApi.md#create_email_sending_domain) | **POST** /storefront/email/sending_domains/{domain}/create | Create email campaign
*StorefrontApi* | [**create_email_sending_domain2**](docs/StorefrontApi.md#create_email_sending_domain2) | **POST** /storefront/email/sending_domains | Create email sending domain for various providers
*StorefrontApi* | [**create_twilio_account**](docs/StorefrontApi.md#create_twilio_account) | **POST** /storefront/twilio/accounts | Create Twilio account
*StorefrontApi* | [**delete_email_campaign_folder**](docs/StorefrontApi.md#delete_email_campaign_folder) | **DELETE** /storefront/{storefront_oid}/email/campaign_folders/{email_campaign_folder_uuid} | Delete email campaignFolder
*StorefrontApi* | [**delete_email_commseq_stat**](docs/StorefrontApi.md#delete_email_commseq_stat) | **DELETE** /storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/stat | Delete communication sequence stats
*StorefrontApi* | [**delete_email_email**](docs/StorefrontApi.md#delete_email_email) | **DELETE** /storefront/{storefront_oid}/email/emails/{commseq_email_uuid} | Delete email email
*StorefrontApi* | [**delete_email_flow_folder**](docs/StorefrontApi.md#delete_email_flow_folder) | **DELETE** /storefront/{storefront_oid}/email/flow_folders/{email_flow_folder_uuid} | Delete email flowFolder
*StorefrontApi* | [**delete_email_list_customer**](docs/StorefrontApi.md#delete_email_list_customer) | **DELETE** /storefront/{storefront_oid}/email/lists/{email_list_uuid}/customers/{email_customer_uuid} | Delete email list customer
*StorefrontApi* | [**delete_email_list_segment_folder**](docs/StorefrontApi.md#delete_email_list_segment_folder) | **DELETE** /storefront/{storefront_oid}/email/list_segment_folders/{email_list_segment_folder_uuid} | Delete email ListSegmentFolder
*StorefrontApi* | [**delete_email_postcard**](docs/StorefrontApi.md#delete_email_postcard) | **DELETE** /storefront/{storefront_oid}/email/postcards/{commseq_postcard_uuid} | Delete email postcard
*StorefrontApi* | [**delete_email_sending_domain**](docs/StorefrontApi.md#delete_email_sending_domain) | **DELETE** /storefront/email/sending_domains/{domain} | delete email campaign
*StorefrontApi* | [**delete_experiment**](docs/StorefrontApi.md#delete_experiment) | **DELETE** /storefront/{storefront_oid}/experiments/{storefront_experiment_oid} | Delete experiment
*StorefrontApi* | [**delete_heatmap**](docs/StorefrontApi.md#delete_heatmap) | **DELETE** /storefront/{storefront_oid}/screen_recordings/heatmap | Delete screen recording heatmap
*StorefrontApi* | [**delete_library_item**](docs/StorefrontApi.md#delete_library_item) | **DELETE** /storefront/code_library/{library_item_oid} | Delete library item
*StorefrontApi* | [**delete_library_item_published_versions**](docs/StorefrontApi.md#delete_library_item_published_versions) | **DELETE** /storefront/code_library/{library_item_oid}/published_versions | Delete all published versions for a library item, including anything in review.
*StorefrontApi* | [**delete_screen_recording_segment**](docs/StorefrontApi.md#delete_screen_recording_segment) | **DELETE** /storefront/{storefront_oid}/screen_recordings/segments/{screen_recording_segment_oid} | Delete screen recording segment
*StorefrontApi* | [**delete_twilio_account**](docs/StorefrontApi.md#delete_twilio_account) | **DELETE** /storefront/twilio/accounts/{esp_twilio_uuid} | delete Twilio account
*StorefrontApi* | [**duplicate_library_item**](docs/StorefrontApi.md#duplicate_library_item) | **POST** /storefront/code_library/{library_item_oid}/duplicate | Duplicate library item.
*StorefrontApi* | [**favorite_screen_recording**](docs/StorefrontApi.md#favorite_screen_recording) | **POST** /storefront/{storefront_oid}/screen_recordings/{screen_recording_uuid}/favorite | Update favorite flag on screen recording
*StorefrontApi* | [**geocode_address**](docs/StorefrontApi.md#geocode_address) | **POST** /storefront/{storefront_oid}/email/geocode | Obtain lat/long for an address
*StorefrontApi* | [**get_countries**](docs/StorefrontApi.md#get_countries) | **GET** /storefront/{storefront_oid}/email/countries | Get countries
*StorefrontApi* | [**get_editor_token**](docs/StorefrontApi.md#get_editor_token) | **GET** /storefront/{storefront_oid}/editor_token | Gets editor token
*StorefrontApi* | [**get_email_base_templates**](docs/StorefrontApi.md#get_email_base_templates) | **GET** /storefront/{storefront_oid}/email/baseTemplates | Get email communication base templates
*StorefrontApi* | [**get_email_campaign**](docs/StorefrontApi.md#get_email_campaign) | **GET** /storefront/{storefront_oid}/email/campaigns/{email_campaign_uuid} | Get email campaign
*StorefrontApi* | [**get_email_campaign_folder**](docs/StorefrontApi.md#get_email_campaign_folder) | **GET** /storefront/{storefront_oid}/email/campaign_folders/{email_campaign_folder_uuid} | Get email campaign folder
*StorefrontApi* | [**get_email_campaign_folders**](docs/StorefrontApi.md#get_email_campaign_folders) | **GET** /storefront/{storefront_oid}/email/campaign_folders | Get email campaign folders
*StorefrontApi* | [**get_email_campaign_screenshots**](docs/StorefrontApi.md#get_email_campaign_screenshots) | **GET** /storefront/{storefront_oid}/email/campaigns/{email_campaign_uuid}/screenshots | Get email campaign screenshots
*StorefrontApi* | [**get_email_campaigns**](docs/StorefrontApi.md#get_email_campaigns) | **GET** /storefront/{storefront_oid}/email/campaigns | Get email campaigns
*StorefrontApi* | [**get_email_campaigns_with_stats**](docs/StorefrontApi.md#get_email_campaigns_with_stats) | **GET** /storefront/{storefront_oid}/email/campaignsWithStats/{stat_days} | Get email campaigns with stats
*StorefrontApi* | [**get_email_commseq**](docs/StorefrontApi.md#get_email_commseq) | **GET** /storefront/{storefront_oid}/email/commseqs/{commseq_uuid} | Get email commseq
*StorefrontApi* | [**get_email_commseq_email_stats**](docs/StorefrontApi.md#get_email_commseq_email_stats) | **POST** /storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/emailStats | Get email communication sequence emails stats
*StorefrontApi* | [**get_email_commseq_postcard_stats**](docs/StorefrontApi.md#get_email_commseq_postcard_stats) | **POST** /storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/postcardStats | Get email communication sequence postcard stats
*StorefrontApi* | [**get_email_commseq_stat_overall**](docs/StorefrontApi.md#get_email_commseq_stat_overall) | **GET** /storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/stat | Get communication sequence stats overall
*StorefrontApi* | [**get_email_commseq_step_stats**](docs/StorefrontApi.md#get_email_commseq_step_stats) | **POST** /storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/stepStats | Get email communication sequence step stats
*StorefrontApi* | [**get_email_commseq_step_waiting**](docs/StorefrontApi.md#get_email_commseq_step_waiting) | **POST** /storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/waiting | Get email communication sequence customers waiting at each requested step
*StorefrontApi* | [**get_email_commseq_webhook_editor_values**](docs/StorefrontApi.md#get_email_commseq_webhook_editor_values) | **GET** /storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/webhookEditorValues | Get email webhook editor values
*StorefrontApi* | [**get_email_commseqs**](docs/StorefrontApi.md#get_email_commseqs) | **GET** /storefront/{storefront_oid}/email/commseqs | Get email commseqs
*StorefrontApi* | [**get_email_customer_editor_url**](docs/StorefrontApi.md#get_email_customer_editor_url) | **GET** /storefront/{storefront_oid}/email/customers/{email_customer_uuid}/editor_url | Get customers editor URL
*StorefrontApi* | [**get_email_customers**](docs/StorefrontApi.md#get_email_customers) | **GET** /storefront/{storefront_oid}/email/customers | Get email customers
*StorefrontApi* | [**get_email_dashboard_activity**](docs/StorefrontApi.md#get_email_dashboard_activity) | **GET** /storefront/{storefront_oid}/email/dashboard_activity | Get email dashboard activity
*StorefrontApi* | [**get_email_dashboard_stats**](docs/StorefrontApi.md#get_email_dashboard_stats) | **GET** /storefront/{storefront_oid}/email/dashboard_stats | Get dashboard stats
*StorefrontApi* | [**get_email_dispatch_logs**](docs/StorefrontApi.md#get_email_dispatch_logs) | **GET** /storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/steps/{commseq_step_uuid}/logs | Get email dispatch logs
*StorefrontApi* | [**get_email_email**](docs/StorefrontApi.md#get_email_email) | **GET** /storefront/{storefront_oid}/email/emails/{commseq_email_uuid} | Get email email
*StorefrontApi* | [**get_email_email_clicks**](docs/StorefrontApi.md#get_email_email_clicks) | **GET** /storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/steps/{commseq_step_uuid}/emails/{commseq_email_uuid}/clicks | Get email email clicks
*StorefrontApi* | [**get_email_email_customer_editor_url**](docs/StorefrontApi.md#get_email_email_customer_editor_url) | **GET** /storefront/{storefront_oid}/email/emails/{commseq_email_uuid}/orders/{order_id}/editor_url | Get email order customer editor url
*StorefrontApi* | [**get_email_email_orders**](docs/StorefrontApi.md#get_email_email_orders) | **GET** /storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/steps/{commseq_step_uuid}/emails/{commseq_email_uuid}/orders | Get email email orders
*StorefrontApi* | [**get_email_emails**](docs/StorefrontApi.md#get_email_emails) | **GET** /storefront/{storefront_oid}/email/emails | Get email emails
*StorefrontApi* | [**get_email_emails_multiple**](docs/StorefrontApi.md#get_email_emails_multiple) | **POST** /storefront/{storefront_oid}/email/emails/multiple | Get email emails multiple
*StorefrontApi* | [**get_email_flow**](docs/StorefrontApi.md#get_email_flow) | **GET** /storefront/{storefront_oid}/email/flows/{email_flow_uuid} | Get email flow
*StorefrontApi* | [**get_email_flow_folder**](docs/StorefrontApi.md#get_email_flow_folder) | **GET** /storefront/{storefront_oid}/email/flow_folders/{email_flow_folder_uuid} | Get email flow folder
*StorefrontApi* | [**get_email_flow_folders**](docs/StorefrontApi.md#get_email_flow_folders) | **GET** /storefront/{storefront_oid}/email/flow_folders | Get email flow folders
*StorefrontApi* | [**get_email_flow_screenshots**](docs/StorefrontApi.md#get_email_flow_screenshots) | **GET** /storefront/{storefront_oid}/email/flows/{email_flow_uuid}/screenshots | Get email flow screenshots
*StorefrontApi* | [**get_email_flows**](docs/StorefrontApi.md#get_email_flows) | **GET** /storefront/{storefront_oid}/email/flows | Get email flows
*StorefrontApi* | [**get_email_global_settings**](docs/StorefrontApi.md#get_email_global_settings) | **GET** /storefront/email/global_settings | Get email globalsettings
*StorefrontApi* | [**get_email_list**](docs/StorefrontApi.md#get_email_list) | **GET** /storefront/{storefront_oid}/email/lists/{email_list_uuid} | Get email list
*StorefrontApi* | [**get_email_list_customer_editor_url**](docs/StorefrontApi.md#get_email_list_customer_editor_url) | **GET** /storefront/{storefront_oid}/email/lists/{email_list_uuid}/customers/{email_customer_uuid}/editor_url | Get email list customer editor url
*StorefrontApi* | [**get_email_list_customers**](docs/StorefrontApi.md#get_email_list_customers) | **GET** /storefront/{storefront_oid}/email/lists/{email_list_uuid}/customers | Get email list customers
*StorefrontApi* | [**get_email_list_segment_folder**](docs/StorefrontApi.md#get_email_list_segment_folder) | **GET** /storefront/{storefront_oid}/email/list_segment_folders/{email_list_segment_folder_uuid} | Get email campaign folder
*StorefrontApi* | [**get_email_list_segment_folders**](docs/StorefrontApi.md#get_email_list_segment_folders) | **GET** /storefront/{storefront_oid}/email/list_segment_folders | Get email campaign folders
*StorefrontApi* | [**get_email_lists**](docs/StorefrontApi.md#get_email_lists) | **GET** /storefront/{storefront_oid}/email/lists | Get email lists
*StorefrontApi* | [**get_email_performance**](docs/StorefrontApi.md#get_email_performance) | **GET** /storefront/{storefront_oid}/email/performance | Get email performance
*StorefrontApi* | [**get_email_plan**](docs/StorefrontApi.md#get_email_plan) | **GET** /storefront/{storefront_oid}/email/plan | Get email plan
*StorefrontApi* | [**get_email_postcard**](docs/StorefrontApi.md#get_email_postcard) | **GET** /storefront/{storefront_oid}/email/postcards/{commseq_postcard_uuid} | Get email postcard
*StorefrontApi* | [**get_email_postcards**](docs/StorefrontApi.md#get_email_postcards) | **GET** /storefront/{storefront_oid}/email/postcards | Get email postcards
*StorefrontApi* | [**get_email_postcards_multiple**](docs/StorefrontApi.md#get_email_postcards_multiple) | **POST** /storefront/{storefront_oid}/email/postcards/multiple | Get email postcards multiple
*StorefrontApi* | [**get_email_segment**](docs/StorefrontApi.md#get_email_segment) | **GET** /storefront/{storefront_oid}/email/segments/{email_segment_uuid} | Get email segment
*StorefrontApi* | [**get_email_segment_customer_editor_url**](docs/StorefrontApi.md#get_email_segment_customer_editor_url) | **GET** /storefront/{storefront_oid}/email/segments/{email_segment_uuid}/customers/{email_customer_uuid}/editor_url | Get email segment customers editor URL
*StorefrontApi* | [**get_email_segment_customers**](docs/StorefrontApi.md#get_email_segment_customers) | **GET** /storefront/{storefront_oid}/email/segments/{email_segment_uuid}/customers | Get email segment customers
*StorefrontApi* | [**get_email_segments**](docs/StorefrontApi.md#get_email_segments) | **GET** /storefront/{storefront_oid}/email/segments | Get email segments
*StorefrontApi* | [**get_email_sending_domain**](docs/StorefrontApi.md#get_email_sending_domain) | **GET** /storefront/email/sending_domain/{domain} | Get email sending domain
*StorefrontApi* | [**get_email_sending_domain_status**](docs/StorefrontApi.md#get_email_sending_domain_status) | **POST** /storefront/email/sending_domains/{domain}/status | Get email sending domain status
*StorefrontApi* | [**get_email_sending_domains**](docs/StorefrontApi.md#get_email_sending_domains) | **GET** /storefront/email/sending_domains | Get email sending domains
*StorefrontApi* | [**get_email_settings**](docs/StorefrontApi.md#get_email_settings) | **GET** /storefront/{storefront_oid}/email/settings | Get email settings
*StorefrontApi* | [**get_email_template**](docs/StorefrontApi.md#get_email_template) | **GET** /storefront/{storefront_oid}/email/templates/{email_template_oid} | Get email template
*StorefrontApi* | [**get_email_templates**](docs/StorefrontApi.md#get_email_templates) | **GET** /storefront/{storefront_oid}/email/templates | Get email templates
*StorefrontApi* | [**get_email_third_party_providers**](docs/StorefrontApi.md#get_email_third_party_providers) | **GET** /storefront/{storefront_oid}/email/third_party_providers | Get a list of third party email providers
*StorefrontApi* | [**get_experiments**](docs/StorefrontApi.md#get_experiments) | **GET** /storefront/{storefront_oid}/experiments | Get experiments
*StorefrontApi* | [**get_heatmap**](docs/StorefrontApi.md#get_heatmap) | **POST** /storefront/{storefront_oid}/screen_recordings/heatmap | Get screen recording heatmap
*StorefrontApi* | [**get_heatmap_index**](docs/StorefrontApi.md#get_heatmap_index) | **POST** /storefront/{storefront_oid}/screen_recordings/heatmap/index | Get screen recording heatmap index
*StorefrontApi* | [**get_histogram_property_names**](docs/StorefrontApi.md#get_histogram_property_names) | **GET** /storefront/{storefront_oid}/email/histogram/property_names | Get histogram property names
*StorefrontApi* | [**get_histogram_property_values**](docs/StorefrontApi.md#get_histogram_property_values) | **GET** /storefront/{storefront_oid}/email/histogram/property_values | Get histogram property values
*StorefrontApi* | [**get_library_filter_values**](docs/StorefrontApi.md#get_library_filter_values) | **GET** /storefront/code_library/filter_values | Get library values used to populate drop down boxes for filtering.
*StorefrontApi* | [**get_library_item**](docs/StorefrontApi.md#get_library_item) | **GET** /storefront/code_library/{library_item_oid} | Get library item.
*StorefrontApi* | [**get_library_item_published_versions**](docs/StorefrontApi.md#get_library_item_published_versions) | **GET** /storefront/code_library/{library_item_oid}/published_versions | Get all published versions for a library item.
*StorefrontApi* | [**get_screen_recording**](docs/StorefrontApi.md#get_screen_recording) | **GET** /storefront/{storefront_oid}/screen_recordings/{screen_recording_uuid} | Get screen recording
*StorefrontApi* | [**get_screen_recording_page_view_data**](docs/StorefrontApi.md#get_screen_recording_page_view_data) | **GET** /storefront/{storefront_oid}/screen_recordings/{screen_recording_uuid}/page_view_data/{screen_recording_page_view_uuid} | Get screen recording page view data
*StorefrontApi* | [**get_screen_recording_segment**](docs/StorefrontApi.md#get_screen_recording_segment) | **GET** /storefront/{storefront_oid}/screen_recordings/segments/{screen_recording_segment_oid} | Get screen recording segment
*StorefrontApi* | [**get_screen_recording_segments**](docs/StorefrontApi.md#get_screen_recording_segments) | **GET** /storefront/{storefront_oid}/screen_recordings/segments | Get screen recording segments
*StorefrontApi* | [**get_screen_recording_settings**](docs/StorefrontApi.md#get_screen_recording_settings) | **GET** /storefront/{storefront_oid}/screen_recordings/settings | Get screen recording settings
*StorefrontApi* | [**get_screen_recording_tags**](docs/StorefrontApi.md#get_screen_recording_tags) | **POST** /storefront/{storefront_oid}/screen_recordings/tags | Get tags used by screen recording
*StorefrontApi* | [**get_screen_recordings_by_query**](docs/StorefrontApi.md#get_screen_recordings_by_query) | **POST** /storefront/{storefront_oid}/screen_recordings/query | Query screen recordings
*StorefrontApi* | [**get_screen_recordings_by_segment**](docs/StorefrontApi.md#get_screen_recordings_by_segment) | **POST** /storefront/{storefront_oid}/screen_recordings/segments/{screen_recording_segment_oid}/query | Get screen recordings by segment
*StorefrontApi* | [**get_store_front_pricing_tiers**](docs/StorefrontApi.md#get_store_front_pricing_tiers) | **GET** /storefront/pricing_tiers | Retrieve pricing tiers
*StorefrontApi* | [**get_thumbnail_parameters**](docs/StorefrontApi.md#get_thumbnail_parameters) | **POST** /storefront/thumbnailParameters | Get thumbnail parameters
*StorefrontApi* | [**get_transaction_email**](docs/StorefrontApi.md#get_transaction_email) | **GET** /storefront/{storefront_oid}/transaction_email/list/{email_id} | Gets a transaction email object
*StorefrontApi* | [**get_transaction_email_list**](docs/StorefrontApi.md#get_transaction_email_list) | **GET** /storefront/{storefront_oid}/transaction_email/list | Gets a list of transaction email names
*StorefrontApi* | [**get_transaction_email_screenshots**](docs/StorefrontApi.md#get_transaction_email_screenshots) | **GET** /storefront/{storefront_oid}/transaction_email/list/{email_id}/screenshots | Get transactional email screenshots
*StorefrontApi* | [**get_twilio_account**](docs/StorefrontApi.md#get_twilio_account) | **GET** /storefront/twilio/accounts/{esp_twilio_uuid} | Get Twilio account
*StorefrontApi* | [**get_twilio_accounts**](docs/StorefrontApi.md#get_twilio_accounts) | **GET** /storefront/twilio/accounts | Get all Twilio accounts
*StorefrontApi* | [**global_unsubscribe**](docs/StorefrontApi.md#global_unsubscribe) | **POST** /storefront/{storefront_oid}/email/globalUnsubscribe | Globally unsubscribe a customer
*StorefrontApi* | [**import_email_third_party_provider_list**](docs/StorefrontApi.md#import_email_third_party_provider_list) | **POST** /storefront/{storefront_oid}/email/third_party_providers/import | Import a third party provider list
*StorefrontApi* | [**insert_email_campaign**](docs/StorefrontApi.md#insert_email_campaign) | **POST** /storefront/{storefront_oid}/email/campaigns | Insert email campaign
*StorefrontApi* | [**insert_email_campaign_folder**](docs/StorefrontApi.md#insert_email_campaign_folder) | **POST** /storefront/{storefront_oid}/email/campaign_folders | Insert email campaign folder
*StorefrontApi* | [**insert_email_commseq**](docs/StorefrontApi.md#insert_email_commseq) | **POST** /storefront/{storefront_oid}/email/commseqs | Insert email commseq
*StorefrontApi* | [**insert_email_email**](docs/StorefrontApi.md#insert_email_email) | **POST** /storefront/{storefront_oid}/email/emails | Insert email email
*StorefrontApi* | [**insert_email_flow**](docs/StorefrontApi.md#insert_email_flow) | **POST** /storefront/{storefront_oid}/email/flows | Insert email flow
*StorefrontApi* | [**insert_email_flow_folder**](docs/StorefrontApi.md#insert_email_flow_folder) | **POST** /storefront/{storefront_oid}/email/flow_folders | Insert email flow folder
*StorefrontApi* | [**insert_email_list**](docs/StorefrontApi.md#insert_email_list) | **POST** /storefront/{storefront_oid}/email/lists | Insert email list
*StorefrontApi* | [**insert_email_list_segment_folder**](docs/StorefrontApi.md#insert_email_list_segment_folder) | **POST** /storefront/{storefront_oid}/email/list_segment_folders | Insert email campaign folder
*StorefrontApi* | [**insert_email_postcard**](docs/StorefrontApi.md#insert_email_postcard) | **POST** /storefront/{storefront_oid}/email/postcards | Insert email postcard
*StorefrontApi* | [**insert_email_segment**](docs/StorefrontApi.md#insert_email_segment) | **POST** /storefront/{storefront_oid}/email/segments | Insert email segment
*StorefrontApi* | [**insert_screen_recording_segment**](docs/StorefrontApi.md#insert_screen_recording_segment) | **POST** /storefront/{storefront_oid}/screen_recordings/segments | Insert screen recording segment
*StorefrontApi* | [**prepare_download_email_segment**](docs/StorefrontApi.md#prepare_download_email_segment) | **POST** /storefront/{storefront_oid}/email/segments/{email_segment_uuid}/downloadPrepare | Prepare download of email segment
*StorefrontApi* | [**publish_library_item**](docs/StorefrontApi.md#publish_library_item) | **POST** /storefront/code_library/{library_item_oid}/publish | Publish library item.
*StorefrontApi* | [**purchase_library_item**](docs/StorefrontApi.md#purchase_library_item) | **POST** /storefront/code_library/{library_item_oid}/purchase | Purchase public library item, which creates a copy of the item in your personal code library
*StorefrontApi* | [**release_email_commseq_step_waiting**](docs/StorefrontApi.md#release_email_commseq_step_waiting) | **POST** /storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/waiting/{commseq_step_uuid} | Release email communication sequence customers waiting at the specified step
*StorefrontApi* | [**review**](docs/StorefrontApi.md#review) | **POST** /storefront/{storefront_oid}/email/emails/{commseq_email_uuid}/review | Request a review of an email
*StorefrontApi* | [**search**](docs/StorefrontApi.md#search) | **GET** /storefront/search | Searches for all matching values
*StorefrontApi* | [**search2**](docs/StorefrontApi.md#search2) | **POST** /storefront/search | Searches for all matching values (using POST)
*StorefrontApi* | [**search_email_list_customers**](docs/StorefrontApi.md#search_email_list_customers) | **GET** /storefront/{storefront_oid}/email/lists/{email_list_uuid}/search | Search email list customers
*StorefrontApi* | [**search_email_segment_customers**](docs/StorefrontApi.md#search_email_segment_customers) | **GET** /storefront/{storefront_oid}/email/segments/{email_segment_uuid}/search | Search email segment customers
*StorefrontApi* | [**search_library_items**](docs/StorefrontApi.md#search_library_items) | **POST** /storefront/code_library/search | Retrieve library items
*StorefrontApi* | [**search_published_items**](docs/StorefrontApi.md#search_published_items) | **POST** /storefront/code_library/search_published | Retrieve library items
*StorefrontApi* | [**search_review_items**](docs/StorefrontApi.md#search_review_items) | **POST** /storefront/code_library/search_review | Retrieve library items needing review or rejected
*StorefrontApi* | [**search_shared_items**](docs/StorefrontApi.md#search_shared_items) | **POST** /storefront/code_library/search_shared | Retrieve library items
*StorefrontApi* | [**send_email_test**](docs/StorefrontApi.md#send_email_test) | **POST** /storefront/{storefront_oid}/email/emails/{commseq_email_uuid}/test | Send email test
*StorefrontApi* | [**send_postcard_test**](docs/StorefrontApi.md#send_postcard_test) | **POST** /storefront/{storefront_oid}/email/postcards/{commseq_postcard_uuid}/test | Send postcard test
*StorefrontApi* | [**send_webhook_test**](docs/StorefrontApi.md#send_webhook_test) | **POST** /storefront/{storefront_oid}/email/webhooks/test | Send webhook test
*StorefrontApi* | [**start_email_campaign**](docs/StorefrontApi.md#start_email_campaign) | **PUT** /storefront/{storefront_oid}/email/campaigns/{email_campaign_uuid}/start | Start email campaign
*StorefrontApi* | [**subscribe_to_email_list**](docs/StorefrontApi.md#subscribe_to_email_list) | **POST** /storefront/{storefront_oid}/email/lists/{email_list_uuid}/subscribe | Subscribe customers to email list
*StorefrontApi* | [**unfavorite_screen_recording**](docs/StorefrontApi.md#unfavorite_screen_recording) | **DELETE** /storefront/{storefront_oid}/screen_recordings/{screen_recording_uuid}/favorite | Remove favorite flag on screen recording
*StorefrontApi* | [**update_email_campaign**](docs/StorefrontApi.md#update_email_campaign) | **PUT** /storefront/{storefront_oid}/email/campaigns/{email_campaign_uuid} | Update email campaign
*StorefrontApi* | [**update_email_campaign_folder**](docs/StorefrontApi.md#update_email_campaign_folder) | **PUT** /storefront/{storefront_oid}/email/campaign_folders/{email_campaign_folder_uuid} | Update email campaign folder
*StorefrontApi* | [**update_email_commseq**](docs/StorefrontApi.md#update_email_commseq) | **PUT** /storefront/{storefront_oid}/email/commseqs/{commseq_uuid} | Update email commseq
*StorefrontApi* | [**update_email_customer**](docs/StorefrontApi.md#update_email_customer) | **PUT** /storefront/{storefront_oid}/email/customers/{email_customer_uuid} | Update email customer
*StorefrontApi* | [**update_email_email**](docs/StorefrontApi.md#update_email_email) | **PUT** /storefront/{storefront_oid}/email/emails/{commseq_email_uuid} | Update email email
*StorefrontApi* | [**update_email_flow**](docs/StorefrontApi.md#update_email_flow) | **PUT** /storefront/{storefront_oid}/email/flows/{email_flow_uuid} | Update email flow
*StorefrontApi* | [**update_email_flow_folder**](docs/StorefrontApi.md#update_email_flow_folder) | **PUT** /storefront/{storefront_oid}/email/flow_folders/{email_flow_folder_uuid} | Update email flow folder
*StorefrontApi* | [**update_email_global_settings**](docs/StorefrontApi.md#update_email_global_settings) | **POST** /storefront/email/global_settings | Update email global settings
*StorefrontApi* | [**update_email_list**](docs/StorefrontApi.md#update_email_list) | **PUT** /storefront/{storefront_oid}/email/lists/{email_list_uuid} | Update email list
*StorefrontApi* | [**update_email_list_segment_folder**](docs/StorefrontApi.md#update_email_list_segment_folder) | **PUT** /storefront/{storefront_oid}/email/list_segment_folders/{email_list_segment_folder_uuid} | Update email campaign folder
*StorefrontApi* | [**update_email_plan**](docs/StorefrontApi.md#update_email_plan) | **POST** /storefront/{storefront_oid}/email/plan | Update email plan
*StorefrontApi* | [**update_email_postcard**](docs/StorefrontApi.md#update_email_postcard) | **PUT** /storefront/{storefront_oid}/email/postcards/{commseq_postcard_uuid} | Update email postcard
*StorefrontApi* | [**update_email_segment**](docs/StorefrontApi.md#update_email_segment) | **PUT** /storefront/{storefront_oid}/email/segments/{email_segment_uuid} | Update email segment
*StorefrontApi* | [**update_email_sending_domain**](docs/StorefrontApi.md#update_email_sending_domain) | **PUT** /storefront/email/sending_domains/{domain} | Update email sending domain
*StorefrontApi* | [**update_email_settings**](docs/StorefrontApi.md#update_email_settings) | **POST** /storefront/{storefront_oid}/email/settings | Update email settings
*StorefrontApi* | [**update_experiment**](docs/StorefrontApi.md#update_experiment) | **PUT** /storefront/{storefront_oid}/experiments/{storefront_experiment_oid} | Update experiment
*StorefrontApi* | [**update_library_item**](docs/StorefrontApi.md#update_library_item) | **PUT** /storefront/code_library/{library_item_oid} | Update library item. Note that only certain fields may be updated via this method.
*StorefrontApi* | [**update_screen_recording_merchant_notes**](docs/StorefrontApi.md#update_screen_recording_merchant_notes) | **POST** /storefront/{storefront_oid}/screen_recordings/{screen_recording_uuid}/merchant_notes | Update merchant notes on a screen recording
*StorefrontApi* | [**update_screen_recording_segment**](docs/StorefrontApi.md#update_screen_recording_segment) | **POST** /storefront/{storefront_oid}/screen_recordings/segments/{screen_recording_segment_oid} | Update screen recording segment
*StorefrontApi* | [**update_screen_recording_settings**](docs/StorefrontApi.md#update_screen_recording_settings) | **POST** /storefront/{storefront_oid}/screen_recordings/settings | Update screen recording settings
*StorefrontApi* | [**update_screen_recording_tags**](docs/StorefrontApi.md#update_screen_recording_tags) | **POST** /storefront/{storefront_oid}/screen_recordings/{screen_recording_uuid}/tags | Update tags on a screen recording
*StorefrontApi* | [**update_transaction_email**](docs/StorefrontApi.md#update_transaction_email) | **PUT** /storefront/{storefront_oid}/transaction_email/list/{email_id} | Updates a transaction email object
*StorefrontApi* | [**update_twilio_account**](docs/StorefrontApi.md#update_twilio_account) | **PUT** /storefront/twilio/accounts/{esp_twilio_uuid} | Update Twilio account
*TaxApi* | [**delete_tax_provider_self_city**](docs/TaxApi.md#delete_tax_provider_self_city) | **DELETE** /tax/providers/self/city/{city} | Deletes a Self tax provider city
*TaxApi* | [**delete_tax_provider_self_country**](docs/TaxApi.md#delete_tax_provider_self_country) | **DELETE** /tax/providers/self/country/{countryCode} | Deletes a Self tax provider country
*TaxApi* | [**delete_tax_provider_self_county**](docs/TaxApi.md#delete_tax_provider_self_county) | **DELETE** /tax/providers/self/county/{county} | Deletes a Self tax provider county
*TaxApi* | [**delete_tax_provider_self_postal_code**](docs/TaxApi.md#delete_tax_provider_self_postal_code) | **DELETE** /tax/providers/self/postalCode/{postal_code} | Deletes a Self tax provider postalCode
*TaxApi* | [**delete_tax_provider_self_state**](docs/TaxApi.md#delete_tax_provider_self_state) | **DELETE** /tax/providers/self/state/{stateCode} | Deletes a Self tax provider state
*TaxApi* | [**get_tax_provider_avalara**](docs/TaxApi.md#get_tax_provider_avalara) | **GET** /tax/providers/avalara | Retrieve the Avalara tax provider
*TaxApi* | [**get_tax_provider_avalara_companies**](docs/TaxApi.md#get_tax_provider_avalara_companies) | **POST** /tax/providers/avalara/companies | Returns Avalara Tax companies configured by the merchant
*TaxApi* | [**get_tax_provider_avalara_test**](docs/TaxApi.md#get_tax_provider_avalara_test) | **GET** /tax/providers/avalara/test | Attempts to connect to Avalara and returns back the response
*TaxApi* | [**get_tax_provider_self**](docs/TaxApi.md#get_tax_provider_self) | **GET** /tax/providers/self | Retrieve the Self tax provider
*TaxApi* | [**get_tax_provider_self_countries**](docs/TaxApi.md#get_tax_provider_self_countries) | **GET** /tax/providers/self/countries | Retrieve the Self tax provider countries
*TaxApi* | [**get_tax_provider_self_regions_by_country_code**](docs/TaxApi.md#get_tax_provider_self_regions_by_country_code) | **GET** /tax/providers/self/regions/{countryCode} | Retrieve the Self tax provider regions for a given country code
*TaxApi* | [**get_tax_provider_sovos**](docs/TaxApi.md#get_tax_provider_sovos) | **GET** /tax/providers/sovos | Retrieve the Sovos tax provider
*TaxApi* | [**get_tax_provider_sovos_test**](docs/TaxApi.md#get_tax_provider_sovos_test) | **GET** /tax/providers/sovos/test | Attempts to connect to Sovos and returns back the response
*TaxApi* | [**get_tax_provider_tax_jar**](docs/TaxApi.md#get_tax_provider_tax_jar) | **GET** /tax/providers/taxjar | Retrieve the TaxJar tax provider
*TaxApi* | [**get_tax_provider_tax_jar_test**](docs/TaxApi.md#get_tax_provider_tax_jar_test) | **GET** /tax/providers/taxjar/test | Attempts to connect to TaxJar and returns back the response
*TaxApi* | [**get_tax_provider_ultra_cart**](docs/TaxApi.md#get_tax_provider_ultra_cart) | **GET** /tax/providers/ultracart | Retrieve the UltraCart tax provider
*TaxApi* | [**get_tax_providers**](docs/TaxApi.md#get_tax_providers) | **GET** /tax/providers | Retrieve tax methods
*TaxApi* | [**set_active_tax_provider**](docs/TaxApi.md#set_active_tax_provider) | **POST** /tax/providers/setActive/{providerName} | Toggle a tax provider to active
*TaxApi* | [**update_tax_provider_avalara**](docs/TaxApi.md#update_tax_provider_avalara) | **POST** /tax/providers/avalara | Update the Avalara tax provider
*TaxApi* | [**update_tax_provider_self**](docs/TaxApi.md#update_tax_provider_self) | **POST** /tax/providers/self | Update the Self tax provider
*TaxApi* | [**update_tax_provider_self_city**](docs/TaxApi.md#update_tax_provider_self_city) | **POST** /tax/providers/self/city/{city} | Updates a Self tax provider city
*TaxApi* | [**update_tax_provider_self_country**](docs/TaxApi.md#update_tax_provider_self_country) | **POST** /tax/providers/self/country/{countryCode} | Updates a Self tax provider country
*TaxApi* | [**update_tax_provider_self_county**](docs/TaxApi.md#update_tax_provider_self_county) | **POST** /tax/providers/self/county/{county} | Updates a Self tax provider county
*TaxApi* | [**update_tax_provider_self_postal_code**](docs/TaxApi.md#update_tax_provider_self_postal_code) | **POST** /tax/providers/self/postalCode/{postal_code} | Updates a Self tax provider postalCode
*TaxApi* | [**update_tax_provider_self_state**](docs/TaxApi.md#update_tax_provider_self_state) | **POST** /tax/providers/self/state/{stateCode} | Updates a Self tax provider state
*TaxApi* | [**update_tax_provider_sovos**](docs/TaxApi.md#update_tax_provider_sovos) | **POST** /tax/providers/sovos | Update the Sovos tax provider
*TaxApi* | [**update_tax_provider_tax_jar**](docs/TaxApi.md#update_tax_provider_tax_jar) | **POST** /tax/providers/taxjar | Update the TaxJar tax provider
*TaxApi* | [**update_tax_provider_ultra_cart**](docs/TaxApi.md#update_tax_provider_ultra_cart) | **POST** /tax/providers/ultracart | Update the UltraCart tax provider
*UserApi* | [**delete_group**](docs/UserApi.md#delete_group) | **DELETE** /user/groups/{group_oid} | Delete a group
*UserApi* | [**delete_user**](docs/UserApi.md#delete_user) | **DELETE** /user/users/{user_id} | Delete a user
*UserApi* | [**get_group**](docs/UserApi.md#get_group) | **GET** /user/groups/{group_oid} | Retrieve a group
*UserApi* | [**get_groups**](docs/UserApi.md#get_groups) | **GET** /user/groups | Get groups
*UserApi* | [**get_user**](docs/UserApi.md#get_user) | **GET** /user/users/{user_id} | Retrieve a user
*UserApi* | [**get_user_logins**](docs/UserApi.md#get_user_logins) | **GET** /user/users/{user_id}/logins | Retrieve a user&#39;s login history
*UserApi* | [**get_users**](docs/UserApi.md#get_users) | **GET** /user/users | Get users
*UserApi* | [**insert_group**](docs/UserApi.md#insert_group) | **POST** /user/groups | Insert a group
*UserApi* | [**insert_user**](docs/UserApi.md#insert_user) | **POST** /user/users | Insert a user
*UserApi* | [**update_group**](docs/UserApi.md#update_group) | **PUT** /user/groups/{group_oid} | Update a group
*UserApi* | [**update_user**](docs/UserApi.md#update_user) | **PUT** /user/users/{user_id} | Update a user
*WebhookApi* | [**delete_webhook**](docs/WebhookApi.md#delete_webhook) | **DELETE** /webhook/webhooks/{webhookOid} | Delete a webhook
*WebhookApi* | [**delete_webhook_by_url**](docs/WebhookApi.md#delete_webhook_by_url) | **DELETE** /webhook/webhooks | Delete a webhook by URL
*WebhookApi* | [**get_webhook_log**](docs/WebhookApi.md#get_webhook_log) | **GET** /webhook/webhooks/{webhookOid}/logs/{requestId} | Retrieve an individual log
*WebhookApi* | [**get_webhook_log_summaries**](docs/WebhookApi.md#get_webhook_log_summaries) | **GET** /webhook/webhooks/{webhookOid}/logs | Retrieve the log summaries
*WebhookApi* | [**get_webhooks**](docs/WebhookApi.md#get_webhooks) | **GET** /webhook/webhooks | Retrieve webhooks
*WebhookApi* | [**insert_webhook**](docs/WebhookApi.md#insert_webhook) | **POST** /webhook/webhooks | Add a webhook
*WebhookApi* | [**resend_event**](docs/WebhookApi.md#resend_event) | **POST** /webhook/webhooks/{webhookOid}/reflow/{eventName} | Resend events to the webhook endpoint.
*WebhookApi* | [**update_webhook**](docs/WebhookApi.md#update_webhook) | **PUT** /webhook/webhooks/{webhookOid} | Update a webhook


## Documentation For Models

 - [AccountsReceivableRetryConfig](docs/AccountsReceivableRetryConfig.md)
 - [AccountsReceivableRetryConfigResponse](docs/AccountsReceivableRetryConfigResponse.md)
 - [AccountsReceivableRetryDayActivity](docs/AccountsReceivableRetryDayActivity.md)
 - [AccountsReceivableRetryStatAccount](docs/AccountsReceivableRetryStatAccount.md)
 - [AccountsReceivableRetryStatMetrics](docs/AccountsReceivableRetryStatMetrics.md)
 - [AccountsReceivableRetryStatRevenue](docs/AccountsReceivableRetryStatRevenue.md)
 - [AccountsReceivableRetryStatsResponse](docs/AccountsReceivableRetryStatsResponse.md)
 - [Activity](docs/Activity.md)
 - [AddLibraryItemRequest](docs/AddLibraryItemRequest.md)
 - [AdjustInternalCertificateRequest](docs/AdjustInternalCertificateRequest.md)
 - [AdjustInternalCertificateResponse](docs/AdjustInternalCertificateResponse.md)
 - [AffiliateClick](docs/AffiliateClick.md)
 - [AffiliateClickQuery](docs/AffiliateClickQuery.md)
 - [AffiliateClicksResponse](docs/AffiliateClicksResponse.md)
 - [AffiliateLedger](docs/AffiliateLedger.md)
 - [AffiliateLedgerQuery](docs/AffiliateLedgerQuery.md)
 - [AffiliateLedgersResponse](docs/AffiliateLedgersResponse.md)
 - [AffiliateLink](docs/AffiliateLink.md)
 - [ApiUserApplicationProfile](docs/ApiUserApplicationProfile.md)
 - [ApplyLibraryItemRequest](docs/ApplyLibraryItemRequest.md)
 - [ApplyLibraryItemResponse](docs/ApplyLibraryItemResponse.md)
 - [AutoOrder](docs/AutoOrder.md)
 - [AutoOrderItem](docs/AutoOrderItem.md)
 - [AutoOrderItemFutureSchedule](docs/AutoOrderItemFutureSchedule.md)
 - [AutoOrderItemOption](docs/AutoOrderItemOption.md)
 - [AutoOrderItemSimpleSchedule](docs/AutoOrderItemSimpleSchedule.md)
 - [AutoOrderLog](docs/AutoOrderLog.md)
 - [AutoOrderManagement](docs/AutoOrderManagement.md)
 - [AutoOrderQuery](docs/AutoOrderQuery.md)
 - [AutoOrderQueryBatch](docs/AutoOrderQueryBatch.md)
 - [AutoOrderResponse](docs/AutoOrderResponse.md)
 - [AutoOrdersRequest](docs/AutoOrdersRequest.md)
 - [AutoOrdersResponse](docs/AutoOrdersResponse.md)
 - [AvalaraConfig](docs/AvalaraConfig.md)
 - [BaseResponse](docs/BaseResponse.md)
 - [Browser](docs/Browser.md)
 - [BrowserDevice](docs/BrowserDevice.md)
 - [BrowserOS](docs/BrowserOS.md)
 - [BrowserUserAgent](docs/BrowserUserAgent.md)
 - [Cart](docs/Cart.md)
 - [CartAffiliate](docs/CartAffiliate.md)
 - [CartAffirmCheckoutResponse](docs/CartAffirmCheckoutResponse.md)
 - [CartBilling](docs/CartBilling.md)
 - [CartBuysafe](docs/CartBuysafe.md)
 - [CartCheckout](docs/CartCheckout.md)
 - [CartCoupon](docs/CartCoupon.md)
 - [CartCurrencyConversion](docs/CartCurrencyConversion.md)
 - [CartCustomerProfile](docs/CartCustomerProfile.md)
 - [CartCustomerProfileAddress](docs/CartCustomerProfileAddress.md)
 - [CartCustomerProfileCreditCard](docs/CartCustomerProfileCreditCard.md)
 - [CartFinalizeOrderRequest](docs/CartFinalizeOrderRequest.md)
 - [CartFinalizeOrderRequestOptions](docs/CartFinalizeOrderRequestOptions.md)
 - [CartFinalizeOrderResponse](docs/CartFinalizeOrderResponse.md)
 - [CartGift](docs/CartGift.md)
 - [CartGiftCertificate](docs/CartGiftCertificate.md)
 - [CartItem](docs/CartItem.md)
 - [CartItemAttribute](docs/CartItemAttribute.md)
 - [CartItemMultimedia](docs/CartItemMultimedia.md)
 - [CartItemMultimediaThumbnail](docs/CartItemMultimediaThumbnail.md)
 - [CartItemOption](docs/CartItemOption.md)
 - [CartItemOptionValue](docs/CartItemOptionValue.md)
 - [CartItemPhysical](docs/CartItemPhysical.md)
 - [CartItemVariationSelection](docs/CartItemVariationSelection.md)
 - [CartKitComponentOption](docs/CartKitComponentOption.md)
 - [CartMarketing](docs/CartMarketing.md)
 - [CartPayment](docs/CartPayment.md)
 - [CartPaymentAffirm](docs/CartPaymentAffirm.md)
 - [CartPaymentAmazon](docs/CartPaymentAmazon.md)
 - [CartPaymentCheck](docs/CartPaymentCheck.md)
 - [CartPaymentCreditCard](docs/CartPaymentCreditCard.md)
 - [CartPaymentPurchaseOrder](docs/CartPaymentPurchaseOrder.md)
 - [CartProfileLoginRequest](docs/CartProfileLoginRequest.md)
 - [CartProfileLoginResponse](docs/CartProfileLoginResponse.md)
 - [CartProfileRegisterRequest](docs/CartProfileRegisterRequest.md)
 - [CartProfileRegisterResponse](docs/CartProfileRegisterResponse.md)
 - [CartProperty](docs/CartProperty.md)
 - [CartResponse](docs/CartResponse.md)
 - [CartSettings](docs/CartSettings.md)
 - [CartSettingsBilling](docs/CartSettingsBilling.md)
 - [CartSettingsGift](docs/CartSettingsGift.md)
 - [CartSettingsGiftWrap](docs/CartSettingsGiftWrap.md)
 - [CartSettingsPayment](docs/CartSettingsPayment.md)
 - [CartSettingsPaymentAmazon](docs/CartSettingsPaymentAmazon.md)
 - [CartSettingsPaymentCreditCard](docs/CartSettingsPaymentCreditCard.md)
 - [CartSettingsPaymentPayPal](docs/CartSettingsPaymentPayPal.md)
 - [CartSettingsProvince](docs/CartSettingsProvince.md)
 - [CartSettingsShipping](docs/CartSettingsShipping.md)
 - [CartSettingsShippingCalendar](docs/CartSettingsShippingCalendar.md)
 - [CartSettingsShippingEstimate](docs/CartSettingsShippingEstimate.md)
 - [CartSettingsTaxes](docs/CartSettingsTaxes.md)
 - [CartSettingsTerms](docs/CartSettingsTerms.md)
 - [CartShipping](docs/CartShipping.md)
 - [CartSummary](docs/CartSummary.md)
 - [CartTaxes](docs/CartTaxes.md)
 - [CartUpsellAfter](docs/CartUpsellAfter.md)
 - [CartValidationRequest](docs/CartValidationRequest.md)
 - [CartValidationResponse](docs/CartValidationResponse.md)
 - [ChannelPartnerCancelResponse](docs/ChannelPartnerCancelResponse.md)
 - [ChannelPartnerEstimateShippingResponse](docs/ChannelPartnerEstimateShippingResponse.md)
 - [ChannelPartnerEstimateTaxResponse](docs/ChannelPartnerEstimateTaxResponse.md)
 - [ChannelPartnerImportResponse](docs/ChannelPartnerImportResponse.md)
 - [ChannelPartnerOrder](docs/ChannelPartnerOrder.md)
 - [ChannelPartnerOrderItem](docs/ChannelPartnerOrderItem.md)
 - [ChannelPartnerOrderItemOption](docs/ChannelPartnerOrderItemOption.md)
 - [ChannelPartnerOrderTransaction](docs/ChannelPartnerOrderTransaction.md)
 - [ChannelPartnerOrderTransactionDetail](docs/ChannelPartnerOrderTransactionDetail.md)
 - [ChannelPartnerShippingEstimate](docs/ChannelPartnerShippingEstimate.md)
 - [ChargebackDispute](docs/ChargebackDispute.md)
 - [ChargebackDisputeResponse](docs/ChargebackDisputeResponse.md)
 - [ChargebackDisputesResponse](docs/ChargebackDisputesResponse.md)
 - [CheckoutAllowedCountriesResponse](docs/CheckoutAllowedCountriesResponse.md)
 - [CheckoutHandoffRequest](docs/CheckoutHandoffRequest.md)
 - [CheckoutHandoffResponse](docs/CheckoutHandoffResponse.md)
 - [CheckoutSetupBrowserKeyRequest](docs/CheckoutSetupBrowserKeyRequest.md)
 - [CheckoutSetupBrowserKeyResponse](docs/CheckoutSetupBrowserKeyResponse.md)
 - [CheckoutStateProvinceResponse](docs/CheckoutStateProvinceResponse.md)
 - [CityStateZip](docs/CityStateZip.md)
 - [Conversation](docs/Conversation.md)
 - [ConversationAgentAuth](docs/ConversationAgentAuth.md)
 - [ConversationAgentAuthResponse](docs/ConversationAgentAuthResponse.md)
 - [ConversationEventQueuePosition](docs/ConversationEventQueuePosition.md)
 - [ConversationMessage](docs/ConversationMessage.md)
 - [ConversationMessageTransportStatus](docs/ConversationMessageTransportStatus.md)
 - [ConversationMultimediaUploadUrl](docs/ConversationMultimediaUploadUrl.md)
 - [ConversationMultimediaUploadUrlResponse](docs/ConversationMultimediaUploadUrlResponse.md)
 - [ConversationParticipant](docs/ConversationParticipant.md)
 - [ConversationResponse](docs/ConversationResponse.md)
 - [ConversationStartRequest](docs/ConversationStartRequest.md)
 - [ConversationStartResponse](docs/ConversationStartResponse.md)
 - [ConversationSummary](docs/ConversationSummary.md)
 - [ConversationWebsocketMessage](docs/ConversationWebsocketMessage.md)
 - [ConversationsResponse](docs/ConversationsResponse.md)
 - [CountriesResponse](docs/CountriesResponse.md)
 - [Country](docs/Country.md)
 - [Coupon](docs/Coupon.md)
 - [CouponAmountOffItems](docs/CouponAmountOffItems.md)
 - [CouponAmountOffShipping](docs/CouponAmountOffShipping.md)
 - [CouponAmountOffShippingWithItemsPurchase](docs/CouponAmountOffShippingWithItemsPurchase.md)
 - [CouponAmountOffSubtotal](docs/CouponAmountOffSubtotal.md)
 - [CouponAmountOffSubtotalAndShipping](docs/CouponAmountOffSubtotalAndShipping.md)
 - [CouponAmountOffSubtotalFreeShippingWithPurchase](docs/CouponAmountOffSubtotalFreeShippingWithPurchase.md)
 - [CouponAmountOffSubtotalWithBlockPurchase](docs/CouponAmountOffSubtotalWithBlockPurchase.md)
 - [CouponAmountOffSubtotalWithItemsPurchase](docs/CouponAmountOffSubtotalWithItemsPurchase.md)
 - [CouponAmountOffSubtotalWithPurchase](docs/CouponAmountOffSubtotalWithPurchase.md)
 - [CouponAmountShippingWithSubtotal](docs/CouponAmountShippingWithSubtotal.md)
 - [CouponAutoApplyCondition](docs/CouponAutoApplyCondition.md)
 - [CouponAutoApplyConditions](docs/CouponAutoApplyConditions.md)
 - [CouponAutomaticallyApplyCouponCodes](docs/CouponAutomaticallyApplyCouponCodes.md)
 - [CouponBuyOneGetOneLimit](docs/CouponBuyOneGetOneLimit.md)
 - [CouponCodesRequest](docs/CouponCodesRequest.md)
 - [CouponCodesResponse](docs/CouponCodesResponse.md)
 - [CouponDeletesRequest](docs/CouponDeletesRequest.md)
 - [CouponDiscountItemWithItemPurchase](docs/CouponDiscountItemWithItemPurchase.md)
 - [CouponDiscountItems](docs/CouponDiscountItems.md)
 - [CouponEditorValues](docs/CouponEditorValues.md)
 - [CouponExistsResponse](docs/CouponExistsResponse.md)
 - [CouponFreeItemAndShippingWithSubtotal](docs/CouponFreeItemAndShippingWithSubtotal.md)
 - [CouponFreeItemWithItemPurchase](docs/CouponFreeItemWithItemPurchase.md)
 - [CouponFreeItemWithSubtotal](docs/CouponFreeItemWithSubtotal.md)
 - [CouponFreeItemsWithItemPurchase](docs/CouponFreeItemsWithItemPurchase.md)
 - [CouponFreeItemsWithMixMatchPurchase](docs/CouponFreeItemsWithMixMatchPurchase.md)
 - [CouponFreeShipping](docs/CouponFreeShipping.md)
 - [CouponFreeShippingSpecificItems](docs/CouponFreeShippingSpecificItems.md)
 - [CouponFreeShippingWithItemsPurchase](docs/CouponFreeShippingWithItemsPurchase.md)
 - [CouponFreeShippingWithSubtotal](docs/CouponFreeShippingWithSubtotal.md)
 - [CouponItemSearchResult](docs/CouponItemSearchResult.md)
 - [CouponItemSearchResultsResponse](docs/CouponItemSearchResultsResponse.md)
 - [CouponMultipleAmountsOffItems](docs/CouponMultipleAmountsOffItems.md)
 - [CouponNoDiscount](docs/CouponNoDiscount.md)
 - [CouponPercentOffItemWithItemsQuantityPurchase](docs/CouponPercentOffItemWithItemsQuantityPurchase.md)
 - [CouponPercentOffItems](docs/CouponPercentOffItems.md)
 - [CouponPercentOffItemsAndFreeShipping](docs/CouponPercentOffItemsAndFreeShipping.md)
 - [CouponPercentOffItemsWithItemsPurchase](docs/CouponPercentOffItemsWithItemsPurchase.md)
 - [CouponPercentOffMsrpItems](docs/CouponPercentOffMsrpItems.md)
 - [CouponPercentOffRetailPriceItems](docs/CouponPercentOffRetailPriceItems.md)
 - [CouponPercentOffShipping](docs/CouponPercentOffShipping.md)
 - [CouponPercentOffSubtotal](docs/CouponPercentOffSubtotal.md)
 - [CouponPercentOffSubtotalAndFreeShipping](docs/CouponPercentOffSubtotalAndFreeShipping.md)
 - [CouponPercentOffSubtotalLimit](docs/CouponPercentOffSubtotalLimit.md)
 - [CouponPercentOffSubtotalWithItemsPurchase](docs/CouponPercentOffSubtotalWithItemsPurchase.md)
 - [CouponPercentOffSubtotalWithSubtotal](docs/CouponPercentOffSubtotalWithSubtotal.md)
 - [CouponQuery](docs/CouponQuery.md)
 - [CouponResponse](docs/CouponResponse.md)
 - [CouponRestriction](docs/CouponRestriction.md)
 - [CouponTierAmount](docs/CouponTierAmount.md)
 - [CouponTierItemDiscount](docs/CouponTierItemDiscount.md)
 - [CouponTierPercent](docs/CouponTierPercent.md)
 - [CouponTierQuantityAmount](docs/CouponTierQuantityAmount.md)
 - [CouponTierQuantityPercent](docs/CouponTierQuantityPercent.md)
 - [CouponTieredAmountOffItems](docs/CouponTieredAmountOffItems.md)
 - [CouponTieredAmountOffSubtotal](docs/CouponTieredAmountOffSubtotal.md)
 - [CouponTieredPercentOffItems](docs/CouponTieredPercentOffItems.md)
 - [CouponTieredPercentOffShipping](docs/CouponTieredPercentOffShipping.md)
 - [CouponTieredPercentOffSubtotal](docs/CouponTieredPercentOffSubtotal.md)
 - [CouponType](docs/CouponType.md)
 - [CouponsRequest](docs/CouponsRequest.md)
 - [CouponsResponse](docs/CouponsResponse.md)
 - [Currency](docs/Currency.md)
 - [Customer](docs/Customer.md)
 - [CustomerActivity](docs/CustomerActivity.md)
 - [CustomerAffiliate](docs/CustomerAffiliate.md)
 - [CustomerAttachment](docs/CustomerAttachment.md)
 - [CustomerBilling](docs/CustomerBilling.md)
 - [CustomerCard](docs/CustomerCard.md)
 - [CustomerEditorValues](docs/CustomerEditorValues.md)
 - [CustomerEmail](docs/CustomerEmail.md)
 - [CustomerEmailListChanges](docs/CustomerEmailListChanges.md)
 - [CustomerLoyalty](docs/CustomerLoyalty.md)
 - [CustomerLoyaltyLedger](docs/CustomerLoyaltyLedger.md)
 - [CustomerLoyaltyRedemption](docs/CustomerLoyaltyRedemption.md)
 - [CustomerMergeRequest](docs/CustomerMergeRequest.md)
 - [CustomerOrdersSummary](docs/CustomerOrdersSummary.md)
 - [CustomerPricingTier](docs/CustomerPricingTier.md)
 - [CustomerPrivacy](docs/CustomerPrivacy.md)
 - [CustomerQuery](docs/CustomerQuery.md)
 - [CustomerQuotesSummary](docs/CustomerQuotesSummary.md)
 - [CustomerResponse](docs/CustomerResponse.md)
 - [CustomerReviewer](docs/CustomerReviewer.md)
 - [CustomerShipping](docs/CustomerShipping.md)
 - [CustomerSoftwareEntitlement](docs/CustomerSoftwareEntitlement.md)
 - [CustomerStoreCredit](docs/CustomerStoreCredit.md)
 - [CustomerStoreCreditAddRequest](docs/CustomerStoreCreditAddRequest.md)
 - [CustomerStoreCreditLedgerEntry](docs/CustomerStoreCreditLedgerEntry.md)
 - [CustomerStoreCreditResponse](docs/CustomerStoreCreditResponse.md)
 - [CustomerTag](docs/CustomerTag.md)
 - [CustomerTaxCodes](docs/CustomerTaxCodes.md)
 - [CustomersResponse](docs/CustomersResponse.md)
 - [DataTablesServerSideResponse](docs/DataTablesServerSideResponse.md)
 - [Distance](docs/Distance.md)
 - [DistributionCenter](docs/DistributionCenter.md)
 - [DistributionCentersResponse](docs/DistributionCentersResponse.md)
 - [EmailBaseTemplateListResponse](docs/EmailBaseTemplateListResponse.md)
 - [EmailCampaign](docs/EmailCampaign.md)
 - [EmailCampaignFolder](docs/EmailCampaignFolder.md)
 - [EmailCampaignFolderResponse](docs/EmailCampaignFolderResponse.md)
 - [EmailCampaignFoldersResponse](docs/EmailCampaignFoldersResponse.md)
 - [EmailCampaignResponse](docs/EmailCampaignResponse.md)
 - [EmailCampaignsResponse](docs/EmailCampaignsResponse.md)
 - [EmailClick](docs/EmailClick.md)
 - [EmailClicksResponse](docs/EmailClicksResponse.md)
 - [EmailCommseq](docs/EmailCommseq.md)
 - [EmailCommseqEmail](docs/EmailCommseqEmail.md)
 - [EmailCommseqEmailResponse](docs/EmailCommseqEmailResponse.md)
 - [EmailCommseqEmailSendTestRequest](docs/EmailCommseqEmailSendTestRequest.md)
 - [EmailCommseqEmailSendTestResponse](docs/EmailCommseqEmailSendTestResponse.md)
 - [EmailCommseqEmailsRequest](docs/EmailCommseqEmailsRequest.md)
 - [EmailCommseqEmailsResponse](docs/EmailCommseqEmailsResponse.md)
 - [EmailCommseqPostcard](docs/EmailCommseqPostcard.md)
 - [EmailCommseqPostcardResponse](docs/EmailCommseqPostcardResponse.md)
 - [EmailCommseqPostcardSendTestRequest](docs/EmailCommseqPostcardSendTestRequest.md)
 - [EmailCommseqPostcardSendTestResponse](docs/EmailCommseqPostcardSendTestResponse.md)
 - [EmailCommseqPostcardsRequest](docs/EmailCommseqPostcardsRequest.md)
 - [EmailCommseqPostcardsResponse](docs/EmailCommseqPostcardsResponse.md)
 - [EmailCommseqResponse](docs/EmailCommseqResponse.md)
 - [EmailCommseqStat](docs/EmailCommseqStat.md)
 - [EmailCommseqStatResponse](docs/EmailCommseqStatResponse.md)
 - [EmailCommseqStep](docs/EmailCommseqStep.md)
 - [EmailCommseqStepLog](docs/EmailCommseqStepLog.md)
 - [EmailCommseqStepLogsResponse](docs/EmailCommseqStepLogsResponse.md)
 - [EmailCommseqWebhookSendTestRequest](docs/EmailCommseqWebhookSendTestRequest.md)
 - [EmailCommseqWebhookSendTestResponse](docs/EmailCommseqWebhookSendTestResponse.md)
 - [EmailCommseqsResponse](docs/EmailCommseqsResponse.md)
 - [EmailCustomer](docs/EmailCustomer.md)
 - [EmailCustomerEditorUrlResponse](docs/EmailCustomerEditorUrlResponse.md)
 - [EmailCustomersResponse](docs/EmailCustomersResponse.md)
 - [EmailDashboardActivity](docs/EmailDashboardActivity.md)
 - [EmailDashboardActivityResponse](docs/EmailDashboardActivityResponse.md)
 - [EmailDashboardStatsResponse](docs/EmailDashboardStatsResponse.md)
 - [EmailDomain](docs/EmailDomain.md)
 - [EmailEditorTokenResponse](docs/EmailEditorTokenResponse.md)
 - [EmailFlow](docs/EmailFlow.md)
 - [EmailFlowBackPopulateRequest](docs/EmailFlowBackPopulateRequest.md)
 - [EmailFlowBackPopulateResponse](docs/EmailFlowBackPopulateResponse.md)
 - [EmailFlowFolder](docs/EmailFlowFolder.md)
 - [EmailFlowFolderResponse](docs/EmailFlowFolderResponse.md)
 - [EmailFlowFoldersResponse](docs/EmailFlowFoldersResponse.md)
 - [EmailFlowResponse](docs/EmailFlowResponse.md)
 - [EmailFlowsResponse](docs/EmailFlowsResponse.md)
 - [EmailGlobalSettings](docs/EmailGlobalSettings.md)
 - [EmailGlobalSettingsResponse](docs/EmailGlobalSettingsResponse.md)
 - [EmailGlobalUnsubscribeRequest](docs/EmailGlobalUnsubscribeRequest.md)
 - [EmailGlobalUnsubscribeResponse](docs/EmailGlobalUnsubscribeResponse.md)
 - [EmailHistogramPropertyNamesResponse](docs/EmailHistogramPropertyNamesResponse.md)
 - [EmailHistogramPropertyValuesResponse](docs/EmailHistogramPropertyValuesResponse.md)
 - [EmailList](docs/EmailList.md)
 - [EmailListArchiveResponse](docs/EmailListArchiveResponse.md)
 - [EmailListCustomer](docs/EmailListCustomer.md)
 - [EmailListCustomersResponse](docs/EmailListCustomersResponse.md)
 - [EmailListResponse](docs/EmailListResponse.md)
 - [EmailListSegmentFolder](docs/EmailListSegmentFolder.md)
 - [EmailListSegmentFolderResponse](docs/EmailListSegmentFolderResponse.md)
 - [EmailListSegmentFoldersResponse](docs/EmailListSegmentFoldersResponse.md)
 - [EmailListSegmentMembership](docs/EmailListSegmentMembership.md)
 - [EmailListSegmentUsedBy](docs/EmailListSegmentUsedBy.md)
 - [EmailListSubscribeResponse](docs/EmailListSubscribeResponse.md)
 - [EmailListsResponse](docs/EmailListsResponse.md)
 - [EmailOrder](docs/EmailOrder.md)
 - [EmailOrdersResponse](docs/EmailOrdersResponse.md)
 - [EmailPerformance](docs/EmailPerformance.md)
 - [EmailPerformanceCustomerHistogram](docs/EmailPerformanceCustomerHistogram.md)
 - [EmailPerformanceCustomerHistogramPeriod](docs/EmailPerformanceCustomerHistogramPeriod.md)
 - [EmailPerformanceDaily](docs/EmailPerformanceDaily.md)
 - [EmailPerformanceResponse](docs/EmailPerformanceResponse.md)
 - [EmailPlan](docs/EmailPlan.md)
 - [EmailPlanAdditional](docs/EmailPlanAdditional.md)
 - [EmailPlanResponse](docs/EmailPlanResponse.md)
 - [EmailPostcardStat](docs/EmailPostcardStat.md)
 - [EmailSegment](docs/EmailSegment.md)
 - [EmailSegmentArchiveResponse](docs/EmailSegmentArchiveResponse.md)
 - [EmailSegmentCustomer](docs/EmailSegmentCustomer.md)
 - [EmailSegmentCustomersResponse](docs/EmailSegmentCustomersResponse.md)
 - [EmailSegmentDownloadPrepareResponse](docs/EmailSegmentDownloadPrepareResponse.md)
 - [EmailSegmentResponse](docs/EmailSegmentResponse.md)
 - [EmailSegmentsResponse](docs/EmailSegmentsResponse.md)
 - [EmailSendingDomainResponse](docs/EmailSendingDomainResponse.md)
 - [EmailSendingDomainsResponse](docs/EmailSendingDomainsResponse.md)
 - [EmailSettings](docs/EmailSettings.md)
 - [EmailSettingsResponse](docs/EmailSettingsResponse.md)
 - [EmailStat](docs/EmailStat.md)
 - [EmailStatPostcardSummaryRequest](docs/EmailStatPostcardSummaryRequest.md)
 - [EmailStatPostcardSummaryResponse](docs/EmailStatPostcardSummaryResponse.md)
 - [EmailStatSummaryRequest](docs/EmailStatSummaryRequest.md)
 - [EmailStatSummaryResponse](docs/EmailStatSummaryResponse.md)
 - [EmailStepStat](docs/EmailStepStat.md)
 - [EmailStepStatRequest](docs/EmailStepStatRequest.md)
 - [EmailStepStatResponse](docs/EmailStepStatResponse.md)
 - [EmailStepWaitingRequest](docs/EmailStepWaitingRequest.md)
 - [EmailStepWaitingResponse](docs/EmailStepWaitingResponse.md)
 - [EmailTemplate](docs/EmailTemplate.md)
 - [EmailTemplatesResponse](docs/EmailTemplatesResponse.md)
 - [EmailThirdPartyList](docs/EmailThirdPartyList.md)
 - [EmailThirdPartyListImportRequest](docs/EmailThirdPartyListImportRequest.md)
 - [EmailThirdPartyProvider](docs/EmailThirdPartyProvider.md)
 - [EmailThirdPartyProvidersResponse](docs/EmailThirdPartyProvidersResponse.md)
 - [EmailThirdPartyTag](docs/EmailThirdPartyTag.md)
 - [EmailVerifyTokenRequest](docs/EmailVerifyTokenRequest.md)
 - [EmailVerifyTokenResponse](docs/EmailVerifyTokenResponse.md)
 - [EmailVerifyTokenValidateRequest](docs/EmailVerifyTokenValidateRequest.md)
 - [EmailVerifyTokenValidateResponse](docs/EmailVerifyTokenValidateResponse.md)
 - [EmailWebhookEditorValuesResponse](docs/EmailWebhookEditorValuesResponse.md)
 - [Error](docs/Error.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [Experiment](docs/Experiment.md)
 - [ExperimentResponse](docs/ExperimentResponse.md)
 - [ExperimentVariation](docs/ExperimentVariation.md)
 - [ExperimentVariationStat](docs/ExperimentVariationStat.md)
 - [ExperimentsResponse](docs/ExperimentsResponse.md)
 - [FulfillmentInventory](docs/FulfillmentInventory.md)
 - [FulfillmentShipment](docs/FulfillmentShipment.md)
 - [GeoPoint](docs/GeoPoint.md)
 - [GeocodeRequest](docs/GeocodeRequest.md)
 - [GeocodeResponse](docs/GeocodeResponse.md)
 - [GiftCertificate](docs/GiftCertificate.md)
 - [GiftCertificateCreateRequest](docs/GiftCertificateCreateRequest.md)
 - [GiftCertificateLedgerEntry](docs/GiftCertificateLedgerEntry.md)
 - [GiftCertificateQuery](docs/GiftCertificateQuery.md)
 - [GiftCertificateResponse](docs/GiftCertificateResponse.md)
 - [GiftCertificatesResponse](docs/GiftCertificatesResponse.md)
 - [Group](docs/Group.md)
 - [GroupResponse](docs/GroupResponse.md)
 - [GroupUserMembership](docs/GroupUserMembership.md)
 - [GroupsResponse](docs/GroupsResponse.md)
 - [HTTPHeader](docs/HTTPHeader.md)
 - [IntegrationLog](docs/IntegrationLog.md)
 - [IntegrationLogFile](docs/IntegrationLogFile.md)
 - [IntegrationLogLog](docs/IntegrationLogLog.md)
 - [IntegrationLogQueryFilterValues](docs/IntegrationLogQueryFilterValues.md)
 - [IntegrationLogQueryRequest](docs/IntegrationLogQueryRequest.md)
 - [IntegrationLogQueryResponse](docs/IntegrationLogQueryResponse.md)
 - [IntegrationLogResponse](docs/IntegrationLogResponse.md)
 - [IntegrationLogSummary](docs/IntegrationLogSummary.md)
 - [IntegrationLogSummaryQueryRequest](docs/IntegrationLogSummaryQueryRequest.md)
 - [IntegrationLogSummaryQueryResponse](docs/IntegrationLogSummaryQueryResponse.md)
 - [Item](docs/Item.md)
 - [ItemAccounting](docs/ItemAccounting.md)
 - [ItemAmember](docs/ItemAmember.md)
 - [ItemAutoOrder](docs/ItemAutoOrder.md)
 - [ItemAutoOrderStep](docs/ItemAutoOrderStep.md)
 - [ItemAutoOrderStepArbitraryUnitCostSchedule](docs/ItemAutoOrderStepArbitraryUnitCostSchedule.md)
 - [ItemAutoOrderStepGrandfatherPricing](docs/ItemAutoOrderStepGrandfatherPricing.md)
 - [ItemCCBill](docs/ItemCCBill.md)
 - [ItemChannelPartnerMapping](docs/ItemChannelPartnerMapping.md)
 - [ItemChargeback](docs/ItemChargeback.md)
 - [ItemChargebackAddendum](docs/ItemChargebackAddendum.md)
 - [ItemChargebackAdjustmentRequest](docs/ItemChargebackAdjustmentRequest.md)
 - [ItemCheckout](docs/ItemCheckout.md)
 - [ItemContent](docs/ItemContent.md)
 - [ItemContentAssignment](docs/ItemContentAssignment.md)
 - [ItemContentAttribute](docs/ItemContentAttribute.md)
 - [ItemContentMultimedia](docs/ItemContentMultimedia.md)
 - [ItemContentMultimediaThumbnail](docs/ItemContentMultimediaThumbnail.md)
 - [ItemDigitalDelivery](docs/ItemDigitalDelivery.md)
 - [ItemDigitalItem](docs/ItemDigitalItem.md)
 - [ItemEbay](docs/ItemEbay.md)
 - [ItemEbayCategorySpecific](docs/ItemEbayCategorySpecific.md)
 - [ItemEbayMarketListing](docs/ItemEbayMarketListing.md)
 - [ItemEbayMarketPlaceAnalysis](docs/ItemEbayMarketPlaceAnalysis.md)
 - [ItemEmailNotifications](docs/ItemEmailNotifications.md)
 - [ItemEnrollment123](docs/ItemEnrollment123.md)
 - [ItemFulfillmentAddon](docs/ItemFulfillmentAddon.md)
 - [ItemGiftCertificate](docs/ItemGiftCertificate.md)
 - [ItemGoogleProductSearch](docs/ItemGoogleProductSearch.md)
 - [ItemIdentifiers](docs/ItemIdentifiers.md)
 - [ItemInstantPaymentNotification](docs/ItemInstantPaymentNotification.md)
 - [ItemInstantPaymentNotifications](docs/ItemInstantPaymentNotifications.md)
 - [ItemInternal](docs/ItemInternal.md)
 - [ItemKitComponent](docs/ItemKitComponent.md)
 - [ItemKitDefinition](docs/ItemKitDefinition.md)
 - [ItemOption](docs/ItemOption.md)
 - [ItemOptionValue](docs/ItemOptionValue.md)
 - [ItemOptionValueAdditionalItem](docs/ItemOptionValueAdditionalItem.md)
 - [ItemOptionValueDigitalItem](docs/ItemOptionValueDigitalItem.md)
 - [ItemPaymentProcessing](docs/ItemPaymentProcessing.md)
 - [ItemPhysical](docs/ItemPhysical.md)
 - [ItemPricing](docs/ItemPricing.md)
 - [ItemPricingTier](docs/ItemPricingTier.md)
 - [ItemPricingTierDiscount](docs/ItemPricingTierDiscount.md)
 - [ItemPricingTierLimit](docs/ItemPricingTierLimit.md)
 - [ItemProperty](docs/ItemProperty.md)
 - [ItemRealtimePricing](docs/ItemRealtimePricing.md)
 - [ItemRelated](docs/ItemRelated.md)
 - [ItemRelatedItem](docs/ItemRelatedItem.md)
 - [ItemReporting](docs/ItemReporting.md)
 - [ItemResponse](docs/ItemResponse.md)
 - [ItemRestriction](docs/ItemRestriction.md)
 - [ItemRestrictionItem](docs/ItemRestrictionItem.md)
 - [ItemRevguard](docs/ItemRevguard.md)
 - [ItemReviews](docs/ItemReviews.md)
 - [ItemSalesforce](docs/ItemSalesforce.md)
 - [ItemShipping](docs/ItemShipping.md)
 - [ItemShippingCase](docs/ItemShippingCase.md)
 - [ItemShippingDestinationMarkup](docs/ItemShippingDestinationMarkup.md)
 - [ItemShippingDestinationRestriction](docs/ItemShippingDestinationRestriction.md)
 - [ItemShippingDistributionCenter](docs/ItemShippingDistributionCenter.md)
 - [ItemShippingMethod](docs/ItemShippingMethod.md)
 - [ItemShippingPackageRequirement](docs/ItemShippingPackageRequirement.md)
 - [ItemTag](docs/ItemTag.md)
 - [ItemTags](docs/ItemTags.md)
 - [ItemTax](docs/ItemTax.md)
 - [ItemTaxExemption](docs/ItemTaxExemption.md)
 - [ItemThirdPartyEmailMarketing](docs/ItemThirdPartyEmailMarketing.md)
 - [ItemVariantItem](docs/ItemVariantItem.md)
 - [ItemVariation](docs/ItemVariation.md)
 - [ItemVariationOption](docs/ItemVariationOption.md)
 - [ItemWishlistMember](docs/ItemWishlistMember.md)
 - [ItemsRequest](docs/ItemsRequest.md)
 - [ItemsResponse](docs/ItemsResponse.md)
 - [KeyValue](docs/KeyValue.md)
 - [LibraryFilterValues](docs/LibraryFilterValues.md)
 - [LibraryFilterValuesResponse](docs/LibraryFilterValuesResponse.md)
 - [LibraryItem](docs/LibraryItem.md)
 - [LibraryItemAccount](docs/LibraryItemAccount.md)
 - [LibraryItemAsset](docs/LibraryItemAsset.md)
 - [LibraryItemAttribute](docs/LibraryItemAttribute.md)
 - [LibraryItemEmail](docs/LibraryItemEmail.md)
 - [LibraryItemPublishedMeta](docs/LibraryItemPublishedMeta.md)
 - [LibraryItemPurchasedMeta](docs/LibraryItemPurchasedMeta.md)
 - [LibraryItemQuery](docs/LibraryItemQuery.md)
 - [LibraryItemResponse](docs/LibraryItemResponse.md)
 - [LibraryItemScreenshot](docs/LibraryItemScreenshot.md)
 - [LibraryItemsResponse](docs/LibraryItemsResponse.md)
 - [LinkedAccount](docs/LinkedAccount.md)
 - [ListSegmentMembership](docs/ListSegmentMembership.md)
 - [LookupRequest](docs/LookupRequest.md)
 - [LookupResponse](docs/LookupResponse.md)
 - [Mailgun](docs/Mailgun.md)
 - [Metric](docs/Metric.md)
 - [ModelProperty](docs/ModelProperty.md)
 - [Notification](docs/Notification.md)
 - [OauthRevokeSuccessResponse](docs/OauthRevokeSuccessResponse.md)
 - [OauthTokenResponse](docs/OauthTokenResponse.md)
 - [Order](docs/Order.md)
 - [OrderAffiliate](docs/OrderAffiliate.md)
 - [OrderAffiliateLedger](docs/OrderAffiliateLedger.md)
 - [OrderAutoOrder](docs/OrderAutoOrder.md)
 - [OrderBilling](docs/OrderBilling.md)
 - [OrderBuysafe](docs/OrderBuysafe.md)
 - [OrderByTokenQuery](docs/OrderByTokenQuery.md)
 - [OrderChannelPartner](docs/OrderChannelPartner.md)
 - [OrderCheckout](docs/OrderCheckout.md)
 - [OrderCoupon](docs/OrderCoupon.md)
 - [OrderDigitalItem](docs/OrderDigitalItem.md)
 - [OrderDigitalOrder](docs/OrderDigitalOrder.md)
 - [OrderEdi](docs/OrderEdi.md)
 - [OrderFormat](docs/OrderFormat.md)
 - [OrderFormatResponse](docs/OrderFormatResponse.md)
 - [OrderFraudScore](docs/OrderFraudScore.md)
 - [OrderGift](docs/OrderGift.md)
 - [OrderGiftCertificate](docs/OrderGiftCertificate.md)
 - [OrderInternal](docs/OrderInternal.md)
 - [OrderItem](docs/OrderItem.md)
 - [OrderItemEdi](docs/OrderItemEdi.md)
 - [OrderItemEdiIdentification](docs/OrderItemEdiIdentification.md)
 - [OrderItemEdiLot](docs/OrderItemEdiLot.md)
 - [OrderItemOption](docs/OrderItemOption.md)
 - [OrderItemOptionFileAttachment](docs/OrderItemOptionFileAttachment.md)
 - [OrderItemProperty](docs/OrderItemProperty.md)
 - [OrderItemTag](docs/OrderItemTag.md)
 - [OrderLinkedShipment](docs/OrderLinkedShipment.md)
 - [OrderMarketing](docs/OrderMarketing.md)
 - [OrderPackingSlipResponse](docs/OrderPackingSlipResponse.md)
 - [OrderPayment](docs/OrderPayment.md)
 - [OrderPaymentCheck](docs/OrderPaymentCheck.md)
 - [OrderPaymentCreditCard](docs/OrderPaymentCreditCard.md)
 - [OrderPaymentECheck](docs/OrderPaymentECheck.md)
 - [OrderPaymentInsurance](docs/OrderPaymentInsurance.md)
 - [OrderPaymentPurchaseOrder](docs/OrderPaymentPurchaseOrder.md)
 - [OrderPaymentTransaction](docs/OrderPaymentTransaction.md)
 - [OrderPaymentTransactionDetail](docs/OrderPaymentTransactionDetail.md)
 - [OrderProcessPaymentRequest](docs/OrderProcessPaymentRequest.md)
 - [OrderProcessPaymentResponse](docs/OrderProcessPaymentResponse.md)
 - [OrderProperty](docs/OrderProperty.md)
 - [OrderQuery](docs/OrderQuery.md)
 - [OrderQueryBatch](docs/OrderQueryBatch.md)
 - [OrderQuote](docs/OrderQuote.md)
 - [OrderReplacement](docs/OrderReplacement.md)
 - [OrderReplacementItem](docs/OrderReplacementItem.md)
 - [OrderReplacementResponse](docs/OrderReplacementResponse.md)
 - [OrderResponse](docs/OrderResponse.md)
 - [OrderSalesforce](docs/OrderSalesforce.md)
 - [OrderShipping](docs/OrderShipping.md)
 - [OrderSummary](docs/OrderSummary.md)
 - [OrderTag](docs/OrderTag.md)
 - [OrderTaxes](docs/OrderTaxes.md)
 - [OrderTokenResponse](docs/OrderTokenResponse.md)
 - [OrderTrackingNumberDetail](docs/OrderTrackingNumberDetail.md)
 - [OrderTrackingNumberDetails](docs/OrderTrackingNumberDetails.md)
 - [OrdersResponse](docs/OrdersResponse.md)
 - [Permission](docs/Permission.md)
 - [PricingTier](docs/PricingTier.md)
 - [PricingTierNotification](docs/PricingTierNotification.md)
 - [PricingTiersResponse](docs/PricingTiersResponse.md)
 - [PublishLibraryItemRequest](docs/PublishLibraryItemRequest.md)
 - [RegisterAffiliateClickRequest](docs/RegisterAffiliateClickRequest.md)
 - [RegisterAffiliateClickResponse](docs/RegisterAffiliateClickResponse.md)
 - [ResponseMetadata](docs/ResponseMetadata.md)
 - [ResultSet](docs/ResultSet.md)
 - [ScreenRecording](docs/ScreenRecording.md)
 - [ScreenRecordingAdPlatform](docs/ScreenRecordingAdPlatform.md)
 - [ScreenRecordingFilter](docs/ScreenRecordingFilter.md)
 - [ScreenRecordingFilterGeoDistance](docs/ScreenRecordingFilterGeoDistance.md)
 - [ScreenRecordingFilterIpSearch](docs/ScreenRecordingFilterIpSearch.md)
 - [ScreenRecordingFilterPageView](docs/ScreenRecordingFilterPageView.md)
 - [ScreenRecordingFilterPageViewEvent](docs/ScreenRecordingFilterPageViewEvent.md)
 - [ScreenRecordingFilterPageViewEventParam](docs/ScreenRecordingFilterPageViewEventParam.md)
 - [ScreenRecordingFilterPageViewParam](docs/ScreenRecordingFilterPageViewParam.md)
 - [ScreenRecordingFilterPageViewReferrerParam](docs/ScreenRecordingFilterPageViewReferrerParam.md)
 - [ScreenRecordingFilterRangeBigDecimal](docs/ScreenRecordingFilterRangeBigDecimal.md)
 - [ScreenRecordingFilterRangeDate](docs/ScreenRecordingFilterRangeDate.md)
 - [ScreenRecordingFilterRangeInteger](docs/ScreenRecordingFilterRangeInteger.md)
 - [ScreenRecordingFilterStringSearch](docs/ScreenRecordingFilterStringSearch.md)
 - [ScreenRecordingFilterValues](docs/ScreenRecordingFilterValues.md)
 - [ScreenRecordingFilterValuesEvent](docs/ScreenRecordingFilterValuesEvent.md)
 - [ScreenRecordingFilterValuesEventParams](docs/ScreenRecordingFilterValuesEventParams.md)
 - [ScreenRecordingFilterValuesPageParam](docs/ScreenRecordingFilterValuesPageParam.md)
 - [ScreenRecordingFilterValuesPageView](docs/ScreenRecordingFilterValuesPageView.md)
 - [ScreenRecordingHeatmap](docs/ScreenRecordingHeatmap.md)
 - [ScreenRecordingHeatmapIndexRequest](docs/ScreenRecordingHeatmapIndexRequest.md)
 - [ScreenRecordingHeatmapIndexResponse](docs/ScreenRecordingHeatmapIndexResponse.md)
 - [ScreenRecordingHeatmapRequest](docs/ScreenRecordingHeatmapRequest.md)
 - [ScreenRecordingHeatmapReset](docs/ScreenRecordingHeatmapReset.md)
 - [ScreenRecordingHeatmapResponse](docs/ScreenRecordingHeatmapResponse.md)
 - [ScreenRecordingHeatmapUrl](docs/ScreenRecordingHeatmapUrl.md)
 - [ScreenRecordingMerchantNotesRequest](docs/ScreenRecordingMerchantNotesRequest.md)
 - [ScreenRecordingMultifield](docs/ScreenRecordingMultifield.md)
 - [ScreenRecordingPageView](docs/ScreenRecordingPageView.md)
 - [ScreenRecordingPageViewDataResponse](docs/ScreenRecordingPageViewDataResponse.md)
 - [ScreenRecordingPageViewEvent](docs/ScreenRecordingPageViewEvent.md)
 - [ScreenRecordingPageViewEventParameter](docs/ScreenRecordingPageViewEventParameter.md)
 - [ScreenRecordingPageViewParameter](docs/ScreenRecordingPageViewParameter.md)
 - [ScreenRecordingQueryRequest](docs/ScreenRecordingQueryRequest.md)
 - [ScreenRecordingQueryResponse](docs/ScreenRecordingQueryResponse.md)
 - [ScreenRecordingResponse](docs/ScreenRecordingResponse.md)
 - [ScreenRecordingSegment](docs/ScreenRecordingSegment.md)
 - [ScreenRecordingSegmentResponse](docs/ScreenRecordingSegmentResponse.md)
 - [ScreenRecordingSegmentsResponse](docs/ScreenRecordingSegmentsResponse.md)
 - [ScreenRecordingSettings](docs/ScreenRecordingSettings.md)
 - [ScreenRecordingSettingsResponse](docs/ScreenRecordingSettingsResponse.md)
 - [ScreenRecordingStoreFront](docs/ScreenRecordingStoreFront.md)
 - [ScreenRecordingTagsRequest](docs/ScreenRecordingTagsRequest.md)
 - [ScreenRecordingTagsResponse](docs/ScreenRecordingTagsResponse.md)
 - [ScreenRecordingUserAgent](docs/ScreenRecordingUserAgent.md)
 - [ScreenRecordingUserAgentDevice](docs/ScreenRecordingUserAgentDevice.md)
 - [ScreenRecordingUserAgentOS](docs/ScreenRecordingUserAgentOS.md)
 - [ScreenRecordingUserProperty](docs/ScreenRecordingUserProperty.md)
 - [ScreenshotsResponse](docs/ScreenshotsResponse.md)
 - [SelfConfig](docs/SelfConfig.md)
 - [SimpleValue](docs/SimpleValue.md)
 - [SingleSignOnAuthorizeRequest](docs/SingleSignOnAuthorizeRequest.md)
 - [SingleSignOnAuthorizeResponse](docs/SingleSignOnAuthorizeResponse.md)
 - [SingleSignOnTokenRequest](docs/SingleSignOnTokenRequest.md)
 - [SingleSignOnTokenResponse](docs/SingleSignOnTokenResponse.md)
 - [SovosConfig](docs/SovosConfig.md)
 - [StateProvince](docs/StateProvince.md)
 - [StepWaiting](docs/StepWaiting.md)
 - [TaxCity](docs/TaxCity.md)
 - [TaxCountry](docs/TaxCountry.md)
 - [TaxCountryCode](docs/TaxCountryCode.md)
 - [TaxCounty](docs/TaxCounty.md)
 - [TaxJarConfig](docs/TaxJarConfig.md)
 - [TaxPostalCode](docs/TaxPostalCode.md)
 - [TaxProviderActivateResult](docs/TaxProviderActivateResult.md)
 - [TaxProviderAvalara](docs/TaxProviderAvalara.md)
 - [TaxProviderAvalaraCompaniesResult](docs/TaxProviderAvalaraCompaniesResult.md)
 - [TaxProviderAvalaraCompany](docs/TaxProviderAvalaraCompany.md)
 - [TaxProviderSelf](docs/TaxProviderSelf.md)
 - [TaxProviderSelfCountriesResponse](docs/TaxProviderSelfCountriesResponse.md)
 - [TaxProviderSelfRegionsResponse](docs/TaxProviderSelfRegionsResponse.md)
 - [TaxProviderSovos](docs/TaxProviderSovos.md)
 - [TaxProviderTaxJar](docs/TaxProviderTaxJar.md)
 - [TaxProviderTestResult](docs/TaxProviderTestResult.md)
 - [TaxProviderUltraCart](docs/TaxProviderUltraCart.md)
 - [TaxProviderUltraCartState](docs/TaxProviderUltraCartState.md)
 - [TaxProvidersResponse](docs/TaxProvidersResponse.md)
 - [TaxState](docs/TaxState.md)
 - [TaxStateCode](docs/TaxStateCode.md)
 - [TempMultimedia](docs/TempMultimedia.md)
 - [TempMultimediaResponse](docs/TempMultimediaResponse.md)
 - [ThumbnailParametersRequest](docs/ThumbnailParametersRequest.md)
 - [ThumbnailParametersResponse](docs/ThumbnailParametersResponse.md)
 - [TransactionEmail](docs/TransactionEmail.md)
 - [TransactionEmailListResponse](docs/TransactionEmailListResponse.md)
 - [TransactionEmailOption](docs/TransactionEmailOption.md)
 - [TransactionEmailResponse](docs/TransactionEmailResponse.md)
 - [Twilio](docs/Twilio.md)
 - [TwilioResponse](docs/TwilioResponse.md)
 - [TwiliosResponse](docs/TwiliosResponse.md)
 - [UltraCartConfig](docs/UltraCartConfig.md)
 - [UploadCouponCodesRequest](docs/UploadCouponCodesRequest.md)
 - [UploadCouponCodesResponse](docs/UploadCouponCodesResponse.md)
 - [User](docs/User.md)
 - [UserGroupMembership](docs/UserGroupMembership.md)
 - [UserLogin](docs/UserLogin.md)
 - [UserLoginsResponse](docs/UserLoginsResponse.md)
 - [UserResponse](docs/UserResponse.md)
 - [UsersResponse](docs/UsersResponse.md)
 - [VerificationRecord](docs/VerificationRecord.md)
 - [Warning](docs/Warning.md)
 - [Webhook](docs/Webhook.md)
 - [WebhookEventCategory](docs/WebhookEventCategory.md)
 - [WebhookEventSubscription](docs/WebhookEventSubscription.md)
 - [WebhookLog](docs/WebhookLog.md)
 - [WebhookLogResponse](docs/WebhookLogResponse.md)
 - [WebhookLogSummariesResponse](docs/WebhookLogSummariesResponse.md)
 - [WebhookLogSummary](docs/WebhookLogSummary.md)
 - [WebhookResponse](docs/WebhookResponse.md)
 - [WebhookSampleRequest](docs/WebhookSampleRequest.md)
 - [WebhookSampleRequestResponse](docs/WebhookSampleRequestResponse.md)
 - [WebhooksResponse](docs/WebhooksResponse.md)
 - [Weight](docs/Weight.md)


## Documentation For Authorization


## ultraCartBrowserApiKey

- **Type**: API key
- **API key parameter name**: x-ultracart-browser-key
- **Location**: HTTP header

## ultraCartOauth

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://secure.ultracart.com/rest/v2/oauth/authorize
- **Scopes**: 
 - **affiliate_read**: Allows you to read affiliate information.
 - **affiliate_write**: Allows you to write affiliate information.
 - **auto_order_read**: Allows you to read auto order information.
 - **auto_order_write**: Allows you to write auto order information.
 - **channel_partner_read**: Allows you to read channel partner information.
 - **channel_partner_write**: Allows you to write channel partner information.
 - **chargeback_read**: Allows you to read chargeback information.
 - **chargeback_write**: Allows you to write chargeback information.
 - **checkout_read**: Allows you to read checkout information.
 - **checkout_write**: Allows you to write checkout information.
 - **configuration_read**: Allows you to read configuration information.
 - **configuration_write**: Allows you to write configuration information.
 - **conversation_read**: Allows you to read conversation information.
 - **conversation_write**: Allows you to write conversation information.
 - **coupon_read**: Allows you to read coupon information.
 - **coupon_write**: Allows you to write coupon information.
 - **customer_read**: Allows you to read customer information.
 - **customer_write**: Allows you to write customer information.
 - **fulfillment_read**: Allows you to read fulfillment information.
 - **fulfillment_write**: Allows you to write fulfillment information.
 - **gift_certificate_read**: Allows you to read gift certificate information.
 - **gift_certificate_write**: Allows you to write gift certificate information.
 - **integration_log_read**: Allows you to read integration log information.
 - **integration_log_write**: Allows you to write integration log information.
 - **order_read**: Allows you to read order information.
 - **order_write**: Allows you to write order information.
 - **item_read**: Allows you to read item information.
 - **item_write**: Allows you to write item information.
 - **storefront_read**: Allows you to read storefront information.
 - **storefront_write**: Allows you to write storefront information.
 - **tax_read**: Allows you to read tax configuration information.
 - **tax_write**: Allows you to write tax configuration information.
 - **webhook_read**: Allows you to read webhook information.
 - **webhook_write**: Allows you to write webhook information.
 - **ultrabooks_read**: 1 of 2 required to use UltraBooks
 - **ultrabooks_write**: 2 of 2 required to use UltraBooks
 - **user_read**: Allows you to read user information.
 - **user_write**: Allows you to write user information.

## ultraCartSimpleApiKey

- **Type**: API key
- **API key parameter name**: x-ultracart-simple-key
- **Location**: HTTP header


## Author

support@ultracart.com




# CHANGE LOG
Not every change is committed to every SDK.

| Version | Date | Comments |
| --: | :-: | --- |
| 3.10.25 | 07/25/2022 | conversation development |
| 3.10.24 | 07/25/2022 | conversations bug fixes |
| 3.10.23 | 07/25/2022 | conversations - add a websocket message model |
| 3.10.22 | 07/20/2022 | conversation participant name added |
| 3.10.21 | 07/18/2022 | twilio dev |
| 3.10.20 | 07/14/2022 | Add channel storefront_oid to the customer activity record |
| 3.10.19 | 07/11/2022 | Customer API - mergeCustomer method |
| 3.10.18 | 06/23/2022 | removed unneeded consumes declarations on several api calls (yaml fix) |
| 3.10.17 | 06/23/2022 | automation test |
| 3.10.16 | 06/23/2022 | automation test |
| 3.10.15 | 06/21/2022 | ChannelPartnerApi.estimateShipping |
| 3.10.14 | 06/16/2022 | added createEmailSendingDomain2 to support additional MTAs |
| 3.10.13 | 06/16/2022 | renamed latest method to avoid conflict between customer profile search and storefront search |
| 3.10.12 | 06/16/2022 | Customer profile search method to look up tags |
| 3.10.11 | 06/10/2022 | esp segment 3rd party sync add/remove tag fields |
| 3.10.10 | 06/06/2022 | storefront communication options for syncing to third party provider list |
| 3.10.9 | 06/01/2022 | bug fixes for customer profile store credit |
| 3.10.8 | 05/27/2022 | customer store credit |
| 3.10.7 | 05/23/2022 | add internal gift cert to order summary, addl provider info for storefront comm |
| 3.10.6 | 05/23/2022 | add internal gift cert to order summary, addl provider info for storefront comm |
| 3.10.5 | 05/20/2022 | dependabot on java gson version |
| 3.10.4 | 05/20/2022 | dependabot on java gson |
| 3.10.3 | 05/20/2022 | OrderApi.generatePackingSkip calls had wrong return type |
| 3.10.2 | 05/12/2022 | ChannelPartnerApi renamed one of the delete methods |
| 3.10.1 | 05/12/2022 | ChannelPartnerApi added orderId to import response obj |
| 3.10.0 | 05/10/2022 | beta release of ChannelPartnerApi |
| 3.9.8 | 04/26/2022 | OrderApi.duplicateOrder |
| 3.9.7 | 04/25/2022 | integration logs method for zpl to pdf conversion |
| 3.9.6 | 04/25/2022 | storefront communications email magic link setting |
| 3.9.5 | 04/14/2022 | postcard screenshot bug fixes |
| 3.9.4 | 04/13/2022 | Added spf DNS record to the sending domain object |
| 3.9.3 | 04/06/2022 | fix return object on send webhook test method |
| 3.9.2 | 04/04/2022 | user.email field extended and postcard screenshot fields |
| 3.9.1 | 03/03/2022 | javascript sdk package.json bug fix |
| 3.9.0 | 03/03/2022 | removed  ultra_cart_rest_api_v2.d.ts from javascript sdk because typescript sdk exists now |
| 3.8.8 | 03/02/2022 | bug fix for ruby sdk, uri.escape deprecated in 3.x |
| 3.8.7 | 03/02/2022 | bug fix for ruby sdk, uri.escape deprecated in 3.x |
| 3.8.6 | 03/02/2022 | bug fix for ruby sdk, uri.escape deprecated in 3.x |
| 3.8.5 | 02/25/2022 | new coupon for fixed cost shipping method |
| 3.8.2 | 02/16/2022 | create gift certificate method was missing email |
| 3.8.1 | 02/16/2022 | auto order item level pause flag |
| 3.8.0 | 02/16/2022 | gift certificate api (testing) |
| 3.7.38 | 02/15/2022 | gift certificate api (currently in testing) |
| 3.6.38 | 02/07/2022 | Exposed auto order logs |
| 3.6.37 | 02/04/2022 | insurance type for insurance payments |
| 3.6.36 | 12/29/2021 | Mail actual post card flag added to test method |
| 3.6.35 | 12/14/2021 | Add cancel_auto_order option to the accounts receivable retry configuration |
| 3.6.34 | 12/14/2021 | add evening phone E.164 fields to order billing/shipping objects |
| 3.6.33 | 12/13/2021 | automation testing |
| 3.6.32 | 12/10/2021 | testing automation - message 4 |
| 3.6.25 | 12/06/2021 | sdk automation testing.  no changes to actual sdk | 
| 3.6.24 | 11/30/2021 | return items_invalid_for_coupons for CouponResponse object to drive UI warnings | 
| 3.6.23 | 11/29/2021 | Item auto order prohibit cards that expire in months setting. | 
| 3.6.22 | 11/23/2021 | new storefront methods for twilio configuration | 
| 3.6.21 | 11/08/2021 | item shipping distribution center level CostOfGoodsSold | 
| 3.6.20 | 11/05/2021 | additional item auto order step types  | 
| 3.6.19 | 10/05/2021 | item fulfillment add ons  | 
| 3.6.18 | 09/30/2021 | terms if auto order flag added  | 
| 3.6.16 | 09/30/2021 | item exclude from sitemap field  | 
| 3.6.15 | 09/28/2021 | added refund_claim_id to insurance object  | 
| 3.6.14 | 09/21/2021 | configuration api fix.  the echeck test methods were attached to the paper check object  | 
| 3.6.13 | 09/20/2021 | expose EasyPost tracker id if available on shipment tracking details  | 
| 3.6.12 | 09/20/2021 | fix method for getCouponsByQuery to be POST instead of GET since it uses a JSON body  | 
| 3.6.11 | 09/13/2021 | fix for CouponApi, broke due to inadvertent parameter inclusion   | 
| 3.6.10 | 09/09/2021 | added constants for Google Shopping payment method (still in development)  | 
| 3.6.9 | 09/07/2021 | customer profile editor values have new list of state optional countries  | 
| 3.6.8 | 08/31/2021 | coupon query field to allow merchant code and description to be searched  | 
| 3.6.7 | 08/27/2021 | customer profile affiliate information now contains affiliate first and last name | 
| 3.6.6 | 08/26/2021 | configuration api - more field changes for UI | 
| 3.6.5 | 08/25/2021 | configuration api - removed some internal fields from sdk | 
| 3.6.4 | 08/24/2021 | configuration api - new payment method named insurance | 
| 3.6.1 | 08/23/2021 | configuration api - enum problems, also added order.item.tracking_number to support line item tracking numbers | 
| 3.6.0 | 08/19/2021 | coupon api - changed tieredAmountOffItem to support mulitple items | 
| 3.5.3 | 08/18/2021 | configuration api - added credit card rate to UltraCart Payments object | 
| 3.5.1 | 08/11/2021 | email webhook test method | 
| 3.5.0 | 08/11/2021 | RestOrderChannelPartner.store_completed was incorrectly defaulting to true | 
| 3.4.13 | 08/10/2021 | configuration api - changed some field types form string to number | 
| 3.4.12 | 08/10/2021 | email engine - added webhook editor values for internal ui  | 
| 3.4.9 | 08/05/2021 | configuration api - updated annotations for method names | 
| 3.4.8 | 08/04/2021 | configuration api - payments config refactoring | 
| 3.4.7 | 08/04/2021 | esp folders for lists/segments | 
| 3.4.5 | 08/03/2021 | configuration api bug fix for a bad response object on updateRotatingTransactionGateway | 
| 3.4.3 | 08/03/2021 | package tracking - add event_iso_date and event_timezone_id | 
| 3.4.2 | 07/29/2021 | bug fixes for new configuration api | 
| 3.4.1 | 07/29/2021 | bug fixes for new configuration api | 
| 3.4.0 | 07/29/2021 | added new configuration api (not live yet. sdk only works against development presently) | 
| 3.3.2 | 07/16/2021 | sso bug fixes | 
| 3.3.1 | 07/16/2021 | screen recording - event sub text used for assisting in UX rendering | 
| 3.3.0 | 07/16/2021 | new endpoint SingleSignOn | 
| 3.2.15 | 07/13/2021 | storefront communications - added methods to retrieve step dispatch logs | 
| 3.2.14 | 07/12/2021 | fix documentation bug on packing slip methods for order api | 
| 3.2.13 | 07/12/2021 | coupon api - added hideFromCustomer flag | 
| 3.2.12 | 07/09/2021 | new fulfillment and order methods for generation of packing slips | 
| 3.2.11 | 07/08/2021 | screen recording - missing external tracking flag added | 
| 3.2.10 | 07/08/2021 | customer profile - allow drop shipping options | 
| 3.2.9 | 07/07/2021 | screen recording - provide cost per thousand and retention interval | 
| 3.2.8 | 07/06/2021 | intgeration logs - min max log date/time retured in filter values | 
| 3.2.7 | 07/05/2021 | integration logger bug fixes | 
| 3.2.6 | 06/25/2021 | integration log: added logger name | 
| 3.2.2 | 06/24/2021 | integration log file mime type added | 
| 3.2.0 | 06/23/2021 | Changed 4 methods due to naming conflicts revealed through swagger validator.  All internal methods, so impact should be negligible | 
| 3.1.50 | 06/23/2021 | Integrated Logging: returning back streamed files for log requests | 
| 3.1.49 | 06/17/2021 | Integrated Logging: standardize the response object from getIntegrationLog method  | 
| 3.1.47 | 06/16/2021 | Integrated Logging Rest API  | 
| 3.1.46 | 06/14/2021 | Screen recording: server side paginated heat map index with url contains filters, Item: channel partner item mapping unit cost override  | 
| 3.1.44 | 06/02/2021 | new boolean flag on items object to allow sharing of reviews between items   | 
| 3.1.43 | 06/01/2021 | fix item serialized name of item serialized name for channel partner item mappings  | 
| 3.1.42 | 06/01/2021 | added quickbooks accounting codes at the tiered level for tiered coupons  | 
| 3.1.41 | 05/21/2021 | screen recording heatmap methods | 
| 3.1.40 | 05/20/2021 | Order.summary.actual_payment_processing field added | 
| 3.1.39 | 05/19/2021 | full deployment to ensure all language SDKs are up to date | 
| 3.1.37 | 05/18/2021 | removed php sdk dependency on ext-mbstring by generating sdk with polyfill requirement.  sdk is more portable now. | 
| 3.1.35 | 05/14/2021 | screen recording histogram data  | 
| 3.1.34 | 05/12/2021 | screen recording preferred language, last x days filter, referrer domain | 
| 3.1.33 | 05/11/2021 | creen recording filter for affiliate id and email | 
| 3.1.32 | 05/06/2021 | customer profile pending loyalty points  | 
| 3.1.31 | 05/06/2021 | Added email domian field to screen recordings for filtering  | 
| 3.1.30 | 04/27/2021 | OrderApi.processPayment now allows a specific amount to be billed  | 
| 3.1.29 | 04/26/2021 | screen recording language iso code | 
| 3.1.28 | 04/26/2021 | screen recording statistics on the setting object | 
| 3.1.27 | 04/20/2021 | bug fix - annotation misspell on new email campaign property |
| 3.1.26 | 04/20/2021 | StoreFront Connumications - flag to end campaign or flow once purchase happens anywhere |
| 3.1.25 | 04/19/2021 | Screen recording UTM campaign and source fields |
| 3.1.24 | 04/16/2021 | Screen recording aggregations on communications campaign/flows |
| 3.1.22 | 04/09/2021 | Move URL filter values into page level view for screen recordings |
| 3.1.18 | 03/17/2021 | Added order query by ship on date |
| 3.1.17 | 03/17/2021 | New coupon - percent off MSRP item |
| 3.1.16 | 03/16/2021 | screen recording filter page parameter names |
| 3.1.15 | 03/15/2021 | fix response from deleteScreenRecordingSegment that should have been void |
| 3.1.14 | 03/15/2021 | sort screen recordings by favorite flag |
| 3.1.13 | 03/02/2021 | new webhook order_payment_failed |
| 3.1.12 | 02/25/2021 | added screen recording visitor_first_seen property |
| 3.1.11 | 02/24/2021 | Added Screen recording visitor number |
| 3.1.10 | 02/24/2021 | Added Screen recording merchant notes |
| 3.1.9 | 02/24/2021 | Allow coupons to be configured as unique with expiration on cart step within StoreFront Communications |
| 3.1.8 | 02/24/2021 | Add flag: screen recording missing event boolean |
| 3.1.5 | 02/12/2021 | Bug Fix: PHP retry logic missing a closing brace. Also screen recording page view data response refactor |
| 3.1.3 | 02/11/2021 | Bug Fix: wrong return type on CustomerApi.validateEmailVerificationToken |
| 3.1.2 | 02/11/2021 | CustomerApi.getEmailVerificationToken, CustomerApi.validateEmailVerificationToken added to allow for custom email verification.  Also added favorite flag to screen recording object |
| 3.1.1 | 02/10/2021 | CustomerApi.getCustomerByEmail() method added |
| 3.1.0 | 02/10/2021 | Minor revision jump.  Added new convenience methods for simple_key use to all api calls.  Updated docs |
| 3.0.75 | 02/01/2021 | StoreFront Communication plan revision (internal use) |
| 3.0.71 | 01/28/2021 | BugFix: PHP SDK retry logic NPE |
| 3.0.70 | 01/26/2021 | Checkout return URL support |
| 3.0.66 | 01/22/2021 | code library attributes (mostly internal dev) |
| 3.0.65 | 01/22/2021 | Added folder support for email campaigns and flows |
| 3.0.64 | 01/20/2021 | Bug fix on revenue per customer field incorrectly named. |
| 3.0.63 | 01/20/2021 | CouponAPI: bug fixes and new method doesCouponCodeExist |
| 3.0.62 | 01/19/2021 | Added retry ability when rate limit is triggered (PHP SDK only) only) Other sdk to follow. |
| 3.0.60 | 01/14/2021 | Working with Ruby SDK |
| 3.0.57 | 12/17/2020 | CouponAPI: Added Buy one get one free coupon |
| 3.0.53 | 12/14/2020 | StoreFrontAPI: added a duplicate method to load the pricing tiers on the StoreFront |
| 3.0.51 | 12/09/2020 | UserAPI: internal bug preventing proper usage of user group creation |
| 3.0.45 | 12/03/2020 | CouponAPI: added partial searches to getCoupon params, added deleteCoupons method, fixed bugs |
| 3.0.44 | 12/03/2020 | Code library updates, intended for internal use |
| 3.0.43 | 12/02/2020 | Added fields to code library to handle versions of published items |
| 3.0.42 | 12/02/2020 | Added display values to CouponApi.getEditorValues to make type dropdowns easy |
| 3.0.41 | 11/17/2020 | New modify cart step option for StoreFront communications |
| 3.0.39 | 11/12/2020 | Added Customer.tax_codes.taxjar_exemption_type |
| 3.0.38 | 11/09/2020 | Added TaxProviderTaxJar.configuration.send_outside_nexus flag |
| 3.0.37 | 11/06/2020 | Added transactional email screenshots for code library |
| 3.0.36 | 11/03/2020 | Added missing constant for pre-order stage |
| 3.0.34 | 10/26/2020 | UserAPI initial release |
| 3.0.33 | 10/23/2020 | Added library_item_oid to StoreFront Communications email object for upcoming code library |
| 3.0.32 | 10/21/2020 | Added new StoreFrontApi.search method that takes a POST instead of a GET |
| 3.0.31 | 10/16/2020 | more dev work on code library (internal) |
| 3.0.30 | 10/08/2020 | development work on code library (internal), first version of UserAPI.  The UserAPI is not live yet. |
| 3.0.29 | 09/29/2020 | new boolean field on coupon: bug fix |
| 3.0.28 | 09/29/2020 | new boolean field on coupon: free item with purchase of another item |
| 3.0.27 | 09/29/2020 | Refactored the code library applyToStoreFront to provide support for marketing emails |
| 3.0.26 | 09/25/2020 | Expose actual shipping and fulfillment costs in the order summary object |
| 3.0.25 | 09/16/2020 | New method: OrderApi.adjustOrderTotal |
| 3.0.24 | 09/10/2020 | Bugfix: incorrect response type on CheckoutAPI.registerAffiliateClick |
| 3.0.23 | 09/02/2020 | Added flag to email plan object.  allow_tracking_emails |
| 3.0.22 | 09/02/2020 | Order object - added tracking details |
| 3.0.21 | 09/01/2020 | break fix in php sdk due to bad namespace |
| 3.0.20 | 09/01/2020 | Added OrderApi.processPayment method |
| 3.0.19 | 08/28/2020 | Code Library development: added kraken parameters for thumbnail image generation. |
| 3.0.17 | 08/26/2020 | cont. development work on Code Library |
| 3.0.14 | 08/19/2020 | development work on Code Library |
| 3.0.13 | 08/18/2020 | development work on Code Library |
| 3.0.12 | 08/13/2020 | screenshot urls for campaigns and flows (storefront communications) |
| 3.0.11 | 08/12/2020 | Refactoring and development for Code Library (not released yet) |
| 3.0.10 | 08/10/2020 | Method for registering an affliate click via the SDK, found within CheckoutAPI |
| 3.0.8 | 08/05/2020 | stub for code library 'getLibraryFilterValues' for populating drop down lists |
| 3.0.4 | 08/05/2020 | fixed misspell of 'version' in LibraryItem object. |
| 3.0.3 | 08/04/2020 | added description to addToLibrary call to allow for initial description |
| 3.0.2 | 08/03/2020 | added option on email render step config to allow override of subject, added flow/campaign flag to end once customer purchases |
| 3.0.1 | 07/27/2020 | added init_json to storefront communication email objects |
| 3.0.0 | 07/01/2020 | upgraded our swagger-codegen fork to the latest swagger source code. this was a major changes so we jumped version numbers.  please test all code. |

Some changes jump version numbers due to multiple commits for bug fixes, omissions, and errors.
At UltraCart, we eat our own dog food, and we increment the version number for every commit in order
to generate a new javascript npm.  For this reason, version gaps will be found in the change log above.
