import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * (experimental) The action to take when the cluster step fails.
 *
 * @default CONTINUE
 * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_StepConfig.html
 *
 * Here, they are named as TERMINATE_JOB_FLOW, TERMINATE_CLUSTER, CANCEL_AND_WAIT, and CONTINUE respectively.
 * @experimental
 */
export declare enum ActionOnFailure {
    /**
     * (experimental) Terminate the Cluster on Step Failure.
     *
     * @experimental
     */
    TERMINATE_CLUSTER = "TERMINATE_CLUSTER",
    /**
     * (experimental) Cancel Step execution and enter WAITING state.
     *
     * @experimental
     */
    CANCEL_AND_WAIT = "CANCEL_AND_WAIT",
    /**
     * (experimental) Continue to the next Step.
     *
     * @experimental
     */
    CONTINUE = "CONTINUE"
}
/**
 * (experimental) Properties for EmrAddStep.
 *
 * @experimental
 */
export interface EmrAddStepProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) The ClusterId to add the Step to.
     *
     * @experimental
     */
    readonly clusterId: string;
    /**
     * (experimental) The name of the Step.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_StepConfig.html
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The action to take when the cluster step fails.
     *
     * @default ActionOnFailure.CONTINUE
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_StepConfig.html
     * @experimental
     */
    readonly actionOnFailure?: ActionOnFailure;
    /**
     * (experimental) A path to a JAR file run during the step.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_HadoopJarStepConfig.html
     * @experimental
     */
    readonly jar: string;
    /**
     * (experimental) The name of the main class in the specified Java file.
     *
     * If not specified, the JAR file should specify a Main-Class in its manifest file.
     *
     * @default - No mainClass
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_HadoopJarStepConfig.html
     * @experimental
     */
    readonly mainClass?: string;
    /**
     * (experimental) A list of command line arguments passed to the JAR file's main function when executed.
     *
     * @default - No args
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_HadoopJarStepConfig.html
     * @experimental
     */
    readonly args?: string[];
    /**
     * (experimental) A list of Java properties that are set when the step runs.
     *
     * You can use these properties to pass key value pairs to your main function.
     *
     * @default - No properties
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_HadoopJarStepConfig.html
     * @experimental
     */
    readonly properties?: {
        [key: string]: string;
    };
}
/**
 * (experimental) A Step Functions Task to add a Step to an EMR Cluster.
 *
 * The StepConfiguration is defined as Parameters in the state machine definition.
 *
 * OUTPUT: the StepId
 *
 * @experimental
 */
export declare class EmrAddStep extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    private readonly actionOnFailure;
    private readonly integrationPattern;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: EmrAddStepProps);
    /**
     * This generates the PolicyStatements required by the Task to call AddStep.
     */
    private createPolicyStatements;
}
