# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pyrealm']

package_data = \
{'': ['*']}

install_requires = \
['Bottleneck>=1.3.5,<2.0.0',
 'dacite>=1.6.0,<2.0.0',
 'enforce-typing>=1.0.0,<2.0.0',
 'numpy>=1.16.5,<2.0.0',
 'scipy>=1.7.3,<2.0.0',
 'tabulate>=0.8.10,<0.9.0']

setup_kwargs = {
    'name': 'pyrealm',
    'version': '0.8.1',
    'description': 'Python implementations of REALM models',
    'long_description': '# The `pyrealm` package\n\nThese are development notes for the package, user documentation can be found at:\n\n[](https://pyrealm.readthedocs.io/)\n\n## Overview\n\nThis a Python 3 package intended to provide a common framework for a number of\nrelated models of plant productivity, growth and demography.\n\n## Code development\n\nThe codebase is developed in `git` with a repository at:\n\n[https://github.com/davidorme/pyrealm](https://github.com/davidorme/pyrealm)\n\nIt uses the `git flow` model for development and release. Briefly:\n\n* All code development should happen on the general `develop` branch or on specific\n  `feature/feature_name` branches.\n* Candidate release versions should be made on specific `release/x.y.z` branches\n  and these are then committed to the `master` branch only after final checking.\n* The `master` branch should only ever contain commits representing new release\n  versions - do not work on the `master` branch.\n\n## Continuous integration\n\nThe project uses continuous integration on the Travis platform to check that the\npackage is building correctly as changes are committed to Github. The status of\nbuilds can be seen at:\n\n[https://travis-ci.com/github/davidorme/pyrealm](https://travis-ci.com/github/davidorme/pyrealm)\n\n## Documentation\n\nThe `pyrealm` package is documented using `sphinx`, with source material in the\n`source` directory.\n\nThe documentation in `source` uses [Myst Markdown](https://myst-parser.readthedocs.io/en/latest/)\nrather than the standard `sphinx` reStructuredText (`.rst`) format. This is\nbecause the documentation uses the `myst_nb` extension to `sphinx` that supports\nrunning documentation as a Jupyter notebook: the built documentation includes\nexamples of running code and output plots to demonstrate the use and behaviour\nof the package.\n\nThe `sphinx` configuration includes the `sphinx.ext.mathjax`\nextension to support mathematical notation. This has been configured to also\nload the `mhchem` extension, supporting the rendering of chemical notation.\n\n### Docstrings\n\nThe module codes uses docstrings written in the\n[Google style](https://sphinxcontrib-napoleon.readthedocs.io/en/latest/example_google.html).\nUnlike the main documentation pages, the docstrings in code are written using\nreStructuredText because the `autodoc` functions in `sphinx` currently rely on `rst`\ninputs. This allows the function documentation to be stored alongside the code\nand included simply into the documentation.\n\n### Building the documentation\n\nAdditional python packages given in `source/requirements.txt` are needed\nto build the documentation. To actually build the documentation, use\n`make` in the package root, which will use the `Makefile` created by\n`sphinx-quickstart`.\n\n```bash\nmake html\n```\n\n### Online documentation\n\nTODO - change this to github deployment?\n\nThe documentation for the package is hosted at:\n\n[](https://pyrealm.readthedocs.io/en/develop/pmodel.html)\n\nThis has been configured to build commits to the `master` branch, which should\ngenerate version specific sets of documentation.\n\n### Referencing\n\nThe documentation uses the `sphinxcontrib-bibtex` package to support citations.\nThis uses Latex like citation keys in the documentation to insert references and\nbuild a bibliography. The reference library in `source/refs.bib` needs to be\nkept up to date with the literature for the project.\n\nAt present, that package uses a rather ugly citation style. I\'m hoping the\n`sphinx_astrorefs` package will help out, but there is currently an issue\ngetting that package to load.\n\n## Testing\n\n### Developer installation\n\nUse the local directory as an editable installation of the package\n\n```sh\npip install -e .\n```\n\n### Using `doctest`\n\nThe package docstrings contain `doctest` examples of code use. These are\nintended to demonstrate use and to validate a reference set of inputs against\nexpected outputs. They do not provide extensive unit testing! To run the\ndocstring tests, use:\n\n```bash\npython -m doctest pyrealm/pmodel.py\npython -m doctest pyrealm/*.py\n```\n\nFor `doctest` on warnings, see the example for `pyrealm.utilities.convert_rh_to_vpd`\nwhich redirects the stderr to stdout to allow for the warning text to be\nincluded in the doctest.\n\n### Using `pytest`\n\nThe `test` directory contains `pytest` modules to provide greater testing of\ndifferent input combinations (scalars and arrays) and to check errors are\nraised correctly.\n\n```bash\npytest\n```\n\n### Reference values for testing\n\nThe sources of the reference inputs and outputs are:\n\n`pmodel` module:\n    Benjamin Stocker\'s [`rpmodel`](https://github.com/stineb/rpmodel/tree/master/R)\n    implementation of the P-model in R. The `test` directory contains a YAML\n    file of inputs (`test_inputs.yaml`) and an `R` script (`test_output_rpmodel.R`)\n    that are used to generate a larger YAML file (`test_outputs_rpmodel.R`) that\n    are loaded and validated against {mod}`pyrealm.pmodel` by `test_pmodel.py`.\n\n## Continuous Integration\n\n## Git flow\n\n### Configure `git`\n\nIt is easier if `git` is configured to push new tags along with commits. This\nessentially just means that new releases can be sent with a single commit,\nwhich is simpler and saves Travis from building both the the code commit and\nthen the tagged version. This only needs to be set once.\n\n```bash\nset git config --global push.followTags true\n```\n\nUsing git-flow and travis\n\nUse git flow to create a release\n\n```bash\ngit flow release start 0.3.0\n```\n\nand then bump the version number in `version.py`.\n\nCheck the package builds and installs locally:\n\n```bash\npython setup.py sdist bdist_wheel\n```\n\nCommit the version number change and then publish the branch:\n\n```sh\ngit commit -m "Version bump" pyrealm/version.py\ngit flow release publish x.y.z\n```\n\nto get the branch onto the origin repository and hence into Travis.\n\n### Use twine to check it passes onto testpypi\n\nWe are using `twine` to publish versions to PyPi, and using the `testpypi`\nsandbox to check release candidates are accepted. This needs an account\nfor both pypi and testpypi.\n\nRemembering to change the version number, use `twine` to upload the built\nversions to the `testpypi` site:\n\n```sh\ntwine upload -r testpypi dist/*x.y.z*\n```\n\n### Check the documentation builds\n\nLog in to:\n\n[](https://readthedocs.org)\n\nwhich is the admin site controlling the build process. From the Versions\ntab, activate the `release/x.y.z` branch and wait for it to build. Check\nthe Builds tab to see that it has built successfully and maybe check\nupdates! If it has built succesfully, then go back to the Versions tab\nand deactivate and hide the branch.\n\n## Success\n\nOnce all seems well,  the next step is to finish the release, which merges\nchanges into `develop` and into a tagged commit on `master`. You then need\nto checkout the master branch and push the new version and tag to GitHub.\n\n```bash\ngit flow release finish x.y.z\ngit checkout master\ngit push\n```\n\n## PyPi upload\n\nTo upload the new version to the main PyPi site, run the build process again\nin the `master` branch to get the release builds:\n\n```sh\npython setup.py sdist bdist_wheel\n```\n\nAnd then release the distribution using `twine` for use via `pip` - this time\nnot using the `testpypi` sandbox.\n\n```sh\ntwine upload dist/*x.y.z*\n```\n\nNow:\n\n* **switch back to `develop`!**\n\n```sh\ngit checkout develop\n```\n\n* Bump the version number to add `.post9000` to show the code is in development again.\n',
    'author': 'David Orme',
    'author_email': 'd.orme@imperial.ac.uk',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://pyrealm.readthedocs.io/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<3.11',
}


setup(**setup_kwargs)
