"use strict";
/**
 *  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const iam = require("@aws-cdk/aws-iam");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, 'test-apigateway-sagemakerendpoint-overwrite');
stack.templateOptions.description = 'Integration Test for aws-apigateway-sagemakerendpoint';
const existingRole = new iam.Role(stack, 'api-gateway-role', {
    assumedBy: new iam.ServicePrincipal('apigateway.amazonaws.com'),
    description: 'existing role for SageMaker integration',
    inlinePolicies: {
        InvokePolicy: new iam.PolicyDocument({
            statements: [new iam.PolicyStatement({
                    resources: [`arn:${core_1.Aws.PARTITION}:sagemaker:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:endpoint/my-endpoint`],
                    actions: ['sagemaker:InvokeEndpoint']
                })]
        })
    }
});
// Definitions
const requestTemplate = `{
    "instances": [
#set( $user_id = $input.params("user_id") )
#set( $items = $input.params("items") )
#foreach( $item in $items.split(",") )
    {"in0": [$user_id], "in1": [$item]}#if( $foreach.hasNext ),#end
    $esc.newline
#end
    ]
}`;
const responseTemplate = `{
    "ratings": [
#set( $predictions = $input.path("$.predictions") )
#foreach( $item in $predictions )
    $item.scores[0]#if( $foreach.hasNext ),#end
    $esc.newline
#end
    ]
}`;
const props = {
    endpointName: 'my-endpoint',
    resourcePath: '{user_id}',
    resourceName: 'predicted-ratings',
    requestMappingTemplate: requestTemplate,
    responseMappingTemplate: responseTemplate,
    apiGatewayExecutionRole: existingRole
};
new lib_1.ApiGatewayToSageMakerEndpoint(stack, 'test-apigateway-sagemakerendpoint-overwrite', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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