"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DaemonSet = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const base_1 = require("./base");
const k8s = require("./imports/k8s");
const pod_1 = require("./pod");
/**
 * A DaemonSet ensures that all (or some) Nodes run a copy of a Pod.
 * As nodes are added to the cluster, Pods are added to them.
 * As nodes are removed from the cluster, those Pods are garbage collected.
 * Deleting a DaemonSet will clean up the Pods it created.
 *
 * Some typical uses of a DaemonSet are:
 *
 * - running a cluster storage daemon on every node
 * - running a logs collection daemon on every node
 * - running a node monitoring daemon on every node
 *
 * In a simple case, one DaemonSet, covering all nodes, would be used for each type of daemon.
 * A more complex setup might use multiple DaemonSets for a single type of daemon,
 * but with different flags and/or different memory and cpu requests for different hardware types.
 */
class DaemonSet extends base_1.Resource {
    constructor(scope, id, props = {}) {
        var _b, _c;
        super(scope, id);
        this.apiObject = new k8s.KubeDaemonSet(this, 'Resource', {
            metadata: props.metadata,
            spec: cdk8s_1.Lazy.any({ produce: () => this._toKube() }),
        });
        this.minReadySeconds = (_b = props.minReadySeconds) !== null && _b !== void 0 ? _b : 0;
        this._podTemplate = new pod_1.PodTemplate(props);
        this._labelSelector = {};
        if ((_c = props.defaultSelector) !== null && _c !== void 0 ? _c : true) {
            const selector = 'cdk8s.daemon-set';
            const matcher = cdk8s_1.Names.toLabelValue(this);
            this.podMetadata.addLabel(selector, matcher);
            this.selectByLabel(selector, matcher);
        }
    }
    /**
     * The labels this daemon set will match against in order to select pods.
     *
     * Returns a a copy. Use `selectByLabel()` to add labels.
     */
    get labelSelector() {
        return { ...this._labelSelector };
    }
    get podMetadata() {
        return this._podTemplate.podMetadata;
    }
    get containers() {
        return this._podTemplate.containers;
    }
    get initContainers() {
        return this._podTemplate.initContainers;
    }
    get hostAliases() {
        return this._podTemplate.hostAliases;
    }
    get volumes() {
        return this._podTemplate.volumes;
    }
    get restartPolicy() {
        return this._podTemplate.restartPolicy;
    }
    get serviceAccount() {
        return this._podTemplate.serviceAccount;
    }
    get securityContext() {
        return this._podTemplate.securityContext;
    }
    addContainer(container) {
        return this._podTemplate.addContainer(container);
    }
    addInitContainer(container) {
        return this._podTemplate.addInitContainer(container);
    }
    addHostAlias(hostAlias) {
        return this._podTemplate.addHostAlias(hostAlias);
    }
    addVolume(volume) {
        return this._podTemplate.addVolume(volume);
    }
    /**
     * Configure a label selector to this daemon set.
     */
    selectByLabel(key, value) {
        this._labelSelector[key] = value;
    }
    /**
     * @internal
     */
    _toKube() {
        return {
            minReadySeconds: this.minReadySeconds,
            template: this._podTemplate._toPodTemplateSpec(),
            selector: {
                matchLabels: this._labelSelector,
            },
        };
    }
}
exports.DaemonSet = DaemonSet;
_a = JSII_RTTI_SYMBOL_1;
DaemonSet[_a] = { fqn: "cdk8s-plus-22.DaemonSet", version: "1.0.0-beta.193" };
//# sourceMappingURL=data:application/json;base64,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