# coding: utf-8

"""
    STACKIT MongoDB Service API

    This is the documentation for the STACKIT MongoDB Flex Service API

    The version of the OpenAPI document: 1.0.0
    Contact: support@stackit.cloud
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501 docstring might be too long

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set, Union

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing_extensions import Self

from stackit.mongodbflex.models.mongodbatlas_operation import MongodbatlasOperation


class Shape(BaseModel):
    """
    Shape
    """

    avg_ms: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="Average duration in milliseconds for the queries examined that match this shape.",
        alias="avgMs",
    )
    count: Optional[StrictInt] = Field(default=None, description="Number of queries examined that match this shape.")
    id: Optional[StrictStr] = Field(
        default=None, description="Unique id for this shape. Exists only for the duration of the API request."
    )
    inefficiency_score: Optional[StrictInt] = Field(
        default=None,
        description="Average number of documents read for every document returned by the query.",
        alias="inefficiencyScore",
    )
    namespace: Optional[StrictStr] = Field(default=None, description="The namespace in which the slow query ran.")
    operations: Optional[List[MongodbatlasOperation]] = Field(
        default=None,
        description="It represents documents with specific information and log lines for individual queries.",
    )
    __properties: ClassVar[List[str]] = ["avgMs", "count", "id", "inefficiencyScore", "namespace", "operations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Shape from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in operations (list)
        _items = []
        if self.operations:
            for _item in self.operations:
                if _item:
                    _items.append(_item.to_dict())
            _dict["operations"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Shape from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "avgMs": obj.get("avgMs"),
                "count": obj.get("count"),
                "id": obj.get("id"),
                "inefficiencyScore": obj.get("inefficiencyScore"),
                "namespace": obj.get("namespace"),
                "operations": (
                    [MongodbatlasOperation.from_dict(_item) for _item in obj["operations"]]
                    if obj.get("operations") is not None
                    else None
                ),
            }
        )
        return _obj
