import { Construct } from '@aws-cdk/core';
import { ComputeType } from '@aws-cdk/aws-codebuild';
import { ActionBindOptions, ActionConfig, Artifact, CommonAwsActionProps, IStage } from '@aws-cdk/aws-codepipeline';
import { Action } from '@aws-cdk/aws-codepipeline-actions';
export interface CodePipelineDockerfileLinterActionProps extends CommonAwsActionProps {
    /**
     * The source to use as input for this action.
     */
    readonly input: Artifact;
    /**
     * Version of hadolint
     *
     * @default v1.18.0
     */
    readonly version?: string;
    /**
     * The type of compute to use for backup the repositories.
     * See the {@link ComputeType} enum for the possible values.
     *
     * @default taken from {@link LinuxBuildImage.STANDARD_4_0#defaultComputeType}
     */
    readonly computeType?: ComputeType;
}
export declare class CodePipelineDockerfileLinterAction extends Action {
    private readonly props;
    constructor(props: CodePipelineDockerfileLinterActionProps);
    protected bound(scope: Construct, _stage: IStage, options: ActionBindOptions): ActionConfig;
}
