import '../style/index.css';
import { IMetadata, IMetadataWidgetProps, MetadataWidget } from '@elyra/metadata-common';
import { JupyterFrontEnd } from '@jupyterlab/application';
import { IEditorServices } from '@jupyterlab/codeeditor';
import { LabIcon } from '@jupyterlab/ui-components';
import { Widget } from '@lumino/widgets';
import React from 'react';
/**
 * CodeSnippetWidget props.
 */
export interface ICodeSnippetWidgetProps extends IMetadataWidgetProps {
    app: JupyterFrontEnd;
    display_name: string;
    namespace: string;
    schema: string;
    icon: LabIcon;
    getCurrentWidget: () => Widget | null;
    editorServices: IEditorServices;
}
/**
 * A widget for Code Snippets.
 */
export declare class CodeSnippetWidget extends MetadataWidget {
    props: ICodeSnippetWidgetProps;
    constructor(props: ICodeSnippetWidgetProps);
    fetchMetadata(): Promise<any>;
    renderDisplay(metadata: IMetadata[]): React.ReactElement;
}
