import { IMetadata } from '@elyra/metadata-common';
export declare const CODE_SNIPPET_NAMESPACE = "code-snippets";
export declare const CODE_SNIPPET_SCHEMA = "code-snippet";
export declare class CodeSnippetService {
    static findAll(): Promise<IMetadata[]>;
    static findByLanguage(language: string): Promise<IMetadata[]>;
    /**
     * Opens a dialog to confirm that the given code snippet
     * should be deleted, then sends a delete request to the metadata server.
     *
     * @param codeSnippet: code snippet to be deleted
     *
     * @returns A boolean promise that is true if the dialog confirmed
     * the deletion, and false if the deletion was cancelled.
     */
    static deleteCodeSnippet(codeSnippet: IMetadata): Promise<boolean>;
}
