"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Group = exports.User = exports.ClusterRoleBinding = exports.RoleBinding = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const base_1 = require("./base");
const k8s = require("./imports/k8s");
const utils_1 = require("./utils");
/**
 * A RoleBinding grants permissions within a specific namespace to a user or
 * set of users.
 */
class RoleBinding extends base_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.resourceType = 'rolebindings';
        this.role = props.role;
        this._subjects = new Array();
        this.apiObject = new k8s.KubeRoleBinding(this, 'Resource', {
            metadata: props.metadata,
            subjects: cdk8s_1.Lazy.any({ produce: () => this.synthesizeSubjects() }),
            roleRef: cdk8s_1.Lazy.any({ produce: () => this.synthesizeRoleRef() }),
        });
    }
    /**
     * Adds a subject to the role.
     * @param subjects The subjects to add
     */
    addSubjects(...subjects) {
        for (const subject of subjects) {
            this._subjects.push(subject);
        }
    }
    get subjects() {
        return [...this._subjects];
    }
    synthesizeRoleRef() {
        return {
            apiGroup: this.role.apiGroup,
            kind: this.role.kind,
            name: this.role.name,
        };
    }
    synthesizeSubjects() {
        return this._subjects.map((subject) => utils_1.filterUndefined({
            apiGroup: subject.apiGroup === 'core' ? '' : subject.apiGroup,
            kind: subject.kind,
            name: subject.name,
            namespace: subject.namespace,
        }));
    }
}
exports.RoleBinding = RoleBinding;
_a = JSII_RTTI_SYMBOL_1;
RoleBinding[_a] = { fqn: "cdk8s-plus-22.RoleBinding", version: "2.0.0-beta.4" };
/**
 * A ClusterRoleBinding grants permissions cluster-wide to a user or
 * set of users.
 */
class ClusterRoleBinding extends base_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.resourceType = 'clusterrolebindings';
        this.role = props.role;
        this._subjects = new Array();
        this.apiObject = new k8s.KubeClusterRoleBinding(this, 'Resource', {
            metadata: props.metadata,
            subjects: cdk8s_1.Lazy.any({ produce: () => this.synthesizeSubjects() }),
            roleRef: cdk8s_1.Lazy.any({ produce: () => this.synthesizeRoleRef() }),
        });
    }
    /**
     * Adds a subject to the role.
     * @param subjects The subjects to add
     */
    addSubjects(...subjects) {
        for (const subject of subjects) {
            this._subjects.push(subject);
        }
    }
    get subjects() {
        return [...this._subjects];
    }
    synthesizeRoleRef() {
        return {
            apiGroup: this.role.apiGroup,
            kind: this.role.kind,
            name: this.role.name,
        };
    }
    synthesizeSubjects() {
        return this._subjects.map((subject) => utils_1.filterUndefined({
            apiGroup: subject.apiGroup === 'core' ? '' : subject.apiGroup,
            kind: subject.kind,
            name: subject.name,
            namespace: subject.namespace,
        }));
    }
}
exports.ClusterRoleBinding = ClusterRoleBinding;
_b = JSII_RTTI_SYMBOL_1;
ClusterRoleBinding[_b] = { fqn: "cdk8s-plus-22.ClusterRoleBinding", version: "2.0.0-beta.4" };
/**
 * Represents a user.
 */
class User {
    constructor(props) {
        this.apiGroup = 'rbac.authorization.k8s.io';
        this.kind = 'User';
        this.name = props.name;
    }
}
exports.User = User;
_c = JSII_RTTI_SYMBOL_1;
User[_c] = { fqn: "cdk8s-plus-22.User", version: "2.0.0-beta.4" };
/**
 * Represents a group.
 */
class Group {
    constructor(props) {
        this.apiGroup = 'rbac.authorization.k8s.io';
        this.kind = 'Group';
        this.name = props.name;
    }
}
exports.Group = Group;
_d = JSII_RTTI_SYMBOL_1;
Group[_d] = { fqn: "cdk8s-plus-22.Group", version: "2.0.0-beta.4" };
//# sourceMappingURL=data:application/json;base64,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