# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeIpv6AddressesRequest(JDCloudRequest):
    """
    查询IPv6地址列表<br/>
支持分页查询，默认每页20条<br/>

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeIpv6AddressesRequest, self).__init__(
            '/regions/{regionId}/ipv6Addresses', 'GET', header, version)
        self.parameters = parameters


class DescribeIpv6AddressesParameters(object):

    def __init__(self, regionId, ):
        """
        :param regionId: 地域ID，可调用接口（describeRegiones）获取云物理服务器支持的地域
        """

        self.regionId = regionId
        self.pageNumber = None
        self.pageSize = None
        self.ipv6GatewayId = None
        self.ipv6Address = None
        self.enableInternet = None
        self.filters = None

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 页码；默认为1
        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 分页大小；默认为20；取值范围[20, 100]
        """
        self.pageSize = pageSize

    def setIpv6GatewayId(self, ipv6GatewayId):
        """
        :param ipv6GatewayId: (Optional) IPv6网关ID
        """
        self.ipv6GatewayId = ipv6GatewayId

    def setIpv6Address(self, ipv6Address):
        """
        :param ipv6Address: (Optional) IPv6地址
        """
        self.ipv6Address = ipv6Address

    def setEnableInternet(self, enableInternet):
        """
        :param enableInternet: (Optional) 是否已开通公网
        """
        self.enableInternet = enableInternet

    def setFilters(self, filters):
        """
        :param filters: (Optional) ipv6AddressId - IPv6地址ID，精确匹配，支持多个

        """
        self.filters = filters

