# mypy-boto3-datasync

[![PyPI - mypy-boto3-datasync](https://img.shields.io/pypi/v/mypy-boto3-datasync.svg?color=blue)](https://pypi.org/project/mypy-boto3-datasync)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-datasync.svg?color=blue)](https://pypi.org/project/mypy-boto3-datasync)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.DataSync 1.14.47](https://boto3.amazonaws.com/v1/documentation/api/1.14.47/reference/services/datasync.html#DataSync) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `DataSync` service.

```bash
python -m pip install boto3-stubs[datasync]
```

## How to use

### Client annotations

`DataSyncClient` provides annotations for `boto3.client("datasync")`.

```python
import boto3

from mypy_boto3_datasync import DataSyncClient
from mypy_boto3_datasync.paginator import (
    ListAgentsPaginator,
    ListLocationsPaginator,
    ListTagsForResourcePaginator,
    ListTaskExecutionsPaginator,
    ListTasksPaginator,
)
from mypy_boto3_datasync.type_defs import AgentListEntryTypeDef, ...

client: DataSyncClient = boto3.client("datasync")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: DataSyncClient = session.client("datasync")
```

### Paginators annotations

`mypy_boto3_datasync.paginator` module contains type annotations for all paginators.

```python

client: DataSyncClient = boto3.client("datasync")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_agents_paginator: ListAgentsPaginator = client.get_paginator("list_agents")
list_locations_paginator: ListLocationsPaginator = client.get_paginator("list_locations")
list_tags_for_resource_paginator: ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
list_task_executions_paginator: ListTaskExecutionsPaginator = client.get_paginator("list_task_executions")
list_tasks_paginator: ListTasksPaginator = client.get_paginator("list_tasks")
```







### Typed dictionations

`mypy_boto3_datasync.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> AgentListEntryTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_datasync` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("datasync")

session_client = boto3.Session().client("datasync")
```
