import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * Properties for invoking an Activity worker.
 *
 * @stability stable
 */
export interface StepFunctionsInvokeActivityProps extends sfn.TaskStateBaseProps {
    /**
     * Step Functions Activity to invoke.
     *
     * @stability stable
     */
    readonly activity: sfn.IActivity;
}
/**
 * A Step Functions Task to invoke an Activity worker.
 *
 * An Activity can be used directly as a Resource.
 *
 * @stability stable
 */
export declare class StepFunctionsInvokeActivity extends sfn.TaskStateBase {
    private readonly props;
    /**
     * @stability stable
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @stability stable
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: StepFunctionsInvokeActivityProps);
    /**
     * @internal
     */
    protected _renderTask(): any;
}
