import * as ec2 from '@aws-cdk/aws-ec2';
import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
import { AlgorithmSpecification, Channel, OutputDataConfig, ResourceConfig, StoppingCondition, VpcConfig } from './base-types';
/**
 * (experimental) Properties for creating an Amazon SageMaker training job.
 *
 * @experimental
 */
export interface SageMakerCreateTrainingJobProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) Training Job Name.
     *
     * @experimental
     */
    readonly trainingJobName: string;
    /**
     * (experimental) Role for the Training Job.
     *
     * The role must be granted all necessary permissions for the SageMaker training job to
     * be able to operate.
     *
     * See https://docs.aws.amazon.com/fr_fr/sagemaker/latest/dg/sagemaker-roles.html#sagemaker-roles-createtrainingjob-perms
     *
     * @default - a role will be created.
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) Identifies the training algorithm to use.
     *
     * @experimental
     */
    readonly algorithmSpecification: AlgorithmSpecification;
    /**
     * (experimental) Algorithm-specific parameters that influence the quality of the model.
     *
     * Set hyperparameters before you start the learning process.
     * For a list of hyperparameters provided by Amazon SageMaker
     *
     * @default - No hyperparameters
     * @see https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html
     * @experimental
     */
    readonly hyperparameters?: {
        [key: string]: any;
    };
    /**
     * (experimental) Describes the various datasets (e.g. train, validation, test) and the Amazon S3 location where stored.
     *
     * @experimental
     */
    readonly inputDataConfig: Channel[];
    /**
     * (experimental) Tags to be applied to the train job.
     *
     * @default - No tags
     * @experimental
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * (experimental) Identifies the Amazon S3 location where you want Amazon SageMaker to save the results of model training.
     *
     * @experimental
     */
    readonly outputDataConfig: OutputDataConfig;
    /**
     * (experimental) Specifies the resources, ML compute instances, and ML storage volumes to deploy for model training.
     *
     * @default - 1 instance of EC2 `M4.XLarge` with `10GB` volume
     * @experimental
     */
    readonly resourceConfig?: ResourceConfig;
    /**
     * (experimental) Sets a time limit for training.
     *
     * @default - max runtime of 1 hour
     * @experimental
     */
    readonly stoppingCondition?: StoppingCondition;
    /**
     * (experimental) Specifies the VPC that you want your training job to connect to.
     *
     * @default - No VPC
     * @experimental
     */
    readonly vpcConfig?: VpcConfig;
}
/**
 * (experimental) Class representing the SageMaker Create Training Job task.
 *
 * @experimental
 */
export declare class SageMakerCreateTrainingJob extends sfn.TaskStateBase implements iam.IGrantable, ec2.IConnectable {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * (experimental) Allows specify security group connections for instances of this fleet.
     *
     * @experimental
     */
    readonly connections: ec2.Connections;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * The Algorithm Specification
     */
    private readonly algorithmSpecification;
    /**
     * The Input Data Config.
     */
    private readonly inputDataConfig;
    /**
     * The resource config for the task.
     */
    private readonly resourceConfig;
    /**
     * The resource config for the task.
     */
    private readonly stoppingCondition;
    private readonly vpc?;
    private securityGroup?;
    private readonly securityGroups;
    private readonly subnets?;
    private readonly integrationPattern;
    private _role?;
    private _grantPrincipal?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: SageMakerCreateTrainingJobProps);
    /**
     * (experimental) The execution role for the Sagemaker training job.
     *
     * Only available after task has been added to a state machine.
     *
     * @experimental
     */
    get role(): iam.IRole;
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    get grantPrincipal(): iam.IPrincipal;
    /**
     * (experimental) Add the security group to all instances via the launch configuration security groups array.
     *
     * @param securityGroup : The security group to add.
     * @experimental
     */
    addSecurityGroup(securityGroup: ec2.ISecurityGroup): void;
    /**
     * @internal
     */
    protected _renderTask(): any;
    private renderParameters;
    private renderAlgorithmSpecification;
    private renderInputDataConfig;
    private renderOutputDataConfig;
    private renderResourceConfig;
    private renderStoppingCondition;
    private renderHyperparameters;
    private renderVpcConfig;
    private makePolicyStatements;
}
