import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::NetworkFirewall::Firewall`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html
 * @external
 */
export interface CfnFirewallProps {
    /**
     * `AWS::NetworkFirewall::Firewall.FirewallName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-firewallname
     * @external
     */
    readonly firewallName: string;
    /**
     * `AWS::NetworkFirewall::Firewall.FirewallPolicyArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-firewallpolicyarn
     * @external
     */
    readonly firewallPolicyArn: string;
    /**
     * `AWS::NetworkFirewall::Firewall.SubnetMappings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-subnetmappings
     * @external
     */
    readonly subnetMappings: Array<CfnFirewall.SubnetMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::NetworkFirewall::Firewall.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-vpcid
     * @external
     */
    readonly vpcId: string;
    /**
     * `AWS::NetworkFirewall::Firewall.DeleteProtection`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-deleteprotection
     * @external
     */
    readonly deleteProtection?: boolean | cdk.IResolvable;
    /**
     * `AWS::NetworkFirewall::Firewall.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::NetworkFirewall::Firewall.FirewallPolicyChangeProtection`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-firewallpolicychangeprotection
     * @external
     */
    readonly firewallPolicyChangeProtection?: boolean | cdk.IResolvable;
    /**
     * `AWS::NetworkFirewall::Firewall.SubnetChangeProtection`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-subnetchangeprotection
     * @external
     */
    readonly subnetChangeProtection?: boolean | cdk.IResolvable;
    /**
     * `AWS::NetworkFirewall::Firewall.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-tags
     * @external
     */
    readonly tags?: CfnFirewall.TagsProperty;
}
/**
 * A CloudFormation `AWS::NetworkFirewall::Firewall`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::Firewall
 */
export declare class CfnFirewall extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::NetworkFirewall::Firewall";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFirewall;
    /**
     * @external
     * @cloudformationAttribute EndpointIds
     */
    readonly attrEndpointIds: string[];
    /**
     * @external
     * @cloudformationAttribute FirewallArn
     */
    readonly attrFirewallArn: string;
    /**
     * @external
     * @cloudformationAttribute FirewallId
     */
    readonly attrFirewallId: string;
    /**
     * `AWS::NetworkFirewall::Firewall.FirewallName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-firewallname
     * @external
     */
    firewallName: string;
    /**
     * `AWS::NetworkFirewall::Firewall.FirewallPolicyArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-firewallpolicyarn
     * @external
     */
    firewallPolicyArn: string;
    /**
     * `AWS::NetworkFirewall::Firewall.SubnetMappings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-subnetmappings
     * @external
     */
    subnetMappings: Array<CfnFirewall.SubnetMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::NetworkFirewall::Firewall.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-vpcid
     * @external
     */
    vpcId: string;
    /**
     * `AWS::NetworkFirewall::Firewall.DeleteProtection`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-deleteprotection
     * @external
     */
    deleteProtection: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::NetworkFirewall::Firewall.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::NetworkFirewall::Firewall.FirewallPolicyChangeProtection`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-firewallpolicychangeprotection
     * @external
     */
    firewallPolicyChangeProtection: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::NetworkFirewall::Firewall.SubnetChangeProtection`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-subnetchangeprotection
     * @external
     */
    subnetChangeProtection: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::NetworkFirewall::Firewall.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::NetworkFirewall::Firewall`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFirewallProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::NetworkFirewall::Firewall`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::Firewall
 */
export declare namespace CfnFirewall {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewall-subnetmapping.html
     * @external
     */
    interface SubnetMappingProperty {
        /**
         * `CfnFirewall.SubnetMappingProperty.SubnetId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewall-subnetmapping.html#cfn-networkfirewall-firewall-subnetmapping-subnetid
         * @external
         */
        readonly subnetId: string;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::Firewall`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::Firewall
 */
export declare namespace CfnFirewall {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewall-tags.html
     * @external
     */
    interface TagsProperty {
        /**
         * `CfnFirewall.TagsProperty.Tags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewall-tags.html#cfn-networkfirewall-firewall-tags-tags
         * @external
         */
        readonly tags?: cdk.CfnTag[];
    }
}
/**
 * Properties for defining a `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 * @external
 */
export interface CfnFirewallPolicyProps {
    /**
     * `AWS::NetworkFirewall::FirewallPolicy.FirewallPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-firewallpolicy
     * @external
     */
    readonly firewallPolicy: CfnFirewallPolicy.FirewallPolicyProperty | cdk.IResolvable;
    /**
     * `AWS::NetworkFirewall::FirewallPolicy.FirewallPolicyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-firewallpolicyname
     * @external
     */
    readonly firewallPolicyName: string;
    /**
     * `AWS::NetworkFirewall::FirewallPolicy.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::NetworkFirewall::FirewallPolicy.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-tags
     * @external
     */
    readonly tags?: CfnFirewallPolicy.TagsProperty;
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 */
export declare class CfnFirewallPolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::NetworkFirewall::FirewallPolicy";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFirewallPolicy;
    /**
     * @external
     * @cloudformationAttribute FirewallPolicyArn
     */
    readonly attrFirewallPolicyArn: string;
    /**
     * @external
     * @cloudformationAttribute FirewallPolicyId
     */
    readonly attrFirewallPolicyId: string;
    /**
     * `AWS::NetworkFirewall::FirewallPolicy.FirewallPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-firewallpolicy
     * @external
     */
    firewallPolicy: CfnFirewallPolicy.FirewallPolicyProperty | cdk.IResolvable;
    /**
     * `AWS::NetworkFirewall::FirewallPolicy.FirewallPolicyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-firewallpolicyname
     * @external
     */
    firewallPolicyName: string;
    /**
     * `AWS::NetworkFirewall::FirewallPolicy.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::NetworkFirewall::FirewallPolicy.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::NetworkFirewall::FirewallPolicy`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFirewallPolicyProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 */
export declare namespace CfnFirewallPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-actiondefinition.html
     * @external
     */
    interface ActionDefinitionProperty {
        /**
         * `CfnFirewallPolicy.ActionDefinitionProperty.PublishMetricAction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-actiondefinition.html#cfn-networkfirewall-firewallpolicy-actiondefinition-publishmetricaction
         * @external
         */
        readonly publishMetricAction?: CfnFirewallPolicy.PublishMetricActionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 */
export declare namespace CfnFirewallPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-customaction.html
     * @external
     */
    interface CustomActionProperty {
        /**
         * `CfnFirewallPolicy.CustomActionProperty.ActionDefinition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-customaction.html#cfn-networkfirewall-firewallpolicy-customaction-actiondefinition
         * @external
         */
        readonly actionDefinition: CfnFirewallPolicy.ActionDefinitionProperty | cdk.IResolvable;
        /**
         * `CfnFirewallPolicy.CustomActionProperty.ActionName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-customaction.html#cfn-networkfirewall-firewallpolicy-customaction-actionname
         * @external
         */
        readonly actionName: string;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 */
export declare namespace CfnFirewallPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-customactions.html
     * @external
     */
    interface CustomActionsProperty {
        /**
         * `CfnFirewallPolicy.CustomActionsProperty.CustomActions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-customactions.html#cfn-networkfirewall-firewallpolicy-customactions-customactions
         * @external
         */
        readonly customActions?: Array<CfnFirewallPolicy.CustomActionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 */
export declare namespace CfnFirewallPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-dimension.html
     * @external
     */
    interface DimensionProperty {
        /**
         * `CfnFirewallPolicy.DimensionProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-dimension.html#cfn-networkfirewall-firewallpolicy-dimension-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 */
export declare namespace CfnFirewallPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-dimensions.html
     * @external
     */
    interface DimensionsProperty {
        /**
         * `CfnFirewallPolicy.DimensionsProperty.Dimensions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-dimensions.html#cfn-networkfirewall-firewallpolicy-dimensions-dimensions
         * @external
         */
        readonly dimensions?: Array<CfnFirewallPolicy.DimensionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 */
export declare namespace CfnFirewallPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-firewallpolicy.html
     * @external
     */
    interface FirewallPolicyProperty {
        /**
         * `CfnFirewallPolicy.FirewallPolicyProperty.StatefulRuleGroupReferences`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-firewallpolicy-statefulrulegroupreferences
         * @external
         */
        readonly statefulRuleGroupReferences?: CfnFirewallPolicy.StatefulRuleGroupReferencesProperty | cdk.IResolvable;
        /**
         * `CfnFirewallPolicy.FirewallPolicyProperty.StatelessCustomActions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-firewallpolicy-statelesscustomactions
         * @external
         */
        readonly statelessCustomActions?: CfnFirewallPolicy.CustomActionsProperty | cdk.IResolvable;
        /**
         * `CfnFirewallPolicy.FirewallPolicyProperty.StatelessDefaultActions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-firewallpolicy-statelessdefaultactions
         * @external
         */
        readonly statelessDefaultActions: CfnFirewallPolicy.StatelessActionsProperty | cdk.IResolvable;
        /**
         * `CfnFirewallPolicy.FirewallPolicyProperty.StatelessFragmentDefaultActions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-firewallpolicy-statelessfragmentdefaultactions
         * @external
         */
        readonly statelessFragmentDefaultActions: CfnFirewallPolicy.StatelessActionsProperty | cdk.IResolvable;
        /**
         * `CfnFirewallPolicy.FirewallPolicyProperty.StatelessRuleGroupReferences`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-firewallpolicy-statelessrulegroupreferences
         * @external
         */
        readonly statelessRuleGroupReferences?: CfnFirewallPolicy.StatelessRuleGroupReferencesProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 */
export declare namespace CfnFirewallPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-publishmetricaction.html
     * @external
     */
    interface PublishMetricActionProperty {
        /**
         * `CfnFirewallPolicy.PublishMetricActionProperty.Dimensions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-publishmetricaction.html#cfn-networkfirewall-firewallpolicy-publishmetricaction-dimensions
         * @external
         */
        readonly dimensions: CfnFirewallPolicy.DimensionsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 */
export declare namespace CfnFirewallPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-statefulrulegroupreference.html
     * @external
     */
    interface StatefulRuleGroupReferenceProperty {
        /**
         * `CfnFirewallPolicy.StatefulRuleGroupReferenceProperty.ResourceArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-statefulrulegroupreference.html#cfn-networkfirewall-firewallpolicy-statefulrulegroupreference-resourcearn
         * @external
         */
        readonly resourceArn: string;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 */
export declare namespace CfnFirewallPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-statefulrulegroupreferences.html
     * @external
     */
    interface StatefulRuleGroupReferencesProperty {
        /**
         * `CfnFirewallPolicy.StatefulRuleGroupReferencesProperty.StatefulRuleGroupReferences`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-statefulrulegroupreferences.html#cfn-networkfirewall-firewallpolicy-statefulrulegroupreferences-statefulrulegroupreferences
         * @external
         */
        readonly statefulRuleGroupReferences?: Array<CfnFirewallPolicy.StatefulRuleGroupReferenceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 */
export declare namespace CfnFirewallPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-statelessactions.html
     * @external
     */
    interface StatelessActionsProperty {
        /**
         * `CfnFirewallPolicy.StatelessActionsProperty.StatelessActions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-statelessactions.html#cfn-networkfirewall-firewallpolicy-statelessactions-statelessactions
         * @external
         */
        readonly statelessActions?: string[];
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 */
export declare namespace CfnFirewallPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-statelessrulegroupreference.html
     * @external
     */
    interface StatelessRuleGroupReferenceProperty {
        /**
         * `CfnFirewallPolicy.StatelessRuleGroupReferenceProperty.Priority`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-statelessrulegroupreference.html#cfn-networkfirewall-firewallpolicy-statelessrulegroupreference-priority
         * @external
         */
        readonly priority: number;
        /**
         * `CfnFirewallPolicy.StatelessRuleGroupReferenceProperty.ResourceArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-statelessrulegroupreference.html#cfn-networkfirewall-firewallpolicy-statelessrulegroupreference-resourcearn
         * @external
         */
        readonly resourceArn: string;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 */
export declare namespace CfnFirewallPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-statelessrulegroupreferences.html
     * @external
     */
    interface StatelessRuleGroupReferencesProperty {
        /**
         * `CfnFirewallPolicy.StatelessRuleGroupReferencesProperty.StatelessRuleGroupReferences`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-statelessrulegroupreferences.html#cfn-networkfirewall-firewallpolicy-statelessrulegroupreferences-statelessrulegroupreferences
         * @external
         */
        readonly statelessRuleGroupReferences?: Array<CfnFirewallPolicy.StatelessRuleGroupReferenceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 */
export declare namespace CfnFirewallPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-tags.html
     * @external
     */
    interface TagsProperty {
        /**
         * `CfnFirewallPolicy.TagsProperty.Tags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-tags.html#cfn-networkfirewall-firewallpolicy-tags-tags
         * @external
         */
        readonly tags?: cdk.CfnTag[];
    }
}
/**
 * Properties for defining a `AWS::NetworkFirewall::LoggingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html
 * @external
 */
export interface CfnLoggingConfigurationProps {
    /**
     * `AWS::NetworkFirewall::LoggingConfiguration.LoggingConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-loggingconfiguration
     * @external
     */
    readonly loggingConfiguration: CfnLoggingConfiguration.LoggingConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::NetworkFirewall::LoggingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::LoggingConfiguration
 */
export declare class CfnLoggingConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::NetworkFirewall::LoggingConfiguration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLoggingConfiguration;
    /**
     * @external
     * @cloudformationAttribute FirewallArn
     */
    readonly attrFirewallArn: string;
    /**
     * @external
     * @cloudformationAttribute FirewallName
     */
    readonly attrFirewallName: string;
    /**
     * `AWS::NetworkFirewall::LoggingConfiguration.LoggingConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-loggingconfiguration
     * @external
     */
    loggingConfiguration: CfnLoggingConfiguration.LoggingConfigurationProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::NetworkFirewall::LoggingConfiguration`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLoggingConfigurationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::NetworkFirewall::LoggingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::LoggingConfiguration
 */
export declare namespace CfnLoggingConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-logdestinationconfig.html
     * @external
     */
    interface LogDestinationConfigProperty {
        /**
         * `CfnLoggingConfiguration.LogDestinationConfigProperty.LogDestination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-logdestinationconfig.html#cfn-networkfirewall-loggingconfiguration-logdestinationconfig-logdestination
         * @external
         */
        readonly logDestination: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnLoggingConfiguration.LogDestinationConfigProperty.LogDestinationType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-logdestinationconfig.html#cfn-networkfirewall-loggingconfiguration-logdestinationconfig-logdestinationtype
         * @external
         */
        readonly logDestinationType: string;
        /**
         * `CfnLoggingConfiguration.LogDestinationConfigProperty.LogType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-logdestinationconfig.html#cfn-networkfirewall-loggingconfiguration-logdestinationconfig-logtype
         * @external
         */
        readonly logType: string;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::LoggingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::LoggingConfiguration
 */
export declare namespace CfnLoggingConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-logdestinationconfigs.html
     * @external
     */
    interface LogDestinationConfigsProperty {
        /**
         * `CfnLoggingConfiguration.LogDestinationConfigsProperty.LogDestinationConfigs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-logdestinationconfigs.html#cfn-networkfirewall-loggingconfiguration-logdestinationconfigs-logdestinationconfigs
         * @external
         */
        readonly logDestinationConfigs?: Array<CfnLoggingConfiguration.LogDestinationConfigProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::LoggingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::LoggingConfiguration
 */
export declare namespace CfnLoggingConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-loggingconfiguration.html
     * @external
     */
    interface LoggingConfigurationProperty {
        /**
         * `CfnLoggingConfiguration.LoggingConfigurationProperty.LogDestinationConfigs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-loggingconfiguration-logdestinationconfigs
         * @external
         */
        readonly logDestinationConfigs: CfnLoggingConfiguration.LogDestinationConfigsProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 */
export interface CfnRuleGroupProps {
    /**
     * `AWS::NetworkFirewall::RuleGroup.Capacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-capacity
     * @external
     */
    readonly capacity: number;
    /**
     * `AWS::NetworkFirewall::RuleGroup.RuleGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroupname
     * @external
     */
    readonly ruleGroupName: string;
    /**
     * `AWS::NetworkFirewall::RuleGroup.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-type
     * @external
     */
    readonly type: string;
    /**
     * `AWS::NetworkFirewall::RuleGroup.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::NetworkFirewall::RuleGroup.RuleGroup`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup
     * @external
     */
    readonly ruleGroup?: CfnRuleGroup.RuleGroupProperty | cdk.IResolvable;
    /**
     * `AWS::NetworkFirewall::RuleGroup.RuleGroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroupid
     * @external
     */
    readonly ruleGroupId?: string;
    /**
     * `AWS::NetworkFirewall::RuleGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-tags
     * @external
     */
    readonly tags?: CfnRuleGroup.TagsProperty;
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare class CfnRuleGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::NetworkFirewall::RuleGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRuleGroup;
    /**
     * @external
     * @cloudformationAttribute RuleGroupArn
     */
    readonly attrRuleGroupArn: string;
    /**
     * `AWS::NetworkFirewall::RuleGroup.Capacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-capacity
     * @external
     */
    capacity: number;
    /**
     * `AWS::NetworkFirewall::RuleGroup.RuleGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroupname
     * @external
     */
    ruleGroupName: string;
    /**
     * `AWS::NetworkFirewall::RuleGroup.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-type
     * @external
     */
    type: string;
    /**
     * `AWS::NetworkFirewall::RuleGroup.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::NetworkFirewall::RuleGroup.RuleGroup`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup
     * @external
     */
    ruleGroup: CfnRuleGroup.RuleGroupProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::NetworkFirewall::RuleGroup.RuleGroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroupid
     * @external
     */
    ruleGroupId: string | undefined;
    /**
     * `AWS::NetworkFirewall::RuleGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::NetworkFirewall::RuleGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRuleGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-actiondefinition.html
     * @external
     */
    interface ActionDefinitionProperty {
        /**
         * `CfnRuleGroup.ActionDefinitionProperty.PublishMetricAction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-actiondefinition.html#cfn-networkfirewall-rulegroup-actiondefinition-publishmetricaction
         * @external
         */
        readonly publishMetricAction?: CfnRuleGroup.PublishMetricActionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-address.html
     * @external
     */
    interface AddressProperty {
        /**
         * `CfnRuleGroup.AddressProperty.AddressDefinition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-address.html#cfn-networkfirewall-rulegroup-address-addressdefinition
         * @external
         */
        readonly addressDefinition: string;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-addresses.html
     * @external
     */
    interface AddressesProperty {
        /**
         * `CfnRuleGroup.AddressesProperty.Addresses`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-addresses.html#cfn-networkfirewall-rulegroup-addresses-addresses
         * @external
         */
        readonly addresses?: Array<CfnRuleGroup.AddressProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-customaction.html
     * @external
     */
    interface CustomActionProperty {
        /**
         * `CfnRuleGroup.CustomActionProperty.ActionDefinition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-customaction.html#cfn-networkfirewall-rulegroup-customaction-actiondefinition
         * @external
         */
        readonly actionDefinition: CfnRuleGroup.ActionDefinitionProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.CustomActionProperty.ActionName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-customaction.html#cfn-networkfirewall-rulegroup-customaction-actionname
         * @external
         */
        readonly actionName: string;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-customactions.html
     * @external
     */
    interface CustomActionsProperty {
        /**
         * `CfnRuleGroup.CustomActionsProperty.CustomActions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-customactions.html#cfn-networkfirewall-rulegroup-customactions-customactions
         * @external
         */
        readonly customActions?: Array<CfnRuleGroup.CustomActionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-dimension.html
     * @external
     */
    interface DimensionProperty {
        /**
         * `CfnRuleGroup.DimensionProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-dimension.html#cfn-networkfirewall-rulegroup-dimension-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-dimensions.html
     * @external
     */
    interface DimensionsProperty {
        /**
         * `CfnRuleGroup.DimensionsProperty.Dimensions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-dimensions.html#cfn-networkfirewall-rulegroup-dimensions-dimensions
         * @external
         */
        readonly dimensions?: Array<CfnRuleGroup.DimensionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-flags.html
     * @external
     */
    interface FlagsProperty {
        /**
         * `CfnRuleGroup.FlagsProperty.Flags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-flags.html#cfn-networkfirewall-rulegroup-flags-flags
         * @external
         */
        readonly flags?: string[];
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html
     * @external
     */
    interface HeaderProperty {
        /**
         * `CfnRuleGroup.HeaderProperty.Destination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-destination
         * @external
         */
        readonly destination: string;
        /**
         * `CfnRuleGroup.HeaderProperty.DestinationPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-destinationport
         * @external
         */
        readonly destinationPort: string;
        /**
         * `CfnRuleGroup.HeaderProperty.Direction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-direction
         * @external
         */
        readonly direction: string;
        /**
         * `CfnRuleGroup.HeaderProperty.Protocol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-protocol
         * @external
         */
        readonly protocol: string;
        /**
         * `CfnRuleGroup.HeaderProperty.Source`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-source
         * @external
         */
        readonly source: string;
        /**
         * `CfnRuleGroup.HeaderProperty.SourcePort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-sourceport
         * @external
         */
        readonly sourcePort: string;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ipset.html
     * @external
     */
    interface IPSetProperty {
        /**
         * `CfnRuleGroup.IPSetProperty.Definition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ipset.html#cfn-networkfirewall-rulegroup-ipset-definition
         * @external
         */
        readonly definition?: CfnRuleGroup.VariableDefinitionListProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html
     * @external
     */
    interface MatchAttributesProperty {
        /**
         * `CfnRuleGroup.MatchAttributesProperty.DestinationPorts`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-destinationports
         * @external
         */
        readonly destinationPorts?: CfnRuleGroup.PortRangesProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.MatchAttributesProperty.Destinations`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-destinations
         * @external
         */
        readonly destinations?: CfnRuleGroup.AddressesProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.MatchAttributesProperty.Protocols`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-protocols
         * @external
         */
        readonly protocols?: CfnRuleGroup.ProtocolNumbersProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.MatchAttributesProperty.SourcePorts`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-sourceports
         * @external
         */
        readonly sourcePorts?: CfnRuleGroup.PortRangesProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.MatchAttributesProperty.Sources`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-sources
         * @external
         */
        readonly sources?: CfnRuleGroup.AddressesProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.MatchAttributesProperty.TCPFlags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-tcpflags
         * @external
         */
        readonly tcpFlags?: CfnRuleGroup.TCPFlagsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portrange.html
     * @external
     */
    interface PortRangeProperty {
        /**
         * `CfnRuleGroup.PortRangeProperty.FromPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portrange.html#cfn-networkfirewall-rulegroup-portrange-fromport
         * @external
         */
        readonly fromPort: number;
        /**
         * `CfnRuleGroup.PortRangeProperty.ToPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portrange.html#cfn-networkfirewall-rulegroup-portrange-toport
         * @external
         */
        readonly toPort: number;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portranges.html
     * @external
     */
    interface PortRangesProperty {
        /**
         * `CfnRuleGroup.PortRangesProperty.PortRanges`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portranges.html#cfn-networkfirewall-rulegroup-portranges-portranges
         * @external
         */
        readonly portRanges?: Array<CfnRuleGroup.PortRangeProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portset.html
     * @external
     */
    interface PortSetProperty {
        /**
         * `CfnRuleGroup.PortSetProperty.Definition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portset.html#cfn-networkfirewall-rulegroup-portset-definition
         * @external
         */
        readonly definition?: CfnRuleGroup.VariableDefinitionListProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-protocolnumbers.html
     * @external
     */
    interface ProtocolNumbersProperty {
        /**
         * `CfnRuleGroup.ProtocolNumbersProperty.ProtocolNumbers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-protocolnumbers.html#cfn-networkfirewall-rulegroup-protocolnumbers-protocolnumbers
         * @external
         */
        readonly protocolNumbers?: number[] | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-publishmetricaction.html
     * @external
     */
    interface PublishMetricActionProperty {
        /**
         * `CfnRuleGroup.PublishMetricActionProperty.Dimensions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-publishmetricaction.html#cfn-networkfirewall-rulegroup-publishmetricaction-dimensions
         * @external
         */
        readonly dimensions: CfnRuleGroup.DimensionsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruledefinition.html
     * @external
     */
    interface RuleDefinitionProperty {
        /**
         * `CfnRuleGroup.RuleDefinitionProperty.Actions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruledefinition.html#cfn-networkfirewall-rulegroup-ruledefinition-actions
         * @external
         */
        readonly actions: string[];
        /**
         * `CfnRuleGroup.RuleDefinitionProperty.MatchAttributes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruledefinition.html#cfn-networkfirewall-rulegroup-ruledefinition-matchattributes
         * @external
         */
        readonly matchAttributes: CfnRuleGroup.MatchAttributesProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulegroup.html
     * @external
     */
    interface RuleGroupProperty {
        /**
         * `CfnRuleGroup.RuleGroupProperty.RuleVariables`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup-rulevariables
         * @external
         */
        readonly ruleVariables?: CfnRuleGroup.RuleVariablesProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.RuleGroupProperty.RulesSource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup-rulessource
         * @external
         */
        readonly rulesSource: CfnRuleGroup.RulesSourceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruleoption.html
     * @external
     */
    interface RuleOptionProperty {
        /**
         * `CfnRuleGroup.RuleOptionProperty.Keyword`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruleoption.html#cfn-networkfirewall-rulegroup-ruleoption-keyword
         * @external
         */
        readonly keyword: string;
        /**
         * `CfnRuleGroup.RuleOptionProperty.Settings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruleoption.html#cfn-networkfirewall-rulegroup-ruleoption-settings
         * @external
         */
        readonly settings?: string[];
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruleoptions.html
     * @external
     */
    interface RuleOptionsProperty {
        /**
         * `CfnRuleGroup.RuleOptionsProperty.RuleOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruleoptions.html#cfn-networkfirewall-rulegroup-ruleoptions-ruleoptions
         * @external
         */
        readonly ruleOptions?: Array<CfnRuleGroup.RuleOptionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulevariables.html
     * @external
     */
    interface RuleVariablesProperty {
        /**
         * `CfnRuleGroup.RuleVariablesProperty.IPSets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulevariables.html#cfn-networkfirewall-rulegroup-rulevariables-ipsets
         * @external
         */
        readonly ipSets?: {
            [key: string]: (CfnRuleGroup.IPSetProperty | cdk.IResolvable);
        } | cdk.IResolvable;
        /**
         * `CfnRuleGroup.RuleVariablesProperty.PortSets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulevariables.html#cfn-networkfirewall-rulegroup-rulevariables-portsets
         * @external
         */
        readonly portSets?: {
            [key: string]: (CfnRuleGroup.PortSetProperty | cdk.IResolvable);
        } | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessource.html
     * @external
     */
    interface RulesSourceProperty {
        /**
         * `CfnRuleGroup.RulesSourceProperty.RulesSourceList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessource.html#cfn-networkfirewall-rulegroup-rulessource-rulessourcelist
         * @external
         */
        readonly rulesSourceList?: CfnRuleGroup.RulesSourceListProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.RulesSourceProperty.RulesString`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessource.html#cfn-networkfirewall-rulegroup-rulessource-rulesstring
         * @external
         */
        readonly rulesString?: string;
        /**
         * `CfnRuleGroup.RulesSourceProperty.StatefulRules`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessource.html#cfn-networkfirewall-rulegroup-rulessource-statefulrules
         * @external
         */
        readonly statefulRules?: CfnRuleGroup.StatefulRulesProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.RulesSourceProperty.StatelessRulesAndCustomActions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessource.html#cfn-networkfirewall-rulegroup-rulessource-statelessrulesandcustomactions
         * @external
         */
        readonly statelessRulesAndCustomActions?: CfnRuleGroup.StatelessRulesAndCustomActionsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessourcelist.html
     * @external
     */
    interface RulesSourceListProperty {
        /**
         * `CfnRuleGroup.RulesSourceListProperty.GeneratedRulesType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessourcelist.html#cfn-networkfirewall-rulegroup-rulessourcelist-generatedrulestype
         * @external
         */
        readonly generatedRulesType: string;
        /**
         * `CfnRuleGroup.RulesSourceListProperty.TargetTypes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessourcelist.html#cfn-networkfirewall-rulegroup-rulessourcelist-targettypes
         * @external
         */
        readonly targetTypes: CfnRuleGroup.TargetTypesProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.RulesSourceListProperty.Targets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessourcelist.html#cfn-networkfirewall-rulegroup-rulessourcelist-targets
         * @external
         */
        readonly targets: string[];
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulrule.html
     * @external
     */
    interface StatefulRuleProperty {
        /**
         * `CfnRuleGroup.StatefulRuleProperty.Action`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulrule.html#cfn-networkfirewall-rulegroup-statefulrule-action
         * @external
         */
        readonly action: string;
        /**
         * `CfnRuleGroup.StatefulRuleProperty.Header`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulrule.html#cfn-networkfirewall-rulegroup-statefulrule-header
         * @external
         */
        readonly header: CfnRuleGroup.HeaderProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatefulRuleProperty.RuleOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulrule.html#cfn-networkfirewall-rulegroup-statefulrule-ruleoptions
         * @external
         */
        readonly ruleOptions: CfnRuleGroup.RuleOptionsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulrules.html
     * @external
     */
    interface StatefulRulesProperty {
        /**
         * `CfnRuleGroup.StatefulRulesProperty.StatefulRules`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulrules.html#cfn-networkfirewall-rulegroup-statefulrules-statefulrules
         * @external
         */
        readonly statefulRules?: Array<CfnRuleGroup.StatefulRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrule.html
     * @external
     */
    interface StatelessRuleProperty {
        /**
         * `CfnRuleGroup.StatelessRuleProperty.Priority`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrule.html#cfn-networkfirewall-rulegroup-statelessrule-priority
         * @external
         */
        readonly priority: number;
        /**
         * `CfnRuleGroup.StatelessRuleProperty.RuleDefinition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrule.html#cfn-networkfirewall-rulegroup-statelessrule-ruledefinition
         * @external
         */
        readonly ruleDefinition: CfnRuleGroup.RuleDefinitionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrules.html
     * @external
     */
    interface StatelessRulesProperty {
        /**
         * `CfnRuleGroup.StatelessRulesProperty.StatelessRules`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrules.html#cfn-networkfirewall-rulegroup-statelessrules-statelessrules
         * @external
         */
        readonly statelessRules?: Array<CfnRuleGroup.StatelessRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrulesandcustomactions.html
     * @external
     */
    interface StatelessRulesAndCustomActionsProperty {
        /**
         * `CfnRuleGroup.StatelessRulesAndCustomActionsProperty.CustomActions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrulesandcustomactions.html#cfn-networkfirewall-rulegroup-statelessrulesandcustomactions-customactions
         * @external
         */
        readonly customActions?: CfnRuleGroup.CustomActionsProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatelessRulesAndCustomActionsProperty.StatelessRules`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrulesandcustomactions.html#cfn-networkfirewall-rulegroup-statelessrulesandcustomactions-statelessrules
         * @external
         */
        readonly statelessRules: CfnRuleGroup.StatelessRulesProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-tcpflagfield.html
     * @external
     */
    interface TCPFlagFieldProperty {
        /**
         * `CfnRuleGroup.TCPFlagFieldProperty.Flags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-tcpflagfield.html#cfn-networkfirewall-rulegroup-tcpflagfield-flags
         * @external
         */
        readonly flags: CfnRuleGroup.FlagsProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.TCPFlagFieldProperty.Masks`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-tcpflagfield.html#cfn-networkfirewall-rulegroup-tcpflagfield-masks
         * @external
         */
        readonly masks?: CfnRuleGroup.FlagsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-tcpflags.html
     * @external
     */
    interface TCPFlagsProperty {
        /**
         * `CfnRuleGroup.TCPFlagsProperty.TCPFlags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-tcpflags.html#cfn-networkfirewall-rulegroup-tcpflags-tcpflags
         * @external
         */
        readonly tcpFlags?: Array<CfnRuleGroup.TCPFlagFieldProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-tags.html
     * @external
     */
    interface TagsProperty {
        /**
         * `CfnRuleGroup.TagsProperty.Tags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-tags.html#cfn-networkfirewall-rulegroup-tags-tags
         * @external
         */
        readonly tags?: cdk.CfnTag[];
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-targettypes.html
     * @external
     */
    interface TargetTypesProperty {
        /**
         * `CfnRuleGroup.TargetTypesProperty.TargetTypes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-targettypes.html#cfn-networkfirewall-rulegroup-targettypes-targettypes
         * @external
         */
        readonly targetTypes?: string[];
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 */
export declare namespace CfnRuleGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-variabledefinitionlist.html
     * @external
     */
    interface VariableDefinitionListProperty {
        /**
         * `CfnRuleGroup.VariableDefinitionListProperty.VariableDefinitionList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-variabledefinitionlist.html#cfn-networkfirewall-rulegroup-variabledefinitionlist-variabledefinitionlist
         * @external
         */
        readonly variableDefinitionList?: string[];
    }
}
