# coding: utf-8

"""
    Swagger Petstore - OpenAPI 3.0

    This is a sample Pet Store Server based on the OpenAPI 3.0 specification.  You can find out more about Swagger at [http://swagger.io](http://swagger.io). In the third iteration of the pet store, we've switched to the design first approach! You can now help us improve the API whether it's by making changes to the definition itself or to the code. That way, with time, we can improve the API in general, and expose some of the new features in OAS3.  Some useful links: - [The Pet Store repository](https://github.com/swagger-api/swagger-petstore) - [The source API definition for the Pet Store](https://github.com/swagger-api/swagger-petstore/blob/master/src/main/resources/openapi.yaml)

    The version of the OpenAPI document: 1.0.19
    Contact: apiteam@swagger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt
from typing import Dict, Optional
from typing_extensions import Annotated
from gaurav_compose_testing_petstore_sdk.models.order import Order

from gaurav_compose_testing_petstore_sdk.api_client import ApiClient, RequestSerialized
from gaurav_compose_testing_petstore_sdk.api_response import ApiResponse
from gaurav_compose_testing_petstore_sdk.rest import RESTResponseType


class StoreApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def delete_order(
        self,
        order_id: Annotated[StrictInt, Field(description="ID of the order that needs to be deleted")],
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> None:
        """Delete purchase order by ID

        For valid response try integer IDs with value < 1000. Anything above 1000 or nonintegers will generate API errors

        :param order_id: ID of the order that needs to be deleted (required)
        :type order_id: int
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_order_serialize(
            order_id=order_id,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_order_with_http_info(
        self,
        order_id: Annotated[StrictInt, Field(description="ID of the order that needs to be deleted")],
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> ApiResponse[None]:
        """Delete purchase order by ID

        For valid response try integer IDs with value < 1000. Anything above 1000 or nonintegers will generate API errors

        :param order_id: ID of the order that needs to be deleted (required)
        :type order_id: int
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_order_serialize(
            order_id=order_id,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_order_without_preload_content(
        self,
        order_id: Annotated[StrictInt, Field(description="ID of the order that needs to be deleted")],
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> RESTResponseType:
        """Delete purchase order by ID

        For valid response try integer IDs with value < 1000. Anything above 1000 or nonintegers will generate API errors

        :param order_id: ID of the order that needs to be deleted (required)
        :type order_id: int
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_order_serialize(
            order_id=order_id,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        return response_data.response


    def _delete_order_serialize(
        self,
        order_id,
        request_auth__,
        content_type__,
        headers__,
        host__,
    ) -> RequestSerialized:


        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = headers__ or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if order_id is not None:
            _path_params['orderId'] = order_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/store/order/{orderId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            host__=host__,
            request_auth__=request_auth__
        )




    @validate_call
    def get_inventory(
        self,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> Dict[str, int]:
        """Returns pet inventories by status

        Returns a map of status codes to quantities

        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_inventory_serialize(
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Dict[str, int]",
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_inventory_with_http_info(
        self,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> ApiResponse[Dict[str, int]]:
        """Returns pet inventories by status

        Returns a map of status codes to quantities

        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_inventory_serialize(
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Dict[str, int]",
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_inventory_without_preload_content(
        self,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> RESTResponseType:
        """Returns pet inventories by status

        Returns a map of status codes to quantities

        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_inventory_serialize(
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Dict[str, int]",
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        return response_data.response


    def _get_inventory_serialize(
        self,
        request_auth__,
        content_type__,
        headers__,
        host__,
    ) -> RequestSerialized:


        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = headers__ or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'api_key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/store/inventory',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            host__=host__,
            request_auth__=request_auth__
        )




    @validate_call
    def get_order_by_id(
        self,
        order_id: Annotated[StrictInt, Field(description="ID of order that needs to be fetched")],
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> Order:
        """Find purchase order by ID

        For valid response try integer IDs with value <= 5 or > 10. Other values will generate exceptions.

        :param order_id: ID of order that needs to be fetched (required)
        :type order_id: int
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_by_id_serialize(
            order_id=order_id,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Order",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_order_by_id_with_http_info(
        self,
        order_id: Annotated[StrictInt, Field(description="ID of order that needs to be fetched")],
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> ApiResponse[Order]:
        """Find purchase order by ID

        For valid response try integer IDs with value <= 5 or > 10. Other values will generate exceptions.

        :param order_id: ID of order that needs to be fetched (required)
        :type order_id: int
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_by_id_serialize(
            order_id=order_id,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Order",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_order_by_id_without_preload_content(
        self,
        order_id: Annotated[StrictInt, Field(description="ID of order that needs to be fetched")],
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> RESTResponseType:
        """Find purchase order by ID

        For valid response try integer IDs with value <= 5 or > 10. Other values will generate exceptions.

        :param order_id: ID of order that needs to be fetched (required)
        :type order_id: int
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_by_id_serialize(
            order_id=order_id,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Order",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        return response_data.response


    def _get_order_by_id_serialize(
        self,
        order_id,
        request_auth__,
        content_type__,
        headers__,
        host__,
    ) -> RequestSerialized:


        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = headers__ or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if order_id is not None:
            _path_params['orderId'] = order_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/xml', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/store/order/{orderId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            host__=host__,
            request_auth__=request_auth__
        )




    @validate_call
    def place_order(
        self,
        order: Optional[Order] = None,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> Order:
        """Place an order for a pet

        Place a new order in the store

        :param order:
        :type order: Order
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._place_order_serialize(
            order=order,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Order",
            '405': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def place_order_with_http_info(
        self,
        order: Optional[Order] = None,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> ApiResponse[Order]:
        """Place an order for a pet

        Place a new order in the store

        :param order:
        :type order: Order
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._place_order_serialize(
            order=order,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Order",
            '405': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def place_order_without_preload_content(
        self,
        order: Optional[Order] = None,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> RESTResponseType:
        """Place an order for a pet

        Place a new order in the store

        :param order:
        :type order: Order
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._place_order_serialize(
            order=order,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Order",
            '405': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        return response_data.response


    def _place_order_serialize(
        self,
        order,
        request_auth__,
        content_type__,
        headers__,
        host__,
    ) -> RequestSerialized:


        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = headers__ or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if order is not None:
            _body_params = order


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if content_type__:
            _header_params['Content-Type'] = content_type__
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/xml', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/store/order',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            host__=host__,
            request_auth__=request_auth__
        )


