# coding: utf-8

"""
    Swagger Petstore - OpenAPI 3.0

    This is a sample Pet Store Server based on the OpenAPI 3.0 specification.  You can find out more about Swagger at [http://swagger.io](http://swagger.io). In the third iteration of the pet store, we've switched to the design first approach! You can now help us improve the API whether it's by making changes to the definition itself or to the code. That way, with time, we can improve the API in general, and expose some of the new features in OAS3.  Some useful links: - [The Pet Store repository](https://github.com/swagger-api/swagger-petstore) - [The source API definition for the Pet Store](https://github.com/swagger-api/swagger-petstore/blob/master/src/main/resources/openapi.yaml)

    The version of the OpenAPI document: 1.0.19
    Contact: apiteam@swagger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBytes, StrictInt, StrictStr, field_validator
from typing import List, Optional, Tuple, Union
from typing_extensions import Annotated
from gaurav_compose_testing_petstore_sdk.models.api_response import ApiResponse
from gaurav_compose_testing_petstore_sdk.models.pet import Pet

from gaurav_compose_testing_petstore_sdk.api_client import ApiClient, RequestSerialized
from gaurav_compose_testing_petstore_sdk.api_response import ApiResponse
from gaurav_compose_testing_petstore_sdk.rest import RESTResponseType


class PetApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def add_pet(
        self,
        pet: Annotated[Pet, Field(description="Create a new pet in the store")],
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> Pet:
        """Add a new pet to the store

        Add a new pet to the store

        :param pet: Create a new pet in the store (required)
        :type pet: Pet
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_pet_serialize(
            pet=pet,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Pet",
            '405': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def add_pet_with_http_info(
        self,
        pet: Annotated[Pet, Field(description="Create a new pet in the store")],
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> ApiResponse[Pet]:
        """Add a new pet to the store

        Add a new pet to the store

        :param pet: Create a new pet in the store (required)
        :type pet: Pet
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_pet_serialize(
            pet=pet,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Pet",
            '405': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def add_pet_without_preload_content(
        self,
        pet: Annotated[Pet, Field(description="Create a new pet in the store")],
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> RESTResponseType:
        """Add a new pet to the store

        Add a new pet to the store

        :param pet: Create a new pet in the store (required)
        :type pet: Pet
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_pet_serialize(
            pet=pet,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Pet",
            '405': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        return response_data.response


    def _add_pet_serialize(
        self,
        pet,
        request_auth__,
        content_type__,
        headers__,
        host__,
    ) -> RequestSerialized:


        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = headers__ or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if pet is not None:
            _body_params = pet


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/xml', 
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if content_type__:
            _header_params['Content-Type'] = content_type__
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/xml', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'petstore_auth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/pet',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            host__=host__,
            request_auth__=request_auth__
        )




    @validate_call
    def delete_pet(
        self,
        pet_id: Annotated[StrictInt, Field(description="Pet id to delete")],
        api_key: Optional[StrictStr] = None,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> None:
        """Deletes a pet

        

        :param pet_id: Pet id to delete (required)
        :type pet_id: int
        :param api_key: 
        :type api_key: str
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_pet_serialize(
            pet_id=pet_id,
            api_key=api_key,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_pet_with_http_info(
        self,
        pet_id: Annotated[StrictInt, Field(description="Pet id to delete")],
        api_key: Optional[StrictStr] = None,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> ApiResponse[None]:
        """Deletes a pet

        

        :param pet_id: Pet id to delete (required)
        :type pet_id: int
        :param api_key: 
        :type api_key: str
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_pet_serialize(
            pet_id=pet_id,
            api_key=api_key,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_pet_without_preload_content(
        self,
        pet_id: Annotated[StrictInt, Field(description="Pet id to delete")],
        api_key: Optional[StrictStr] = None,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> RESTResponseType:
        """Deletes a pet

        

        :param pet_id: Pet id to delete (required)
        :type pet_id: int
        :param api_key: 
        :type api_key: str
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_pet_serialize(
            pet_id=pet_id,
            api_key=api_key,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        return response_data.response


    def _delete_pet_serialize(
        self,
        pet_id,
        api_key,
        request_auth__,
        content_type__,
        headers__,
        host__,
    ) -> RequestSerialized:


        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = headers__ or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if pet_id is not None:
            _path_params['petId'] = pet_id
        # process the query parameters
        # process the header parameters
        if api_key is not None:
            _header_params['api_key'] = api_key
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'petstore_auth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/pet/{petId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            host__=host__,
            request_auth__=request_auth__
        )




    @validate_call
    def find_pets_by_status(
        self,
        status: Annotated[Optional[StrictStr], Field(description="Status values that need to be considered for filter")] = None,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> List[Pet]:
        """Finds Pets by status

        Multiple status values can be provided with comma separated strings

        :param status: Status values that need to be considered for filter
        :type status: str
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._find_pets_by_status_serialize(
            status=status,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Pet]",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def find_pets_by_status_with_http_info(
        self,
        status: Annotated[Optional[StrictStr], Field(description="Status values that need to be considered for filter")] = None,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> ApiResponse[List[Pet]]:
        """Finds Pets by status

        Multiple status values can be provided with comma separated strings

        :param status: Status values that need to be considered for filter
        :type status: str
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._find_pets_by_status_serialize(
            status=status,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Pet]",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def find_pets_by_status_without_preload_content(
        self,
        status: Annotated[Optional[StrictStr], Field(description="Status values that need to be considered for filter")] = None,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> RESTResponseType:
        """Finds Pets by status

        Multiple status values can be provided with comma separated strings

        :param status: Status values that need to be considered for filter
        :type status: str
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._find_pets_by_status_serialize(
            status=status,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Pet]",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        return response_data.response


    def _find_pets_by_status_serialize(
        self,
        status,
        request_auth__,
        content_type__,
        headers__,
        host__,
    ) -> RequestSerialized:


        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = headers__ or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if status is not None:
            
            _query_params.append(('status', status))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/xml', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'petstore_auth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/pet/findByStatus',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            host__=host__,
            request_auth__=request_auth__
        )




    @validate_call
    def find_pets_by_tags(
        self,
        tags: Annotated[Optional[List[StrictStr]], Field(description="Tags to filter by")] = None,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> List[Pet]:
        """Finds Pets by tags

        Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.

        :param tags: Tags to filter by
        :type tags: List[str]
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._find_pets_by_tags_serialize(
            tags=tags,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Pet]",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def find_pets_by_tags_with_http_info(
        self,
        tags: Annotated[Optional[List[StrictStr]], Field(description="Tags to filter by")] = None,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> ApiResponse[List[Pet]]:
        """Finds Pets by tags

        Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.

        :param tags: Tags to filter by
        :type tags: List[str]
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._find_pets_by_tags_serialize(
            tags=tags,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Pet]",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def find_pets_by_tags_without_preload_content(
        self,
        tags: Annotated[Optional[List[StrictStr]], Field(description="Tags to filter by")] = None,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> RESTResponseType:
        """Finds Pets by tags

        Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.

        :param tags: Tags to filter by
        :type tags: List[str]
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._find_pets_by_tags_serialize(
            tags=tags,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Pet]",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        return response_data.response


    def _find_pets_by_tags_serialize(
        self,
        tags,
        request_auth__,
        content_type__,
        headers__,
        host__,
    ) -> RequestSerialized:


        _collection_formats: Dict[str, str] = {
            'tags': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = headers__ or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if tags is not None:
            
            _query_params.append(('tags', tags))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/xml', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'petstore_auth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/pet/findByTags',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            host__=host__,
            request_auth__=request_auth__
        )




    @validate_call
    def get_pet_by_id(
        self,
        pet_id: Annotated[StrictInt, Field(description="ID of pet to return")],
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> Pet:
        """Find pet by ID

        Returns a single pet

        :param pet_id: ID of pet to return (required)
        :type pet_id: int
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_pet_by_id_serialize(
            pet_id=pet_id,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Pet",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_pet_by_id_with_http_info(
        self,
        pet_id: Annotated[StrictInt, Field(description="ID of pet to return")],
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> ApiResponse[Pet]:
        """Find pet by ID

        Returns a single pet

        :param pet_id: ID of pet to return (required)
        :type pet_id: int
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_pet_by_id_serialize(
            pet_id=pet_id,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Pet",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_pet_by_id_without_preload_content(
        self,
        pet_id: Annotated[StrictInt, Field(description="ID of pet to return")],
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> RESTResponseType:
        """Find pet by ID

        Returns a single pet

        :param pet_id: ID of pet to return (required)
        :type pet_id: int
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_pet_by_id_serialize(
            pet_id=pet_id,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Pet",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        return response_data.response


    def _get_pet_by_id_serialize(
        self,
        pet_id,
        request_auth__,
        content_type__,
        headers__,
        host__,
    ) -> RequestSerialized:


        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = headers__ or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if pet_id is not None:
            _path_params['petId'] = pet_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/xml', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'petstore_auth', 
            'api_key'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/pet/{petId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            host__=host__,
            request_auth__=request_auth__
        )




    @validate_call
    def update_pet(
        self,
        pet: Annotated[Pet, Field(description="Update an existent pet in the store")],
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> Pet:
        """Update an existing pet

        Update an existing pet by Id

        :param pet: Update an existent pet in the store (required)
        :type pet: Pet
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_pet_serialize(
            pet=pet,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Pet",
            '400': None,
            '404': None,
            '405': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_pet_with_http_info(
        self,
        pet: Annotated[Pet, Field(description="Update an existent pet in the store")],
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> ApiResponse[Pet]:
        """Update an existing pet

        Update an existing pet by Id

        :param pet: Update an existent pet in the store (required)
        :type pet: Pet
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_pet_serialize(
            pet=pet,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Pet",
            '400': None,
            '404': None,
            '405': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_pet_without_preload_content(
        self,
        pet: Annotated[Pet, Field(description="Update an existent pet in the store")],
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> RESTResponseType:
        """Update an existing pet

        Update an existing pet by Id

        :param pet: Update an existent pet in the store (required)
        :type pet: Pet
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_pet_serialize(
            pet=pet,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Pet",
            '400': None,
            '404': None,
            '405': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        return response_data.response


    def _update_pet_serialize(
        self,
        pet,
        request_auth__,
        content_type__,
        headers__,
        host__,
    ) -> RequestSerialized:


        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = headers__ or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if pet is not None:
            _body_params = pet


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/xml', 
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if content_type__:
            _header_params['Content-Type'] = content_type__
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/xml', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'petstore_auth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/pet',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            host__=host__,
            request_auth__=request_auth__
        )




    @validate_call
    def update_pet_with_form(
        self,
        pet_id: Annotated[StrictInt, Field(description="ID of pet that needs to be updated")],
        name: Annotated[Optional[StrictStr], Field(description="Name of pet that needs to be updated")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Status of pet that needs to be updated")] = None,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> None:
        """Updates a pet in the store with form data

        

        :param pet_id: ID of pet that needs to be updated (required)
        :type pet_id: int
        :param name: Name of pet that needs to be updated
        :type name: str
        :param status: Status of pet that needs to be updated
        :type status: str
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_pet_with_form_serialize(
            pet_id=pet_id,
            name=name,
            status=status,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '405': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_pet_with_form_with_http_info(
        self,
        pet_id: Annotated[StrictInt, Field(description="ID of pet that needs to be updated")],
        name: Annotated[Optional[StrictStr], Field(description="Name of pet that needs to be updated")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Status of pet that needs to be updated")] = None,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> ApiResponse[None]:
        """Updates a pet in the store with form data

        

        :param pet_id: ID of pet that needs to be updated (required)
        :type pet_id: int
        :param name: Name of pet that needs to be updated
        :type name: str
        :param status: Status of pet that needs to be updated
        :type status: str
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_pet_with_form_serialize(
            pet_id=pet_id,
            name=name,
            status=status,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '405': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_pet_with_form_without_preload_content(
        self,
        pet_id: Annotated[StrictInt, Field(description="ID of pet that needs to be updated")],
        name: Annotated[Optional[StrictStr], Field(description="Name of pet that needs to be updated")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Status of pet that needs to be updated")] = None,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> RESTResponseType:
        """Updates a pet in the store with form data

        

        :param pet_id: ID of pet that needs to be updated (required)
        :type pet_id: int
        :param name: Name of pet that needs to be updated
        :type name: str
        :param status: Status of pet that needs to be updated
        :type status: str
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_pet_with_form_serialize(
            pet_id=pet_id,
            name=name,
            status=status,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '405': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        return response_data.response


    def _update_pet_with_form_serialize(
        self,
        pet_id,
        name,
        status,
        request_auth__,
        content_type__,
        headers__,
        host__,
    ) -> RequestSerialized:


        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = headers__ or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if pet_id is not None:
            _path_params['petId'] = pet_id
        # process the query parameters
        if name is not None:
            
            _query_params.append(('name', name))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'petstore_auth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/pet/{petId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            host__=host__,
            request_auth__=request_auth__
        )




    @validate_call
    def upload_file(
        self,
        pet_id: Annotated[StrictInt, Field(description="ID of pet to update")],
        additional_metadata: Annotated[Optional[StrictStr], Field(description="Additional Metadata")] = None,
        body: Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]] = None,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> ApiResponse:
        """uploads an image

        

        :param pet_id: ID of pet to update (required)
        :type pet_id: int
        :param additional_metadata: Additional Metadata
        :type additional_metadata: str
        :param body:
        :type body: bytearray
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._upload_file_serialize(
            pet_id=pet_id,
            additional_metadata=additional_metadata,
            body=body,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ApiResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def upload_file_with_http_info(
        self,
        pet_id: Annotated[StrictInt, Field(description="ID of pet to update")],
        additional_metadata: Annotated[Optional[StrictStr], Field(description="Additional Metadata")] = None,
        body: Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]] = None,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> ApiResponse[ApiResponse]:
        """uploads an image

        

        :param pet_id: ID of pet to update (required)
        :type pet_id: int
        :param additional_metadata: Additional Metadata
        :type additional_metadata: str
        :param body:
        :type body: bytearray
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._upload_file_serialize(
            pet_id=pet_id,
            additional_metadata=additional_metadata,
            body=body,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ApiResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def upload_file_without_preload_content(
        self,
        pet_id: Annotated[StrictInt, Field(description="ID of pet to update")],
        additional_metadata: Annotated[Optional[StrictStr], Field(description="Additional Metadata")] = None,
        body: Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]] = None,
        request_timeout__: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        request_auth__: Optional[Dict[StrictStr, Any]] = None,
        content_type__: Optional[StrictStr] = None,
        headers__: Optional[Dict[StrictStr, Any]] = None,
        host__: Optional[StrictStr] = None,
    ) -> RESTResponseType:
        """uploads an image

        

        :param pet_id: ID of pet to update (required)
        :type pet_id: int
        :param additional_metadata: Additional Metadata
        :type additional_metadata: str
        :param body:
        :type body: bytearray
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._upload_file_serialize(
            pet_id=pet_id,
            additional_metadata=additional_metadata,
            body=body,
            request_auth__=request_auth__,
            content_type__=content_type__,
            headers__=headers__,
            host__=host__
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ApiResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            request_timeout__=request_timeout__
        )
        return response_data.response


    def _upload_file_serialize(
        self,
        pet_id,
        additional_metadata,
        body,
        request_auth__,
        content_type__,
        headers__,
        host__,
    ) -> RequestSerialized:


        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = headers__ or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if pet_id is not None:
            _path_params['petId'] = pet_id
        # process the query parameters
        if additional_metadata is not None:
            
            _query_params.append(('additionalMetadata', additional_metadata))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if body is not None:
            # convert to byte array if the input is a file name (str)
            if isinstance(body, str):
                with open(body, "rb") as _fp:
                    _body_params = _fp.read()
            elif isinstance(body, tuple):
                # drop the filename from the tuple
                _body_params = body[1]
            else:
                _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if content_type__:
            _header_params['Content-Type'] = content_type__
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/octet-stream'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'petstore_auth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/pet/{petId}/uploadImage',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            host__=host__,
            request_auth__=request_auth__
        )


