# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class RestoreDatabaseFromFileRequest(JDCloudRequest):
    """
    从用户通过单库上云工具上传到云上的备份文件中恢复单个数据库<br>- 仅支持SQL Server
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(RestoreDatabaseFromFileRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}/databases/{dbName}:restoreDatabaseFromFile', 'POST', header, version)
        self.parameters = parameters


class RestoreDatabaseFromFileParameters(object):

    def __init__(self, regionId, instanceId, dbName, fileName):
        """
        :param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)
        :param instanceId: RDS 实例ID，唯一标识一个RDS实例
        :param dbName: 库名称
        :param fileName: 用户上传的备份文件名称（包括文件后缀名），例如mydb1.bak
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.dbName = dbName
        self.sharedFileGid = None
        self.fileName = fileName

    def setSharedFileGid(self, sharedFileGid):
        """
        :param sharedFileGid: (Optional) 共享文件的全局ID，可从上传文件查询接口[describeImportFiles](../Cloud-on-Single-Database/describeImportFiles.md)获取；如果该文件不是共享文件，则不用输入该参数
        """
        self.sharedFileGid = sharedFileGid

