import { CfnConnectorProfile } from 'aws-cdk-lib/aws-appflow';
import { Construct } from 'constructs';
import { ConnectorProfileBase, ConnectorProfileProps } from '../core/connectors/connector-profile';
export interface ZendeskConnectorProfileProps extends ConnectorProfileProps {
    readonly oAuth: ZendeskOAuthSettings;
    readonly instanceUrl: string;
}
export interface ZendeskOAuthSettings {
    readonly accessToken?: string;
    readonly clientId: string;
    readonly clientSecret: string;
}
export declare class ZendeskConnectorProfile extends ConnectorProfileBase {
    static fromConnectionProfileArn(scope: Construct, id: string, arn: string): ZendeskConnectorProfile;
    static fromConnectionProfileName(scope: Construct, id: string, name: string): ZendeskConnectorProfile;
    constructor(scope: Construct, id: string, props: ZendeskConnectorProfileProps);
    protected buildConnectorProfileProperties(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfilePropertiesProperty;
    protected buildConnectorProfileCredentials(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfileCredentialsProperty;
}
