"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnowflakeConnectorType = void 0;
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const connector_type_1 = require("../core/connectors/connector-type");
/**
 * @internal
 */
class SnowflakeConnectorType extends connector_type_1.ConnectorType {
    constructor() {
        super('Snowflake', false);
    }
    static get instance() {
        if (!SnowflakeConnectorType.actualInstance) {
            SnowflakeConnectorType.actualInstance = new SnowflakeConnectorType();
        }
        return SnowflakeConnectorType.actualInstance;
    }
}
exports.SnowflakeConnectorType = SnowflakeConnectorType;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHlwZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9zbm93Zmxha2UvdHlwZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQTs7O0VBR0U7QUFDRixzRUFBa0U7QUFFbEU7O0dBRUc7QUFDSCxNQUFhLHNCQUF1QixTQUFRLDhCQUFhO0lBV3ZEO1FBQ0UsS0FBSyxDQUFDLFdBQVcsRUFBRSxLQUFLLENBQUMsQ0FBQztJQUM1QixDQUFDO0lBWE0sTUFBTSxLQUFLLFFBQVE7UUFDeEIsSUFBSSxDQUFDLHNCQUFzQixDQUFDLGNBQWMsRUFBRTtZQUMxQyxzQkFBc0IsQ0FBQyxjQUFjLEdBQUcsSUFBSSxzQkFBc0IsRUFBRSxDQUFDO1NBQ3RFO1FBQ0QsT0FBTyxzQkFBc0IsQ0FBQyxjQUFjLENBQUM7SUFDL0MsQ0FBQztDQU9GO0FBZEQsd0RBY0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENvbm5lY3RvclR5cGUgfSBmcm9tICcuLi9jb3JlL2Nvbm5lY3RvcnMvY29ubmVjdG9yLXR5cGUnO1xuXG4vKipcbiAqIEBpbnRlcm5hbFxuICovXG5leHBvcnQgY2xhc3MgU25vd2ZsYWtlQ29ubmVjdG9yVHlwZSBleHRlbmRzIENvbm5lY3RvclR5cGUge1xuXG4gIHB1YmxpYyBzdGF0aWMgZ2V0IGluc3RhbmNlKCk6IENvbm5lY3RvclR5cGUge1xuICAgIGlmICghU25vd2ZsYWtlQ29ubmVjdG9yVHlwZS5hY3R1YWxJbnN0YW5jZSkge1xuICAgICAgU25vd2ZsYWtlQ29ubmVjdG9yVHlwZS5hY3R1YWxJbnN0YW5jZSA9IG5ldyBTbm93Zmxha2VDb25uZWN0b3JUeXBlKCk7XG4gICAgfVxuICAgIHJldHVybiBTbm93Zmxha2VDb25uZWN0b3JUeXBlLmFjdHVhbEluc3RhbmNlO1xuICB9XG5cbiAgcHJpdmF0ZSBzdGF0aWMgYWN0dWFsSW5zdGFuY2U6IENvbm5lY3RvclR5cGU7XG5cbiAgY29uc3RydWN0b3IoKSB7XG4gICAgc3VwZXIoJ1Nub3dmbGFrZScsIGZhbHNlKTtcbiAgfVxufSJdfQ==