"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnowflakeConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
const connector_profile_1 = require("../core/connectors/connector-profile");
class SnowflakeConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    constructor(scope, id, props) {
        super(scope, id, props, type_1.SnowflakeConnectorType.instance);
        this._location = props.location;
        this._database = props.database;
        this._schema = props.schema ?? SnowflakeConnectorProfile.defaultSchema;
        this.integrationRole = this.tryCreateRole(scope, id, props);
    }
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    // INFO: maybe move it to an external class so that it can be either used here or used in any subsequent deployment?
    tryCreateRole(scope, id, props) {
        const properties = props;
        const integration = properties.integration;
        if (!integration) {
            return undefined;
        }
        // INFO: following https://docs.snowflake.com/en/user-guide/data-load-s3-config-storage-integration#configuring-secure-access-to-cloud-storage
        // TODO: currently, the implementation allows read-only access. Make sure that we don't need the write permissions
        return new aws_iam_1.Role(scope, `${id}IntegrationRole`, {
            assumedBy: new aws_iam_1.ArnPrincipal(integration.storageUserArn),
            externalIds: [integration.externalId],
            inlinePolicies: {
                SnowflakeAccess: new aws_iam_1.PolicyDocument({
                    statements: [
                        new aws_iam_1.PolicyStatement({
                            effect: aws_iam_1.Effect.ALLOW,
                            actions: [
                                's3:GetObject',
                                's3:GetObjectVersion',
                            ],
                            resources: [properties.location.bucket.arnForObjects(properties.location.prefix ?? '*')],
                        }),
                        new aws_iam_1.PolicyStatement({
                            effect: aws_iam_1.Effect.ALLOW,
                            actions: [
                                's3:ListBucket',
                                's3:GetBucketLocation',
                            ],
                            resources: [properties.location.bucket.bucketArn],
                            conditions: {
                                StringLike: {
                                    's3:prefix': [properties.location.prefix ?? '*'],
                                },
                            },
                        }),
                    ],
                }),
            },
        });
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            snowflake: {
                username: properties.basicAuth.username,
                password: properties.basicAuth.password,
            },
        };
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        this.tryAddNodeDependency(this, properties.location.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketReadWrite(properties.location.bucket);
        return {
            snowflake: {
                bucketName: properties.location.bucket.bucketName,
                bucketPrefix: properties.location.prefix,
                stage: `${properties.database}.${properties.schema}.${properties.stage}`,
                warehouse: properties.warehouse,
                accountName: properties.account,
                region: properties.region,
            },
        };
    }
}
exports.SnowflakeConnectorProfile = SnowflakeConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
SnowflakeConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.SnowflakeConnectorProfile", version: "0.0.20" };
/**
 * Default Snowflake schema if no schema provided
 */
SnowflakeConnectorProfile.defaultSchema = 'PUBLIC';
//# sourceMappingURL=data:application/json;base64,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