"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnowflakeDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
/**
 * A Snowflake destination.
 */
class SnowflakeDestination {
    constructor(props) {
        this.props = props;
        this._connectorType = type_1.SnowflakeConnectorType.instance;
    }
    get connectorType() {
        return this._connectorType;
    }
    bind(scope) {
        this.tryAddNodeDependency(scope, this.props.errorHandling?.errorLocation?.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketWrite(this.props.errorHandling?.errorLocation?.bucket);
        this.tryAddNodeDependency(scope, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            destinationConnectorProperties: this.buildDestinationConnectorProperties(),
        };
    }
    buildDestinationConnectorProperties() {
        return {
            snowflake: {
                errorHandlingConfig: this.props.errorHandling && {
                    bucketName: this.props.errorHandling?.errorLocation?.bucket.bucketName,
                    bucketPrefix: this.props.errorHandling?.errorLocation?.prefix,
                    failOnFirstError: this.props.errorHandling.failOnFirstError,
                },
                // TODO: identify if this needs to be the same as the bucketName/prefix in the profile
                //       for now that is the assumption and we're pulling this data from the profile
                intermediateBucketName: this.props.profile._location.bucket.bucketName,
                bucketPrefix: this.props.profile._location.prefix,
                object: this.buildObject(this.props.profile._database, this.props.object.table, this.props.profile._schema),
            },
        };
    }
    buildObject(database, table, schema) {
        return `${database}.${schema}.${table}`;
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== 'string') {
            scope.node.addDependency(resource);
        }
    }
}
exports.SnowflakeDestination = SnowflakeDestination;
_a = JSII_RTTI_SYMBOL_1;
SnowflakeDestination[_a] = { fqn: "@cdklabs/cdk-appflow.SnowflakeDestination", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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