"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SAPOdataConnectorType = void 0;
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const connector_type_1 = require("../core/connectors/connector-type");
/**
 * @internal
 */
class SAPOdataConnectorType extends connector_type_1.ConnectorType {
    constructor() {
        super('SAPOData', false);
    }
    static get instance() {
        if (!SAPOdataConnectorType.actualInstance) {
            SAPOdataConnectorType.actualInstance = new SAPOdataConnectorType();
        }
        return SAPOdataConnectorType.actualInstance;
    }
    get asTaskConnectorOperatorOrigin() {
        return 'sapoData';
    }
    get asProfileConnectorType() {
        return this.name;
    }
}
exports.SAPOdataConnectorType = SAPOdataConnectorType;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHlwZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9zYXBvZGF0YS90eXBlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBOzs7RUFHRTtBQUNGLHNFQUFrRTtBQUVsRTs7R0FFRztBQUNILE1BQWEscUJBQXNCLFNBQVEsOEJBQWE7SUFXdEQ7UUFDRSxLQUFLLENBQUMsVUFBVSxFQUFFLEtBQUssQ0FBQyxDQUFDO0lBQzNCLENBQUM7SUFYTSxNQUFNLEtBQUssUUFBUTtRQUN4QixJQUFJLENBQUMscUJBQXFCLENBQUMsY0FBYyxFQUFFO1lBQ3pDLHFCQUFxQixDQUFDLGNBQWMsR0FBRyxJQUFJLHFCQUFxQixFQUFFLENBQUM7U0FDcEU7UUFDRCxPQUFPLHFCQUFxQixDQUFDLGNBQWMsQ0FBQztJQUM5QyxDQUFDO0lBUUQsSUFBVyw2QkFBNkI7UUFDdEMsT0FBTyxVQUFVLENBQUM7SUFDcEIsQ0FBQztJQUVELElBQVcsc0JBQXNCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQztJQUNuQixDQUFDO0NBQ0Y7QUF0QkQsc0RBc0JDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDb25uZWN0b3JUeXBlIH0gZnJvbSAnLi4vY29yZS9jb25uZWN0b3JzL2Nvbm5lY3Rvci10eXBlJztcblxuLyoqXG4gKiBAaW50ZXJuYWxcbiAqL1xuZXhwb3J0IGNsYXNzIFNBUE9kYXRhQ29ubmVjdG9yVHlwZSBleHRlbmRzIENvbm5lY3RvclR5cGUge1xuXG4gIHB1YmxpYyBzdGF0aWMgZ2V0IGluc3RhbmNlKCk6IENvbm5lY3RvclR5cGUge1xuICAgIGlmICghU0FQT2RhdGFDb25uZWN0b3JUeXBlLmFjdHVhbEluc3RhbmNlKSB7XG4gICAgICBTQVBPZGF0YUNvbm5lY3RvclR5cGUuYWN0dWFsSW5zdGFuY2UgPSBuZXcgU0FQT2RhdGFDb25uZWN0b3JUeXBlKCk7XG4gICAgfVxuICAgIHJldHVybiBTQVBPZGF0YUNvbm5lY3RvclR5cGUuYWN0dWFsSW5zdGFuY2U7XG4gIH1cblxuICBwcml2YXRlIHN0YXRpYyBhY3R1YWxJbnN0YW5jZTogQ29ubmVjdG9yVHlwZTtcblxuICBjb25zdHJ1Y3RvcigpIHtcbiAgICBzdXBlcignU0FQT0RhdGEnLCBmYWxzZSk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGFzVGFza0Nvbm5lY3Rvck9wZXJhdG9yT3JpZ2luKCk6IHN0cmluZyB7XG4gICAgcmV0dXJuICdzYXBvRGF0YSc7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGFzUHJvZmlsZUNvbm5lY3RvclR5cGUoKTogc3RyaW5nIHtcbiAgICByZXR1cm4gdGhpcy5uYW1lO1xuICB9XG59Il19