import { CfnFlow } from 'aws-cdk-lib/aws-appflow';
import { SAPOdataConnectorProfile } from './profile';
import { S3Location } from '../core';
import { ConnectorType } from '../core/connectors/connector-type';
import { ErrorHandlingConfiguration } from '../core/error-handling';
import { IFlow } from '../core/flows';
import { IDestination } from '../core/vertices/destination';
import { WriteOperation } from '../core/write-operation';
export interface SAPOdataSuccessResponseHandlingConfiguration {
    readonly location: S3Location;
}
export interface SAPOdataDestinationProps {
    readonly profile: SAPOdataConnectorProfile;
    /**
     * The settings that determine how Amazon AppFlow handles an error when placing data in the SAPOdata destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure.
     */
    readonly errorHandling?: ErrorHandlingConfiguration;
    readonly successResponseHandling?: SAPOdataSuccessResponseHandlingConfiguration;
    /**
     * The SAPOdata object for which the operation is to be set.
     */
    readonly object: string;
    readonly operation: WriteOperation;
}
export declare class SAPOdataDestination implements IDestination {
    private readonly props;
    readonly connectorType: ConnectorType;
    constructor(props: SAPOdataDestinationProps);
    bind(flow: IFlow): CfnFlow.DestinationFlowConfigProperty;
    private buildDestinationConnectorProperties;
    private tryAddNodeDependency;
}
