"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3Source = exports.S3InputFileType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
/**
 * The file type that Amazon AppFlow gets from your Amazon S3 bucket.
 */
var S3InputFileType;
(function (S3InputFileType) {
    S3InputFileType["CSV"] = "CSV";
    S3InputFileType["JSON"] = "JSON";
})(S3InputFileType = exports.S3InputFileType || (exports.S3InputFileType = {}));
class S3Source {
    constructor(props) {
        this.props = props;
        this.connectorType = type_1.S3ConnectorType.instance;
    }
    bind(scope) {
        this.tryAddNodeDependency(scope, this.props.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketRead(this.props.bucket);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            sourceConnectorProperties: this.buildSourceConnectorProperties(),
        };
    }
    buildSourceConnectorProperties() {
        return {
            s3: {
                bucketName: this.props.bucket.bucketName,
                bucketPrefix: this.props.prefix,
                s3InputFormatConfig: this.props.format && {
                    s3InputFileType: this.props.format.type,
                },
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== 'string') {
            scope.node.addDependency(resource);
        }
    }
}
exports.S3Source = S3Source;
_a = JSII_RTTI_SYMBOL_1;
S3Source[_a] = { fqn: "@cdklabs/cdk-appflow.S3Source", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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