"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicrosoftSharepointOnlineApiVersion = exports.MicrosoftSharepointOnlineTokenUrlBuilder = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
/**
 * A utility class for building Microsoft Online token URLs.
 */
class MicrosoftSharepointOnlineTokenUrlBuilder {
    static buildTokenUrl(tenantId) {
        return `https://login.microsoftonline.com/${tenantId ?? 'common'}/oauth2/v2.0/token`;
    }
}
exports.MicrosoftSharepointOnlineTokenUrlBuilder = MicrosoftSharepointOnlineTokenUrlBuilder;
_a = JSII_RTTI_SYMBOL_1;
MicrosoftSharepointOnlineTokenUrlBuilder[_a] = { fqn: "@cdklabs/cdk-appflow.MicrosoftSharepointOnlineTokenUrlBuilder", version: "0.0.20" };
/**
 * An enum representing the Microsoft Sharepoint Online API versions.
 */
var MicrosoftSharepointOnlineApiVersion;
(function (MicrosoftSharepointOnlineApiVersion) {
    /**
     * Version 1.0
     */
    MicrosoftSharepointOnlineApiVersion["V1"] = "v1.0";
})(MicrosoftSharepointOnlineApiVersion = exports.MicrosoftSharepointOnlineApiVersion || (exports.MicrosoftSharepointOnlineApiVersion = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9taWNyb3NvZnRzaGFyZXBvaW50b25saW5lL3V0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQTs7O0VBR0U7QUFFRjs7R0FFRztBQUNILE1BQWEsd0NBQXdDO0lBQzVDLE1BQU0sQ0FBQyxhQUFhLENBQUMsUUFBaUI7UUFDM0MsT0FBTyxxQ0FBcUMsUUFBUSxJQUFJLFFBQVEsb0JBQW9CLENBQUM7SUFDdkYsQ0FBQzs7QUFISCw0RkFJQzs7O0FBRUQ7O0dBRUc7QUFDSCxJQUFZLG1DQUtYO0FBTEQsV0FBWSxtQ0FBbUM7SUFDN0M7O09BRUc7SUFDSCxrREFBVyxDQUFBO0FBQ2IsQ0FBQyxFQUxXLG1DQUFtQyxHQUFuQywyQ0FBbUMsS0FBbkMsMkNBQW1DLFFBSzlDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5cbi8qKlxuICogQSB1dGlsaXR5IGNsYXNzIGZvciBidWlsZGluZyBNaWNyb3NvZnQgT25saW5lIHRva2VuIFVSTHMuXG4gKi9cbmV4cG9ydCBjbGFzcyBNaWNyb3NvZnRTaGFyZXBvaW50T25saW5lVG9rZW5VcmxCdWlsZGVyIHtcbiAgcHVibGljIHN0YXRpYyBidWlsZFRva2VuVXJsKHRlbmFudElkPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIGBodHRwczovL2xvZ2luLm1pY3Jvc29mdG9ubGluZS5jb20vJHt0ZW5hbnRJZCA/PyAnY29tbW9uJ30vb2F1dGgyL3YyLjAvdG9rZW5gO1xuICB9XG59XG5cbi8qKlxuICogQW4gZW51bSByZXByZXNlbnRpbmcgdGhlIE1pY3Jvc29mdCBTaGFyZXBvaW50IE9ubGluZSBBUEkgdmVyc2lvbnMuXG4gKi9cbmV4cG9ydCBlbnVtIE1pY3Jvc29mdFNoYXJlcG9pbnRPbmxpbmVBcGlWZXJzaW9uIHtcbiAgLyoqXG4gICAqIFZlcnNpb24gMS4wXG4gICAqL1xuICBWMSA9ICd2MS4wJ1xufSJdfQ==