import { CfnFlow } from 'aws-cdk-lib/aws-appflow';
import { MicrosoftSharepointOnlineConnectorProfile } from './profile';
import { ConnectorType } from '../core/connectors/connector-type';
import { IFlow } from '../core/flows';
import { ISource } from '../core/vertices';
/**
 * Represents a list of Microsoft Sharepoint Online site drives from which to retrieve the documents.
 */
export interface MicrosoftSharepointOnlineObject {
    /**
     * The Microsoft Sharepoint Online site from which the documents are to be retrieved.
     *
     * Note: requires full name starting with 'sites/'
     */
    readonly site: string;
    /**
     * An array of Microsoft Sharepoint Online site drives from which the documents are to be retrieved.
     *
     * Note: each drive requires full name starting with 'drives/'
     * @deprecated. This property is deprecated and will be removed in a future release. Use {@link entities} instead
     */
    readonly drives?: string[];
    /**
     * An array of Microsoft Sharepoint Online site entities from which the documents are to be retrieved.
     *
     * Note: each entity requires full name starting with 'drives/' followed by driveID and optional '/items/' followed by itemID
     * @example: 'drives/${driveID}'
     * @example: 'drives/${driveID}/items/${itemID}'
     */
    readonly entities?: string[];
}
/**
 * Properties of a Microsoft Sharepoint Online Source
 */
export interface MicrosoftSharepointOnlineSourceProps {
    readonly profile: MicrosoftSharepointOnlineConnectorProfile;
    readonly apiVersion: string;
    readonly object: MicrosoftSharepointOnlineObject;
}
/**
 * A class that represents a Microsoft Sharepoint Online Source
 */
export declare class MicrosoftSharepointOnlineSource implements ISource {
    private readonly props;
    /**
     * The AppFlow type of the connector that this source is implemented for
     */
    readonly connectorType: ConnectorType;
    constructor(props: MicrosoftSharepointOnlineSourceProps);
    bind(scope: IFlow): CfnFlow.SourceFlowConfigProperty;
    private buildSourceConnectorProperties;
    private tryAddNodeDependency;
}
