"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicrosoftSharepointOnlineConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const util_1 = require("./util");
const connector_authentication_type_1 = require("../core/connectors/connector-authentication-type");
const connector_profile_1 = require("../core/connectors/connector-profile");
const oauth2_granttype_1 = require("../core/connectors/oauth2-granttype");
/**
 * A class that represents a Microsoft Sharepoint Online Connector Profile.
 *
 * This connector profile allows to transfer document libraries residing on a Microsoft Sharepoint Online's site to Amazon S3.
 */
class MicrosoftSharepointOnlineConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    constructor(scope, id, props) {
        super(scope, id, props, type_1.MicrosoftSharepointOnlineConnectorType.instance);
    }
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            customConnector: {
                oAuth2Properties: {
                    // INFO: even if we're using a refresh token grant flow this property is required
                    oAuth2GrantType: oauth2_granttype_1.OAuth2GrantType.AUTHORIZATION_CODE,
                    // INFO: even if we provide only the access token this property is required
                    // TODO: think about if this is correct. token can be IResolvable
                    tokenUrl: properties.oAuth.endpoints?.token ?? MicrosoftSharepointOnlineConnectorProfile.defaultTokenEndpoint,
                },
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                oauth2: {
                    // INFO: when using Refresh Token Grant Flow - access token property is required
                    accessToken: properties.oAuth.accessToken ?? 'dummyAccessToken',
                    refreshToken: properties.oAuth.flow?.refreshTokenGrant.refreshToken,
                    clientId: properties.oAuth.flow?.refreshTokenGrant.clientId,
                    clientSecret: properties.oAuth.flow?.refreshTokenGrant.clientSecret,
                },
                authenticationType: connector_authentication_type_1.ConnectorAuthenticationType.OAUTH2,
            },
        };
    }
}
exports.MicrosoftSharepointOnlineConnectorProfile = MicrosoftSharepointOnlineConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
MicrosoftSharepointOnlineConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.MicrosoftSharepointOnlineConnectorProfile", version: "0.0.20" };
MicrosoftSharepointOnlineConnectorProfile.defaultTokenEndpoint = util_1.MicrosoftSharepointOnlineTokenUrlBuilder.buildTokenUrl();
//# sourceMappingURL=data:application/json;base64,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