"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicrosoftDynamics365ConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const util_1 = require("./util");
const connector_authentication_type_1 = require("../core/connectors/connector-authentication-type");
const connector_profile_1 = require("../core/connectors/connector-profile");
const oauth2_granttype_1 = require("../core/connectors/oauth2-granttype");
/**
 * A class that represents a Microsoft Dynamics 365 Connector Profile.
 *
 * This connector profile allows to transfer document libraries residing on a Microsoft Dynamics 365's site to Amazon S3.
 */
class MicrosoftDynamics365ConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    constructor(scope, id, props) {
        super(scope, id, props, type_1.MicrosoftDynamics365ConnectorType.instance);
    }
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            customConnector: {
                profileProperties: {
                    instanceUrl: properties.instanceUrl,
                },
                oAuth2Properties: {
                    // INFO: even if we're using a refresh token grant flow this property is required
                    oAuth2GrantType: oauth2_granttype_1.OAuth2GrantType.AUTHORIZATION_CODE,
                    // INFO: even if we provide only the access token this property is required
                    // TODO: think about if this is correct. token can be IResolvable
                    tokenUrl: properties.oAuth.endpoints?.token ?? MicrosoftDynamics365ConnectorProfile.defaultTokenEndpoint,
                },
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                oauth2: {
                    // INFO: when using Refresh Token Grant Flow - access token property is required
                    accessToken: properties.oAuth.accessToken ?? 'dummyAccessToken',
                    refreshToken: properties.oAuth.flow?.refreshTokenGrant.refreshToken ?? 'dummyRefreshToken',
                    clientId: properties.oAuth.flow?.refreshTokenGrant.clientId,
                    clientSecret: properties.oAuth.flow?.refreshTokenGrant.clientSecret,
                },
                authenticationType: connector_authentication_type_1.ConnectorAuthenticationType.OAUTH2,
            },
        };
    }
}
exports.MicrosoftDynamics365ConnectorProfile = MicrosoftDynamics365ConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
MicrosoftDynamics365ConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.MicrosoftDynamics365ConnectorProfile", version: "0.0.20" };
MicrosoftDynamics365ConnectorProfile.defaultTokenEndpoint = util_1.MicrosoftDynamics365TokenUrlBuilder.buildTokenUrl();
//# sourceMappingURL=data:application/json;base64,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