import { CfnFlow } from 'aws-cdk-lib/aws-appflow';
import { GoogleAnalytics4ConnectorProfile } from './profile';
import { ConnectorType } from '../core/connectors/connector-type';
import { IFlow } from '../core/flows';
import { ISource } from '../core/vertices';
/**
 * Properties of a Google Analytics v4 Source
 */
export interface GoogleAnalytics4SourceProps {
    readonly profile: GoogleAnalytics4ConnectorProfile;
    readonly apiVersion: string;
    readonly object: string;
}
/**
 * A class that represents a Google Analytics v4 Source
 */
export declare class GoogleAnalytics4Source implements ISource {
    private readonly props;
    /**
     * The AppFlow type of the connector that this source is implemented for
     */
    readonly connectorType: ConnectorType;
    constructor(props: GoogleAnalytics4SourceProps);
    bind(scope: IFlow): CfnFlow.SourceFlowConfigProperty;
    private buildSourceConnectorProperties;
    private tryAddNodeDependency;
}
