"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Validation = exports.ValidationAction = exports.ValidationCondition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const operation_1 = require("./operation");
const tasks_1 = require("./tasks");
/**
 * A representation of a validation condition on a particular field in a flow execution
 */
class ValidationCondition {
    constructor(field, validation) {
        this.field = field;
        this.validation = validation;
    }
    /**
     * Validates whether a particular field in an execution is negative
     * @param field a field for which the validation will be performed
     * @returns a @see ValidationCondition instance
     */
    static isNegative(field) {
        return new ValidationCondition(typeof field === 'string' ? field : field.name, 'VALIDATE_NON_NEGATIVE');
    }
    /**
     * Validates whether a particular field has no value
     * @param field a field for which the validation will be performed
     * @returns a @see ValidationCondition instance
     */
    static isNull(field) {
        return new ValidationCondition(typeof field === 'string' ? field : field.name, 'VALIDATE_NON_NULL');
    }
    // TODO: make sure that you understand what's here
    /**
     *
     * @param field a field for which the validation will be performed
     * @returns a @see ValidationCondition instance
     */
    static isNotNull(field) {
        return new ValidationCondition(typeof field === 'string' ? field : field.name, 'VALIDATE_NUMERIC');
    }
    // TODO: make sure that you understand what's here
    /**
     *
     * @param field a field for which the validation will be performed
     * @returns a @see ValidationCondition instance
     */
    static isDefault(field) {
        return new ValidationCondition(typeof field === 'string' ? field : field.name, 'VALIDATE_NON_ZERO');
    }
}
exports.ValidationCondition = ValidationCondition;
_a = JSII_RTTI_SYMBOL_1;
ValidationCondition[_a] = { fqn: "@cdklabs/cdk-appflow.ValidationCondition", version: "0.0.20" };
class ValidationAction {
    constructor(action) {
        this.action = action;
    }
    /**
     *
     * @returns a @see ValidationAction that removes a record from the flow execution result
     */
    static ignoreRecord() { return new ValidationAction('DropRecord'); }
    /**
     *
     * @returns a @see ValidationAction that terminates the whole flow execution
     */
    static terminateFlow() { return new ValidationAction('DropDataset'); }
}
exports.ValidationAction = ValidationAction;
_b = JSII_RTTI_SYMBOL_1;
ValidationAction[_b] = { fqn: "@cdklabs/cdk-appflow.ValidationAction", version: "0.0.20" };
/**
 * A representation of a validation operation, that is an operation testing records and acting on the test results
 */
class Validation extends operation_1.OperationBase {
    constructor(condition, action) {
        super([new tasks_1.Task('Validate', [condition.field], { operation: condition.validation }, { VALIDATION_ACTION: action.action })]);
        this.condition = condition;
        this.action = action;
    }
    /**
     *
     * @param condition a @see ValidationCondition for the validation
     * @param action a @see ValidationAction for the validation
     * @returns a Validation instance
     */
    static when(condition, action) {
        return new Validation(condition, action);
    }
}
exports.Validation = Validation;
_c = JSII_RTTI_SYMBOL_1;
Validation[_c] = { fqn: "@cdklabs/cdk-appflow.Validation", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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