"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Task = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A representation of a unitary action on the record fields
 */
class Task {
    constructor(type, sourceFields, connectorOperator, properties, destinationField) {
        this.type = type;
        this.sourceFields = sourceFields;
        this.connectorOperator = connectorOperator;
        this.properties = properties;
        this.destinationField = destinationField;
    }
    bind(_flow, source) {
        return {
            taskType: this.type,
            sourceFields: this.sourceFields,
            taskProperties: Object.entries(this.properties).map(([key, value]) => ({ key: key, value: value })),
            connectorOperator: this.buildOperatorFor(source),
            destinationField: this.destinationField,
        };
    }
    buildOperatorFor(source) {
        const operator = {};
        const origin = this.connectorOperator.type?.asTaskConnectorOperatorOrigin ?? source.connectorType.asTaskConnectorOperatorOrigin;
        operator[origin] = this.connectorOperator.operation;
        return operator;
    }
}
exports.Task = Task;
_a = JSII_RTTI_SYMBOL_1;
Task[_a] = { fqn: "@cdklabs/cdk-appflow.Task", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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