"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TriggeredFlowBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const flow_base_1 = require("./flow-base");
/**
 * A base class for triggered flows.
 */
class TriggeredFlowBase extends flow_base_1.FlowBase {
    /**
     *
     * @param scope
     * @param id
     * @param props
     */
    constructor(scope, id, props) {
        super(scope, id, props);
    }
    /**
     *
     * @param autoActivate - a boolean value indicating whether to automatically activate the flow.
     * @param status - a {@link FlowStatus} value indicating the status to set on the flow.
     * @returns
     */
    static setStatus(autoActivate, status) {
        if (autoActivate !== undefined && status !== undefined) {
            throw new Error('Cannot specify both autoActivate and status');
        }
        return autoActivate !== undefined ?
            (autoActivate ? flow_base_1.FlowStatus.ACTIVE : flow_base_1.FlowStatus.SUSPENDED) :
            (status !== undefined ? status : undefined);
    }
}
exports.TriggeredFlowBase = TriggeredFlowBase;
_a = JSII_RTTI_SYMBOL_1;
TriggeredFlowBase[_a] = { fqn: "@cdklabs/cdk-appflow.TriggeredFlowBase", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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