import { OnEventOptions, Schedule } from 'aws-cdk-lib/aws-events';
import { Construct } from 'constructs';
import { DataPullConfig, IFlow, ScheduleProperties } from './flow-base';
import { TriggeredFlowBase, TriggeredFlowBaseProps } from './triggered-flow-base';
export interface OnScheduleFlowProps extends TriggeredFlowBaseProps {
    readonly schedule: Schedule;
    readonly pullConfig: DataPullConfig;
    readonly scheduleProperties?: ScheduleProperties;
}
export declare class OnScheduleFlow extends TriggeredFlowBase implements IFlow {
    constructor(scope: Construct, id: string, props: OnScheduleFlowProps);
    onDeactivated(id: string, options?: OnEventOptions): import("aws-cdk-lib/aws-events").Rule;
}
