from ......Internal.Core import Core
from ......Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class PreviousCls:
	"""Previous commands group definition. 1 total commands, 0 Subgroups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("previous", core, parent)

	def set(self) -> None:
		"""SCPI: [SOURce<HW>]:FSIMulator:MIMO:COPY:PREVious \n
		Snippet: driver.source.fsimulator.mimo.copy.previous.set() \n
		This command copies the matrix values of the current tap to the next lower tap. \n
		"""
		self._core.io.write(f'SOURce<HwInstance>:FSIMulator:MIMO:COPY:PREVious')

	def set_with_opc(self, opc_timeout_ms: int = -1) -> None:
		"""SCPI: [SOURce<HW>]:FSIMulator:MIMO:COPY:PREVious \n
		Snippet: driver.source.fsimulator.mimo.copy.previous.set_with_opc() \n
		This command copies the matrix values of the current tap to the next lower tap. \n
		Same as set, but waits for the operation to complete before continuing further. Use the RsSmw.utilities.opc_timeout_set() to set the timeout value. \n
			:param opc_timeout_ms: Maximum time to wait in milliseconds, valid only for this call."""
		self._core.io.write_with_opc(f'SOURce<HwInstance>:FSIMulator:MIMO:COPY:PREVious', opc_timeout_ms)
