from ......Internal.Core import Core
from ......Internal.CommandsGroup import CommandsGroup
from ......Internal import Conversions
from ...... import repcap


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class BssColorCls:
	"""BssColor commands group definition. 1 total commands, 0 Subgroups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("bssColor", core, parent)

	def set(self, bss_color: int, frameBlock=repcap.FrameBlock.Default) -> None:
		"""SCPI: [SOURce<HW>]:BB:WLNN:FBLock<CH>:BSSColor \n
		Snippet: driver.source.bb.wlnn.fblock.bssColor.set(bss_color = 1, frameBlock = repcap.FrameBlock.Default) \n
		Sets the BSS color, an identifier of the basic service sets (BSS) field. This parameter helps to check if a detected
		frame is coming form an overlapping station. \n
			:param bss_color: integer Range: 0 to 63
			:param frameBlock: optional repeated capability selector. Default value: Nr1 (settable in the interface 'Fblock')
		"""
		param = Conversions.decimal_value_to_str(bss_color)
		frameBlock_cmd_val = self._cmd_group.get_repcap_cmd_value(frameBlock, repcap.FrameBlock)
		self._core.io.write(f'SOURce<HwInstance>:BB:WLNN:FBLock{frameBlock_cmd_val}:BSSColor {param}')

	def get(self, frameBlock=repcap.FrameBlock.Default) -> int:
		"""SCPI: [SOURce<HW>]:BB:WLNN:FBLock<CH>:BSSColor \n
		Snippet: value: int = driver.source.bb.wlnn.fblock.bssColor.get(frameBlock = repcap.FrameBlock.Default) \n
		Sets the BSS color, an identifier of the basic service sets (BSS) field. This parameter helps to check if a detected
		frame is coming form an overlapping station. \n
			:param frameBlock: optional repeated capability selector. Default value: Nr1 (settable in the interface 'Fblock')
			:return: bss_color: integer Range: 0 to 63"""
		frameBlock_cmd_val = self._cmd_group.get_repcap_cmd_value(frameBlock, repcap.FrameBlock)
		response = self._core.io.query_str(f'SOURce<HwInstance>:BB:WLNN:FBLock{frameBlock_cmd_val}:BSSColor?')
		return Conversions.str_to_int(response)
