from ...............Internal.Core import Core
from ...............Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class ApMapCls:
	"""ApMap commands group definition. 4 total commands, 1 Subgroups, 0 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("apMap", core, parent)

	@property
	def ap3000(self):
		"""ap3000 commands group. 1 Sub-classes, 0 commands."""
		if not hasattr(self, '_ap3000'):
			from .Ap3000 import Ap3000Cls
			self._ap3000 = Ap3000Cls(self._core, self._cmd_group)
		return self._ap3000

	def clone(self) -> 'ApMapCls':
		"""Clones the group by creating new object from it and its whole existing subgroups
		Also copies all the existing default Repeated Capabilities setting,
		which you can change independently without affecting the original group"""
		new_group = ApMapCls(self._core, self._cmd_group.parent)
		self._cmd_group.synchronize_repcaps(new_group)
		return new_group
