from .......Internal.Core import Core
from .......Internal.CommandsGroup import CommandsGroup
from .......Internal import Conversions
from ....... import enums


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class FrcCls:
	"""Frc commands group definition. 1 total commands, 0 Subgroups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("frc", core, parent)

	# noinspection PyTypeChecker
	def get_type_py(self) -> enums.FrcType:
		"""SCPI: [SOURce<HW>]:BB:NR5G:TCW:WS:FRC:TYPE \n
		Snippet: value: enums.FrcType = driver.source.bb.nr5G.tcw.ws.frc.get_type_py() \n
		Queries the fixed reference channel (FRC) used. See also 3GPP TS 138 141-1, annex A (normative) : Reference measurement
		channels. \n
			:return: ws_frc: FR1A11| FR1A12| FR1A13| FR1A14| FR1A15| FR1A16| FR1A17| FR1A18| FR1A19| FR2A11| FR2A12| FR2A13| FR2A14| FR2A15| FR1A21| FR1A22| FR1A23| FR1A24| FR1A25| FR1A26| NA| FR1A38| FR1A39| FR1A310| FR1A311| FR1A312| FR1A313| FR1A314| FR1A322| FR1A323| FR1A324| FR1A325| FR1A326| FR1A327| FR1A328| FR1A48| FR1A49| FR1A410| FR1A411| FR1A412| FR1A413| FR1A414| FR1A422| FR1A423| FR1A424| FR1A425| FR1A426| FR1A427| FR1A428| FR1A58| FR1A59| FR1A510| FR1A511| FR1A512| FR1A513| FR1A514| FR1A331| FR1A332| FR2A31| FR2A32| FR2A33| FR2A34| FR2A35| FR2A36| FR2A37| FR2A38| FR2A39| FR2A310| FR2A311| FR2A312| FR2A41| FR2A42| FR2A43| FR2A44| FR2A45| FR2A46| FR2A47| FR2A48| FR2A49| FR2A410| FR2A51| FR2A52| FR2A53| FR2A54| FR2A55| FR2A313| FR2A314| FR2A315| FR2A316| FR2A317| FR2A318| FR2A319| FR2A320| FR2A321| FR2A322| FR2A323| FR2A324| FR2A411| FR2A412| FR2A413| FR2A414| FR2A415| FR2A416| FR2A417| FR2A418| FR2A419| FR2A420| FR2A56| FR2A57| FR2A58| FR2A59| FR2A510| FR1A31| FR1A32| FR1A33| FR1A34| FR1A35| FR1A36| FR1A37| FR1A315| FR1A316| FR1A317| FR1A318| FR1A319| FR1A320| FR1A321| FR1A329| FR1A330| FR1A41| FR1A42| FR1A43| FR1A44| FR1A45| FR1A46| FR1A47| FR1A415| FR1A416| FR1A417| FR1A418| FR1A419| FR1A420| FR1A421| FR1A51| FR1A52| FR1A53| FR1A54| FR1A55| FR1A56| FR1A57| FR1A110| FR1A111| FR1A333| FR1A333A| FR1A334| FR1A334A| FR2A71| FR2A72| FR2A73| FR2A74| FR2A75| FR2A76| FR2A77| FR2A78| FR2A79| FR2A710| FR1A429| FR1A429A| FR1A430| FR1A430A| FR1A431A| FR1A431| FR1A432A| FR1A432| FR1A3A1| FR1A3A2| FR1A3A3| FR1A3A4| FR1A3B1| FR1A3B2| FR1A3B3| FR1A3B4| TS381411_FR1A71| TS381411_FR1A72| TS381411_FR1A73| TS381411_FR1A74| TS381412_FR1A81| TS381412_FR1A82| TS381412_FR1A83| TS381412_FR1A84| FR2A325| FR2A326| FR2A3A1| FR2A3A2| FR2A3A3| FR2A3A4| FR2A3A5| FR2A3A6| FR2A3A7| FR2A3A8| TS38176_FR1A211| TS38176_FR1A212| TS38176_FR1A213| TS38176_FR1A214| TS38176_FR1A215| TS38176_FR1A216| TS38176_FR1A217| TS38176_FR1A218| TS38176_FR1A219| TS38176_FR1A2110| TS38176_FR1A2111| TS38176_FR1A2112| TS38176_FR1A2113| TS38176_FR1A2114| TS38176_FR1A2115| TS38176_FR1A2116| TS38176_FR1A231| TS38176_FR1A232| TS38176_FR1A233| TS38176_FR1A234| TS38176_FR1A235| TS38176_FR1A236| TS38176_FR1A237| TS38176_FR1A238| TS38176_FR1A239| TS38176_FR1A2310| TS38176_FR1A2311| TS38176_FR1A2312| TS38176_FR1A2313| TS38176_FR1A2314| TS38176_FR1A241| TS38176_FR1A242| TS38176_FR1A243| TS38176_FR1A244| TS38176_FR1A245| TS38176_FR1A246| TS38176_FR1A247| TS38176_FR2A211| TS38176_FR2A212| TS38176_FR2A213| TS38176_FR2A214| TS38176_FR2A215| TS38176_FR2A216| TS38176_FR2A217| TS38176_FR2A218| TS38176_FR2A219| TS38176_FR2A2110| TS38176_FR2A2111| TS38176_FR2A2112| TS38176_FR2A2113| TS38176_FR2A2114| TS38176_FR2A2115| TS38176_FR2A2116| TS38176_FR2A2117| TS38176_FR2A2118| TS38176_FR2A2119| TS38176_FR2A2120| TS38176_FR2A2121| TS38176_FR2A2122| TS38176_FR2A2123| TS38176_FR2A2124| TS38176_FR2A221| TS38176_FR2A222| TS38176_FR2A223| TS38176_FR2A224| TS38176_FR2A225| TS38176_FR2A226| TS38176_FR2A227| TS38176_FR2A228| TS38176_FR2A229| TS38176_FR2A2210| TS38176_FR2A231| TS38176_FR2A232| TS38176_FR2A233| TS38176_FR2A234| TS38176_FR2A235| TS38176_FR2A236| TS38176_FR2A237| TS38176_FR2A238| TS38176_FR2A239| TS38176_FR2A2310| TS38176_FR2A2311| TS38176_FR2A2312| TS38176_FR2A2313| TS38176_FR2A2314| TS38176_FR2A2315| TS38176_FR2A2316| TS38176_FR2A2317| TS38176_FR2A2318| TS38176_FR2A2319| TS38176_FR2A2320| TS38176_FR2A241| TS38176_FR2A242| TS38176_FR2A243| TS38176_FR2A244| TS38176_FR2A245| TS38176_FR2A246| TS38176_FR2A247| TS38176_FR2A248| TS38176_FR2A249| TS38176_FR2A2410| FR1A112| FR1A113| FR1A114| FR1A115| FR1A116| FR1A117| FR1A118| FR1A119| FR1A27| FR1A28| FR1A29| FR1A210| FR1A211| FR1A212| FR1A213| FR1A214| FR1A215| FR1A216 FRxAyz: FRC G-FRx-Ay-z
		"""
		response = self._core.io.query_str('SOURce<HwInstance>:BB:NR5G:TCW:WS:FRC:TYPE?')
		return Conversions.str_to_scalar_enum(response, enums.FrcType)

	def set_type_py(self, ws_frc: enums.FrcType) -> None:
		"""SCPI: [SOURce<HW>]:BB:NR5G:TCW:WS:FRC:TYPE \n
		Snippet: driver.source.bb.nr5G.tcw.ws.frc.set_type_py(ws_frc = enums.FrcType.FR1A11) \n
		Queries the fixed reference channel (FRC) used. See also 3GPP TS 138 141-1, annex A (normative) : Reference measurement
		channels. \n
			:param ws_frc: FR1A11| FR1A12| FR1A13| FR1A14| FR1A15| FR1A16| FR1A17| FR1A18| FR1A19| FR2A11| FR2A12| FR2A13| FR2A14| FR2A15| FR1A21| FR1A22| FR1A23| FR1A24| FR1A25| FR1A26| NA| FR1A38| FR1A39| FR1A310| FR1A311| FR1A312| FR1A313| FR1A314| FR1A322| FR1A323| FR1A324| FR1A325| FR1A326| FR1A327| FR1A328| FR1A48| FR1A49| FR1A410| FR1A411| FR1A412| FR1A413| FR1A414| FR1A422| FR1A423| FR1A424| FR1A425| FR1A426| FR1A427| FR1A428| FR1A58| FR1A59| FR1A510| FR1A511| FR1A512| FR1A513| FR1A514| FR1A331| FR1A332| FR2A31| FR2A32| FR2A33| FR2A34| FR2A35| FR2A36| FR2A37| FR2A38| FR2A39| FR2A310| FR2A311| FR2A312| FR2A41| FR2A42| FR2A43| FR2A44| FR2A45| FR2A46| FR2A47| FR2A48| FR2A49| FR2A410| FR2A51| FR2A52| FR2A53| FR2A54| FR2A55| FR2A313| FR2A314| FR2A315| FR2A316| FR2A317| FR2A318| FR2A319| FR2A320| FR2A321| FR2A322| FR2A323| FR2A324| FR2A411| FR2A412| FR2A413| FR2A414| FR2A415| FR2A416| FR2A417| FR2A418| FR2A419| FR2A420| FR2A56| FR2A57| FR2A58| FR2A59| FR2A510| FR1A31| FR1A32| FR1A33| FR1A34| FR1A35| FR1A36| FR1A37| FR1A315| FR1A316| FR1A317| FR1A318| FR1A319| FR1A320| FR1A321| FR1A329| FR1A330| FR1A41| FR1A42| FR1A43| FR1A44| FR1A45| FR1A46| FR1A47| FR1A415| FR1A416| FR1A417| FR1A418| FR1A419| FR1A420| FR1A421| FR1A51| FR1A52| FR1A53| FR1A54| FR1A55| FR1A56| FR1A57| FR1A110| FR1A111| FR1A333| FR1A333A| FR1A334| FR1A334A| FR2A71| FR2A72| FR2A73| FR2A74| FR2A75| FR2A76| FR2A77| FR2A78| FR2A79| FR2A710| FR1A429| FR1A429A| FR1A430| FR1A430A| FR1A431A| FR1A431| FR1A432A| FR1A432| FR1A3A1| FR1A3A2| FR1A3A3| FR1A3A4| FR1A3B1| FR1A3B2| FR1A3B3| FR1A3B4| TS381411_FR1A71| TS381411_FR1A72| TS381411_FR1A73| TS381411_FR1A74| TS381412_FR1A81| TS381412_FR1A82| TS381412_FR1A83| TS381412_FR1A84| FR2A325| FR2A326| FR2A3A1| FR2A3A2| FR2A3A3| FR2A3A4| FR2A3A5| FR2A3A6| FR2A3A7| FR2A3A8| TS38176_FR1A211| TS38176_FR1A212| TS38176_FR1A213| TS38176_FR1A214| TS38176_FR1A215| TS38176_FR1A216| TS38176_FR1A217| TS38176_FR1A218| TS38176_FR1A219| TS38176_FR1A2110| TS38176_FR1A2111| TS38176_FR1A2112| TS38176_FR1A2113| TS38176_FR1A2114| TS38176_FR1A2115| TS38176_FR1A2116| TS38176_FR1A231| TS38176_FR1A232| TS38176_FR1A233| TS38176_FR1A234| TS38176_FR1A235| TS38176_FR1A236| TS38176_FR1A237| TS38176_FR1A238| TS38176_FR1A239| TS38176_FR1A2310| TS38176_FR1A2311| TS38176_FR1A2312| TS38176_FR1A2313| TS38176_FR1A2314| TS38176_FR1A241| TS38176_FR1A242| TS38176_FR1A243| TS38176_FR1A244| TS38176_FR1A245| TS38176_FR1A246| TS38176_FR1A247| TS38176_FR2A211| TS38176_FR2A212| TS38176_FR2A213| TS38176_FR2A214| TS38176_FR2A215| TS38176_FR2A216| TS38176_FR2A217| TS38176_FR2A218| TS38176_FR2A219| TS38176_FR2A2110| TS38176_FR2A2111| TS38176_FR2A2112| TS38176_FR2A2113| TS38176_FR2A2114| TS38176_FR2A2115| TS38176_FR2A2116| TS38176_FR2A2117| TS38176_FR2A2118| TS38176_FR2A2119| TS38176_FR2A2120| TS38176_FR2A2121| TS38176_FR2A2122| TS38176_FR2A2123| TS38176_FR2A2124| TS38176_FR2A221| TS38176_FR2A222| TS38176_FR2A223| TS38176_FR2A224| TS38176_FR2A225| TS38176_FR2A226| TS38176_FR2A227| TS38176_FR2A228| TS38176_FR2A229| TS38176_FR2A2210| TS38176_FR2A231| TS38176_FR2A232| TS38176_FR2A233| TS38176_FR2A234| TS38176_FR2A235| TS38176_FR2A236| TS38176_FR2A237| TS38176_FR2A238| TS38176_FR2A239| TS38176_FR2A2310| TS38176_FR2A2311| TS38176_FR2A2312| TS38176_FR2A2313| TS38176_FR2A2314| TS38176_FR2A2315| TS38176_FR2A2316| TS38176_FR2A2317| TS38176_FR2A2318| TS38176_FR2A2319| TS38176_FR2A2320| TS38176_FR2A241| TS38176_FR2A242| TS38176_FR2A243| TS38176_FR2A244| TS38176_FR2A245| TS38176_FR2A246| TS38176_FR2A247| TS38176_FR2A248| TS38176_FR2A249| TS38176_FR2A2410| FR1A112| FR1A113| FR1A114| FR1A115| FR1A116| FR1A117| FR1A118| FR1A119| FR1A27| FR1A28| FR1A29| FR1A210| FR1A211| FR1A212| FR1A213| FR1A214| FR1A215| FR1A216 FRxAyz: FRC G-FRx-Ay-z
		"""
		param = Conversions.enum_scalar_to_str(ws_frc, enums.FrcType)
		self._core.io.write(f'SOURce<HwInstance>:BB:NR5G:TCW:WS:FRC:TYPE {param}')
