from .......Internal.Core import Core
from .......Internal.CommandsGroup import CommandsGroup
from .......Internal import Conversions


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class AdMrsCls:
	"""AdMrs commands group definition. 1 total commands, 0 Subgroups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("adMrs", core, parent)

	def get_state(self) -> bool:
		"""SCPI: [SOURce<HW>]:BB:NR5G:TCW:WS:ADMRs:STATe \n
		Snippet: value: bool = driver.source.bb.nr5G.tcw.ws.adMrs.get_state() \n
		Enables or disabled the additional DMRS. Additional DMRS signals increase the probability that the UE receives the
		demodulation reference symbols. It leads to a support of lower SNR conditions. \n
			:return: add_dmrs: 1| ON| 0| OFF
		"""
		response = self._core.io.query_str('SOURce<HwInstance>:BB:NR5G:TCW:WS:ADMRs:STATe?')
		return Conversions.str_to_bool(response)

	def set_state(self, add_dmrs: bool) -> None:
		"""SCPI: [SOURce<HW>]:BB:NR5G:TCW:WS:ADMRs:STATe \n
		Snippet: driver.source.bb.nr5G.tcw.ws.adMrs.set_state(add_dmrs = False) \n
		Enables or disabled the additional DMRS. Additional DMRS signals increase the probability that the UE receives the
		demodulation reference symbols. It leads to a support of lower SNR conditions. \n
			:param add_dmrs: 1| ON| 0| OFF
		"""
		param = Conversions.bool_to_str(add_dmrs)
		self._core.io.write(f'SOURce<HwInstance>:BB:NR5G:TCW:WS:ADMRs:STATe {param}')
