from .......Internal.Core import Core
from .......Internal.CommandsGroup import CommandsGroup
from .......Internal import Conversions
from ....... import repcap


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class RpowCls:
	"""Rpow commands group definition. 1 total commands, 0 Subgroups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("rpow", core, parent)

	def set(self, carrier_rel_power: float, cellNull=repcap.CellNull.Nr0) -> None:
		"""SCPI: [SOURce<HW>]:BB:NR5G:NODE:CELL<CH0>:RPOW \n
		Snippet: driver.source.bb.nr5G.node.cell.rpow.set(carrier_rel_power = 1.0, cellNull = repcap.CellNull.Nr0) \n
		No command help available \n
			:param carrier_rel_power: No help available
			:param cellNull: optional repeated capability selector. Default value: Nr0
		"""
		param = Conversions.decimal_value_to_str(carrier_rel_power)
		cellNull_cmd_val = self._cmd_group.get_repcap_cmd_value(cellNull, repcap.CellNull)
		self._core.io.write(f'SOURce<HwInstance>:BB:NR5G:NODE:CELL{cellNull_cmd_val}:RPOW {param}')

	def get(self, cellNull=repcap.CellNull.Nr0) -> float:
		"""SCPI: [SOURce<HW>]:BB:NR5G:NODE:CELL<CH0>:RPOW \n
		Snippet: value: float = driver.source.bb.nr5G.node.cell.rpow.get(cellNull = repcap.CellNull.Nr0) \n
		No command help available \n
			:param cellNull: optional repeated capability selector. Default value: Nr0
			:return: carrier_rel_power: No help available"""
		cellNull_cmd_val = self._cmd_group.get_repcap_cmd_value(cellNull, repcap.CellNull)
		response = self._core.io.query_str(f'SOURce<HwInstance>:BB:NR5G:NODE:CELL{cellNull_cmd_val}:RPOW?')
		return Conversions.str_to_float(response)
