from ........Internal.Core import Core
from ........Internal.CommandsGroup import CommandsGroup
from ........Internal import Conversions
from ........ import repcap


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class StateCls:
	"""State commands group definition. 1 total commands, 0 Subgroups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("state", core, parent)

	def set(self, mcs_table_2_old: bool, userIx=repcap.UserIx.Default) -> None:
		"""SCPI: [SOURce<HW>]:BB:EUTRa:DL:USER<CH>:MCSTwo:STATe \n
		Snippet: driver.source.bb.eutra.downlink.user.mcsTwo.state.set(mcs_table_2_old = False, userIx = repcap.UserIx.Default) \n
		This command is supported for backwards compatibility. Use [:SOURce<hw>]:BB:EUTRa:DL:USER<ch>:CELL<st0>:MCS instead. \n
			:param mcs_table_2_old: 1| ON| 0| OFF
			:param userIx: optional repeated capability selector. Default value: Nr1 (settable in the interface 'User')
		"""
		param = Conversions.bool_to_str(mcs_table_2_old)
		userIx_cmd_val = self._cmd_group.get_repcap_cmd_value(userIx, repcap.UserIx)
		self._core.io.write(f'SOURce<HwInstance>:BB:EUTRa:DL:USER{userIx_cmd_val}:MCSTwo:STATe {param}')

	def get(self, userIx=repcap.UserIx.Default) -> bool:
		"""SCPI: [SOURce<HW>]:BB:EUTRa:DL:USER<CH>:MCSTwo:STATe \n
		Snippet: value: bool = driver.source.bb.eutra.downlink.user.mcsTwo.state.get(userIx = repcap.UserIx.Default) \n
		This command is supported for backwards compatibility. Use [:SOURce<hw>]:BB:EUTRa:DL:USER<ch>:CELL<st0>:MCS instead. \n
			:param userIx: optional repeated capability selector. Default value: Nr1 (settable in the interface 'User')
			:return: mcs_table_2_old: 1| ON| 0| OFF"""
		userIx_cmd_val = self._cmd_group.get_repcap_cmd_value(userIx, repcap.UserIx)
		response = self._core.io.query_str(f'SOURce<HwInstance>:BB:EUTRa:DL:USER{userIx_cmd_val}:MCSTwo:STATe?')
		return Conversions.str_to_bool(response)
