from .........Internal.Core import Core
from .........Internal.CommandsGroup import CommandsGroup
from .........Internal import Conversions
from ......... import repcap


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class PfrHoppCls:
	"""PfrHopp commands group definition. 1 total commands, 0 Subgroups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("pfrHopp", core, parent)

	def set(self, dci_pusch_freq_hop: bool, allocationNull=repcap.AllocationNull.Default) -> None:
		"""SCPI: [SOURce<HW>]:BB:EUTRa:DL:EMTC:DCI:ALLoc<CH0>:PFRHopp \n
		Snippet: driver.source.bb.eutra.downlink.emtc.dci.alloc.pfrHopp.set(dci_pusch_freq_hop = False, allocationNull = repcap.AllocationNull.Default) \n
		Sets the DCI format 6-0A and 6-1A filed frequency hopping flag that applies to PUSCH and PDSCH respectively. \n
			:param dci_pusch_freq_hop: 1| ON| 0| OFF
			:param allocationNull: optional repeated capability selector. Default value: Nr0 (settable in the interface 'Alloc')
		"""
		param = Conversions.bool_to_str(dci_pusch_freq_hop)
		allocationNull_cmd_val = self._cmd_group.get_repcap_cmd_value(allocationNull, repcap.AllocationNull)
		self._core.io.write(f'SOURce<HwInstance>:BB:EUTRa:DL:EMTC:DCI:ALLoc{allocationNull_cmd_val}:PFRHopp {param}')

	def get(self, allocationNull=repcap.AllocationNull.Default) -> bool:
		"""SCPI: [SOURce<HW>]:BB:EUTRa:DL:EMTC:DCI:ALLoc<CH0>:PFRHopp \n
		Snippet: value: bool = driver.source.bb.eutra.downlink.emtc.dci.alloc.pfrHopp.get(allocationNull = repcap.AllocationNull.Default) \n
		Sets the DCI format 6-0A and 6-1A filed frequency hopping flag that applies to PUSCH and PDSCH respectively. \n
			:param allocationNull: optional repeated capability selector. Default value: Nr0 (settable in the interface 'Alloc')
			:return: dci_pusch_freq_hop: 1| ON| 0| OFF"""
		allocationNull_cmd_val = self._cmd_group.get_repcap_cmd_value(allocationNull, repcap.AllocationNull)
		response = self._core.io.query_str(f'SOURce<HwInstance>:BB:EUTRa:DL:EMTC:DCI:ALLoc{allocationNull_cmd_val}:PFRHopp?')
		return Conversions.str_to_bool(response)
