from ......Internal.Core import Core
from ......Internal.CommandsGroup import CommandsGroup
from ......Internal import Conversions


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class BscramblerCls:
	"""Bscrambler commands group definition. 1 total commands, 0 Subgroups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("bscrambler", core, parent)

	def get_state(self) -> bool:
		"""SCPI: [SOURce<HW>]:BB:DVB:DVBS:BSCRambler:[STATe] \n
		Snippet: value: bool = driver.source.bb.dvb.dvbs.bscrambler.get_state() \n
		Activates baseband scrambling. \n
			:return: bscrambler: 1| ON| 0| OFF
		"""
		response = self._core.io.query_str('SOURce<HwInstance>:BB:DVB:DVBS:BSCRambler:STATe?')
		return Conversions.str_to_bool(response)

	def set_state(self, bscrambler: bool) -> None:
		"""SCPI: [SOURce<HW>]:BB:DVB:DVBS:BSCRambler:[STATe] \n
		Snippet: driver.source.bb.dvb.dvbs.bscrambler.set_state(bscrambler = False) \n
		Activates baseband scrambling. \n
			:param bscrambler: 1| ON| 0| OFF
		"""
		param = Conversions.bool_to_str(bscrambler)
		self._core.io.write(f'SOURce<HwInstance>:BB:DVB:DVBS:BSCRambler:STATe {param}')
