<h1 align="center">
  <a href=""><img src="docs/static/img/infrahub-hori.svg" alt="Infrahub" width="350"></a>
</h1>

<p align="center">
<a href="https://www.linkedin.com/company/opsmill">
<img src="https://img.shields.io/badge/linkedin-blue?logo=LinkedIn"/>
</a>
<a href="https://discord.gg/opsmill">
<img src="https://img.shields.io/badge/Discord-7289DA?&logo=discord&logoColor=white"/>
</a>
</p>

Infrahub is a graph-based data management platform with built-in version control, CI workflows, peer review, and API access. It's purpose-built to power network, data center, and cloud automation.

## The data foundation for modern automation

Infrahub provides a single platform that unifies infrastructure data with business logic, enforces consistency, and integrates with automation tools and AI workflows.

With Infrahub as the data foundation in your automation stack, you can move faster, reduce risk, and deliver infrastructure as a reliable service.

## Top ways to use Infrahub

### Unify infrastructure data

Sync network and infrastructure device, service, and policy data into a unified source of truth, with rich metadata and robust UI and API access.

### Automate at scale

Generate, validate, and deploy configurations with unified data. Support full lifecycle management—provisioning, upgrades, decommissioning—across vendors and sites.

### Enable self-service

Expose automation through catalogs and APIs so application, platform, and ops teams can request infrastructure directly. Speed time to delivery, reduce errors, and make infrastructure more responsive to the business.

### Build an AIOps knowledge graph

Model dependencies and relationships across infrastructure. Provide the data foundation for AI-driven reasoning, troubleshooting, and predictive operations.

## Quick Start

[Infrahub Sandbox](https://sandbox.infrahub.app/) - Instantly login to the UI of a demo environment of Infrahub with sample data pre-loaded.

[Getting Started Environment & Tutorial](https://opsmill.instruqt.com/pages/labs) - It spins up an instance of Infrahub on our cloud, provides a browser, terminal, code editor and walks you through the basic concepts:

- Branching and version control
- Flexible schema
- Unified storage

For longer term tests, you can deploy a local instance of Infrahub by referring to our guide: [Installing Infrahub](https://docs.infrahub.app/guides/installation)

## Documentation

If you'd like to learn more about Infrahub, please refer to the following resources:

- [Infrahub Overview](https://docs.infrahub.app/getting-started/overview)
- [Infrahub Documentation](https://docs.infrahub.app/)
- [FAQ](https://docs.infrahub.app/faq/)

## Support and Community

If you need help, support for the community version of Infrahub is provided on [![Join our Discord server](https://img.shields.io/badge/Discord-7289DA?logo=discord&logoColor=white)](https://discord.gg/opsmill) or via [filing an issue on GitHub](https://github.com/opsmill/infrahub/issues).

## Contributing

To help our community with the creation of contributions, please view our [CONTRIBUTING](./CONTRIBUTING.md) page.

<a  href="https://github.com/opsmill/infrahub/graphs/contributors">
<img  src="https://contrib.rocks/image?repo=opsmill/infrahub" />
</a>

## Security

[View our SECURITY](https://github.com/opsmill/infrahub?tab=security-ov-file) policy to find the latest information.
